/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaMethodDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.MethodSignatureChecker;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public final class JavaFunctionResolver {
    private JavaTypeTransformer typeTransformer;
    private JavaResolverCache cache;
    private JavaTypeParameterResolver typeParameterResolver;
    private JavaValueParameterResolver valueParameterResolver;
    private JavaAnnotationResolver annotationResolver;
    private ExternalSignatureResolver externalSignatureResolver;
    private ErrorReporter errorReporter;
    private MethodSignatureChecker signatureChecker;

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setTypeParameterResolver(JavaTypeParameterResolver typeParameterResolver) {
        this.typeParameterResolver = typeParameterResolver;
    }

    public void setValueParameterResolver(JavaValueParameterResolver valueParameterResolver) {
        this.valueParameterResolver = valueParameterResolver;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void setSignatureChecker(MethodSignatureChecker signatureChecker) {
        this.signatureChecker = signatureChecker;
    }

    @Nullable
    SimpleFunctionDescriptor resolveFunctionMutely(@NotNull JavaMethod method, @NotNull ClassOrNamespaceDescriptor owner) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveFunctionMutely"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveFunctionMutely"));
        }
        return this.resolveMethodToFunctionDescriptor(method, owner, false);
    }

    @Nullable
    private SimpleFunctionDescriptor resolveMethodToFunctionDescriptor(@NotNull JavaMethod method, @NotNull ClassOrNamespaceDescriptor ownerDescriptor, boolean record) {
        List<String> signatureErrors;
        ExternalSignatureResolver.AlternativeMethodSignature effectiveSignature;
        List<Object> superFunctions;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveMethodToFunctionDescriptor"));
        }
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveMethodToFunctionDescriptor"));
        }
        if (!DescriptorResolverUtils.isCorrectOwnerForEnumMember(ownerDescriptor, method)) {
            return null;
        }
        JavaType returnJavaType = method.getReturnType();
        if (returnJavaType == null) {
            return null;
        }
        SimpleFunctionDescriptor alreadyResolved = this.cache.getMethod(method);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        JavaMethodDescriptor functionDescriptorImpl = new JavaMethodDescriptor(ownerDescriptor, this.annotationResolver.resolveAnnotations(method), method.getName());
        JavaTypeParameterResolver.Initializer typeParameterInitializer = this.typeParameterResolver.resolveTypeParameters(functionDescriptorImpl, method);
        typeParameterInitializer.initialize();
        List<TypeParameterDescriptor> methodTypeParameters = typeParameterInitializer.getDescriptors();
        TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(methodTypeParameters, functionDescriptorImpl);
        List<ValueParameterDescriptor> valueParameters = this.valueParameterResolver.resolveValueParameters(functionDescriptorImpl, method, typeVariableResolver);
        JetType returnType = this.makeReturnType(returnJavaType, method, typeVariableResolver);
        if (ownerDescriptor instanceof NamespaceDescriptor) {
            superFunctions = Collections.emptyList();
            effectiveSignature = this.externalSignatureResolver.resolveAlternativeMethodSignature(method, false, returnType, null, valueParameters, methodTypeParameters);
            signatureErrors = effectiveSignature.getErrors();
        } else if (ownerDescriptor instanceof ClassDescriptor) {
            ExternalSignatureResolver.PropagatedMethodSignature propagated = this.externalSignatureResolver.resolvePropagatedSignature(method, (ClassDescriptor)ownerDescriptor, returnType, null, valueParameters, methodTypeParameters);
            superFunctions = propagated.getSuperMethods();
            effectiveSignature = this.externalSignatureResolver.resolveAlternativeMethodSignature(method, !superFunctions.isEmpty(), propagated.getReturnType(), propagated.getReceiverType(), propagated.getValueParameters(), propagated.getTypeParameters());
            signatureErrors = new ArrayList<String>(propagated.getErrors());
            signatureErrors.addAll(effectiveSignature.getErrors());
        } else {
            throw new IllegalStateException("Unknown class or namespace descriptor: " + ownerDescriptor);
        }
        functionDescriptorImpl.initialize(effectiveSignature.getReceiverType(), DescriptorUtils.getExpectedThisObjectIfNeeded(ownerDescriptor), effectiveSignature.getTypeParameters(), effectiveSignature.getValueParameters(), effectiveSignature.getReturnType(), Modality.convertFromFlags(method.isAbstract(), !method.isFinal()), method.getVisibility(), false);
        if (record) {
            this.cache.recordMethod(method, functionDescriptorImpl);
        }
        this.signatureChecker.checkSignature(method, record, functionDescriptorImpl, signatureErrors, superFunctions);
        return functionDescriptorImpl;
    }

    @NotNull
    public Set<FunctionDescriptor> resolveFunctionGroupForClass(@NotNull NamedMembers members, @NotNull ClassOrNamespaceDescriptor owner) {
        SamConstructorDescriptor samConstructor;
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveFunctionGroupForClass"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveFunctionGroupForClass"));
        }
        Name methodName = members.getName();
        HashSet<SimpleFunctionDescriptor> functionsFromCurrent = new HashSet<SimpleFunctionDescriptor>();
        for (JavaMethod method : members.getMethods()) {
            SimpleFunctionDescriptor function = this.resolveMethodToFunctionDescriptor(method, owner, true);
            if (function == null) continue;
            functionsFromCurrent.add(function);
            SimpleFunctionDescriptor samAdapter = JavaFunctionResolver.resolveSamAdapter(function);
            if (samAdapter == null) continue;
            functionsFromCurrent.add(samAdapter);
        }
        if (owner instanceof NamespaceDescriptor && (samConstructor = JavaFunctionResolver.resolveSamConstructor((NamespaceDescriptor)owner, members)) != null) {
            functionsFromCurrent.add(samConstructor);
        }
        HashSet<FunctionDescriptor> functions = new HashSet<FunctionDescriptor>();
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            Set<SimpleFunctionDescriptor> functionsFromSupertypes = JavaFunctionResolver.getFunctionsFromSupertypes(methodName, classDescriptor);
            functions.addAll(DescriptorResolverUtils.resolveOverrides(methodName, functionsFromSupertypes, functionsFromCurrent, classDescriptor, this.errorReporter));
        }
        if (DescriptorUtils.isEnumClassObject(owner)) {
            for (SimpleFunctionDescriptor functionDescriptor : functionsFromCurrent) {
                if (DescriptorUtils.isEnumValueOfMethod(functionDescriptor) || DescriptorUtils.isEnumValuesMethod(functionDescriptor)) continue;
                functions.add(functionDescriptor);
            }
        } else {
            functions.addAll(functionsFromCurrent);
        }
        HashSet<FunctionDescriptor> hashSet = functions;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveFunctionGroupForClass"));
        }
        return hashSet;
    }

    @Nullable
    private static JavaClassDescriptor findClassInScope(@NotNull JetScope memberScope, @NotNull Name name) {
        if (memberScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "findClassInScope"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "findClassInScope"));
        }
        ClassifierDescriptor classifier = memberScope.getClassifier(name);
        if (classifier instanceof JavaClassDescriptor) {
            return (JavaClassDescriptor)classifier;
        }
        return null;
    }

    @Nullable
    private static JavaClassDescriptor findClassInNamespace(@NotNull NamespaceDescriptor namespace, @NotNull Name name) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "findClassInNamespace"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "findClassInNamespace"));
        }
        JavaClassDescriptor found = JavaFunctionResolver.findClassInScope(namespace.getMemberScope(), name);
        if (found != null) {
            return found;
        }
        NamespaceDescriptorParent parent = namespace.getContainingDeclaration();
        if (parent instanceof NamespaceDescriptor) {
            JavaClassDescriptor classForCurrentNamespace = JavaFunctionResolver.findClassInNamespace((NamespaceDescriptor)parent, namespace.getName());
            if (classForCurrentNamespace == null) {
                return null;
            }
            return JavaFunctionResolver.findClassInScope(DescriptorUtils.getStaticNestedClassesScope(classForCurrentNamespace), name);
        }
        return null;
    }

    @Nullable
    public static SamConstructorDescriptor resolveSamConstructor(@NotNull NamespaceDescriptor owner, @NotNull NamedMembers namedMembers) {
        JavaClassDescriptor klass;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveSamConstructor"));
        }
        if (namedMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedMembers", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveSamConstructor"));
        }
        if (namedMembers.getSamInterface() != null && (klass = JavaFunctionResolver.findClassInNamespace(owner, namedMembers.getName())) != null) {
            return SingleAbstractMethodUtils.createSamConstructorFunction(owner, klass);
        }
        return null;
    }

    @Nullable
    private static SimpleFunctionDescriptor resolveSamAdapter(@NotNull SimpleFunctionDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "resolveSamAdapter"));
        }
        return SingleAbstractMethodUtils.isSamAdapterNecessary(original) ? (SimpleFunctionDescriptor)((Object)SingleAbstractMethodUtils.createSamAdapterFunction(original)) : null;
    }

    @NotNull
    private JetType makeReturnType(@NotNull JavaType returnType, @NotNull JavaMethod method, @NotNull TypeVariableResolver typeVariableResolver) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "makeReturnType"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "makeReturnType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariableResolver", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "makeReturnType"));
        }
        TypeUsage typeUsage = this.annotationResolver.hasReadonlyAnnotation(method) && !this.annotationResolver.hasMutableAnnotation(method) ? TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT : TypeUsage.MEMBER_SIGNATURE_COVARIANT;
        JetType transformedType = this.typeTransformer.transformToType(returnType, typeUsage, typeVariableResolver);
        if (this.annotationResolver.hasNotNullAnnotation(method)) {
            JetType jetType = TypeUtils.makeNotNullable(transformedType);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "makeReturnType"));
            }
            return jetType;
        }
        JetType jetType = transformedType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "makeReturnType"));
        }
        return jetType;
    }

    @NotNull
    private static Set<SimpleFunctionDescriptor> getFunctionsFromSupertypes(@NotNull Name name, @NotNull ClassDescriptor descriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "getFunctionsFromSupertypes"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "getFunctionsFromSupertypes"));
        }
        LinkedHashSet<SimpleFunctionDescriptor> result = new LinkedHashSet<SimpleFunctionDescriptor>();
        for (JetType supertype : descriptor.getTypeConstructor().getSupertypes()) {
            for (FunctionDescriptor function : supertype.getMemberScope().getFunctions(name)) {
                result.add((SimpleFunctionDescriptor)function);
            }
        }
        LinkedHashSet<SimpleFunctionDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaFunctionResolver", "getFunctionsFromSupertypes"));
        }
        return linkedHashSet;
    }
}

