/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.scope.MembersCache;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.name.Name;

class MembersProvider {
    @Nullable
    private final JavaClass javaClass;
    @Nullable
    private final JavaPackage javaPackage;
    private final boolean staticMembers;
    private MembersCache membersCache;

    private MembersProvider(@Nullable JavaClass javaClass, @Nullable JavaPackage javaPackage, boolean staticMembers) {
        this.javaClass = javaClass;
        this.javaPackage = javaPackage;
        this.staticMembers = staticMembers;
    }

    @NotNull
    public static MembersProvider forPackage(@NotNull JavaPackage javaPackage) {
        if (javaPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaPackage", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "forPackage"));
        }
        MembersProvider membersProvider = new MembersProvider(null, javaPackage, true);
        if (membersProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "forPackage"));
        }
        return membersProvider;
    }

    @NotNull
    public static MembersProvider forClass(@NotNull JavaClass javaClass, boolean staticMembers) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "forClass"));
        }
        MembersProvider membersProvider = new MembersProvider(javaClass, null, staticMembers);
        if (membersProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "forClass"));
        }
        return membersProvider;
    }

    @Nullable
    public NamedMembers get(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "get"));
        }
        return this.getMembersCache().get(name);
    }

    @NotNull
    public Collection<NamedMembers> allMembers() {
        Collection<NamedMembers> collection = this.getMembersCache().allMembers();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "allMembers"));
        }
        return collection;
    }

    @NotNull
    private MembersCache getMembersCache() {
        if (this.membersCache == null) {
            if (this.javaClass != null) {
                this.membersCache = MembersCache.buildForClass(this.javaClass, this.staticMembers);
            } else if (this.javaPackage != null) {
                this.membersCache = MembersCache.buildForPackage(this.javaPackage);
            } else {
                throw new IllegalStateException("MembersProvider should be created either for a class or for a package");
            }
        }
        MembersCache membersCache = this.membersCache;
        if (membersCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersProvider", "getMembersCache"));
        }
        return membersCache;
    }
}

