/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.java.JavaVisibilities;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static boolean isAbstract(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "isAbstract"));
        }
        return owner.getPsi().hasModifierProperty("abstract");
    }

    public static boolean isStatic(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "isStatic"));
        }
        return owner.getPsi().hasModifierProperty("static");
    }

    public static boolean isFinal(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "isFinal"));
        }
        return owner.getPsi().hasModifierProperty("final");
    }

    @NotNull
    public static Visibility getVisibility(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getVisibility"));
        }
        PsiModifierListOwner psiOwner = owner.getPsi();
        if (psiOwner.hasModifierProperty("public")) {
            Visibility visibility = Visibilities.PUBLIC;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getVisibility"));
            }
            return visibility;
        }
        if (psiOwner.hasModifierProperty("private")) {
            Visibility visibility = Visibilities.PRIVATE;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getVisibility"));
            }
            return visibility;
        }
        if (psiOwner.hasModifierProperty("protected")) {
            Visibility visibility = owner.isStatic() ? JavaVisibilities.PROTECTED_STATIC_VISIBILITY : JavaVisibilities.PROTECTED_AND_PACKAGE;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getVisibility"));
            }
            return visibility;
        }
        Visibility visibility = JavaVisibilities.PACKAGE_VISIBILITY;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getVisibility"));
        }
        return visibility;
    }

    @NotNull
    public static Collection<JavaAnnotation> getAnnotations(@NotNull JavaAnnotationOwnerImpl owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getAnnotations"));
        }
        PsiModifierList modifierList = owner.getPsi().getModifierList();
        if (modifierList != null) {
            Collection<JavaAnnotation> collection = JavaElementCollectionFromPsiArrayUtil.annotations(modifierList.getAnnotations());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getAnnotations"));
            }
            return collection;
        }
        List<JavaAnnotation> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "getAnnotations"));
        }
        return list2;
    }

    @Nullable
    public static JavaAnnotation findAnnotation(@NotNull JavaAnnotationOwnerImpl owner, @NotNull FqName fqName) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "findAnnotation"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementUtil", "findAnnotation"));
        }
        PsiModifierList modifierList = owner.getPsi().getModifierList();
        if (modifierList != null) {
            PsiAnnotation psiAnnotation = modifierList.findAnnotation(fqName.asString());
            return psiAnnotation == null ? null : new JavaAnnotationImpl(psiAnnotation);
        }
        return null;
    }
}

