/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class QualifiedNamesUtil {
    private QualifiedNamesUtil() {
    }

    public static boolean isSubpackageOf(@NotNull FqName subpackageName, @NotNull FqName packageName) {
        if (subpackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subpackageName", "org/jetbrains/jet/util/QualifiedNamesUtil", "isSubpackageOf"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/util/QualifiedNamesUtil", "isSubpackageOf"));
        }
        if (subpackageName.equals(packageName)) {
            return true;
        }
        if (packageName.isRoot()) {
            return true;
        }
        String subpackageNameStr = subpackageName.asString();
        String packageNameStr = packageName.asString();
        return QualifiedNamesUtil.isSubpackageOf(subpackageNameStr, packageNameStr);
    }

    public static boolean isOneSegmentFQN(@NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/util/QualifiedNamesUtil", "isOneSegmentFQN"));
        }
        if (fqn.isEmpty()) {
            return false;
        }
        return fqn.indexOf(46) < 0;
    }

    public static boolean isOneSegmentFQN(@NotNull FqName fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/util/QualifiedNamesUtil", "isOneSegmentFQN"));
        }
        return QualifiedNamesUtil.isOneSegmentFQN(fqn.asString());
    }

    @NotNull
    public static String getFirstSegment(@NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/util/QualifiedNamesUtil", "getFirstSegment"));
        }
        int dotIndex = fqn.indexOf(46);
        String string = dotIndex != -1 ? fqn.substring(0, dotIndex) : fqn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "getFirstSegment"));
        }
        return string;
    }

    @NotNull
    public static FqName withoutLastSegment(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/util/QualifiedNamesUtil", "withoutLastSegment"));
        }
        FqName fqName2 = fqName.parent();
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "withoutLastSegment"));
        }
        return fqName2;
    }

    @NotNull
    public static FqName withoutFirstSegment(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/util/QualifiedNamesUtil", "withoutFirstSegment"));
        }
        if (fqName.isRoot() || fqName.parent().isRoot()) {
            FqName fqName2 = FqName.ROOT;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "withoutFirstSegment"));
            }
            return fqName2;
        }
        String fqNameStr = fqName.asString();
        FqName fqName3 = new FqName(fqNameStr.substring(fqNameStr.indexOf(46), fqNameStr.length()));
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "withoutFirstSegment"));
        }
        return fqName3;
    }

    public static int numberOfSegments(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/util/QualifiedNamesUtil", "numberOfSegments"));
        }
        if (fqName.isRoot()) {
            return 0;
        }
        return 1 + QualifiedNamesUtil.numberOfSegments(fqName.parent());
    }

    @NotNull
    public static FqName combine(@NotNull FqName first, @NotNull Name second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/jet/util/QualifiedNamesUtil", "combine"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/jet/util/QualifiedNamesUtil", "combine"));
        }
        FqName fqName = first.child(second);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "combine"));
        }
        return fqName;
    }

    @NotNull
    public static String tail(@NotNull FqName headFQN, @NotNull FqName fullFQN) {
        if (headFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headFQN", "org/jetbrains/jet/util/QualifiedNamesUtil", "tail"));
        }
        if (fullFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFQN", "org/jetbrains/jet/util/QualifiedNamesUtil", "tail"));
        }
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, headFQN) || headFQN.isRoot()) {
            String string = fullFQN.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "tail"));
            }
            return string;
        }
        String string = fullFQN.equals(headFQN) ? "" : fullFQN.asString().substring(headFQN.asString().length() + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/QualifiedNamesUtil", "tail"));
        }
        return string;
    }

    @Nullable
    public static FqName plusOneSegment(@NotNull FqName fqn, @NotNull FqName fullFQN) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/util/QualifiedNamesUtil", "plusOneSegment"));
        }
        if (fullFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFQN", "org/jetbrains/jet/util/QualifiedNamesUtil", "plusOneSegment"));
        }
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, fqn)) {
            return null;
        }
        String nextSegment = QualifiedNamesUtil.getFirstSegment(QualifiedNamesUtil.tail(fqn, fullFQN));
        if (QualifiedNamesUtil.isOneSegmentFQN(nextSegment)) {
            return QualifiedNamesUtil.combine(fqn, Name.guess(nextSegment));
        }
        return null;
    }

    public static boolean isImported(@NotNull ImportPath alreadyImported, @NotNull FqName fqName) {
        if (alreadyImported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadyImported", "org/jetbrains/jet/util/QualifiedNamesUtil", "isImported"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/util/QualifiedNamesUtil", "isImported"));
        }
        if (alreadyImported.hasAlias()) {
            return false;
        }
        if (alreadyImported.isAllUnder() && !fqName.isRoot()) {
            return alreadyImported.fqnPart().equals(fqName.parent());
        }
        return alreadyImported.fqnPart().equals(fqName);
    }

    public static boolean isImported(@NotNull ImportPath alreadyImported, @NotNull ImportPath newImport) {
        if (alreadyImported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadyImported", "org/jetbrains/jet/util/QualifiedNamesUtil", "isImported"));
        }
        if (newImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newImport", "org/jetbrains/jet/util/QualifiedNamesUtil", "isImported"));
        }
        if (newImport.isAllUnder() || newImport.hasAlias()) {
            return alreadyImported.equals(newImport);
        }
        return QualifiedNamesUtil.isImported(alreadyImported, newImport.fqnPart());
    }

    public static boolean isImported(@NotNull Iterable<ImportPath> imports, @NotNull ImportPath newImport) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "org/jetbrains/jet/util/QualifiedNamesUtil", "isImported"));
        }
        if (newImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newImport", "org/jetbrains/jet/util/QualifiedNamesUtil", "isImported"));
        }
        for (ImportPath alreadyImported : imports) {
            if (!QualifiedNamesUtil.isImported(alreadyImported, newImport)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaFqName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        class State {
            State() {
            }
        }
        State BEGINNING = new State();
        State MIDDLE = new State();
        State AFTER_DOT = new State();
        State state = BEGINNING;
        int length = qualifiedName.length();
        for (int i = 0; i < length; ++i) {
            char c = qualifiedName.charAt(i);
            if (state == BEGINNING || state == AFTER_DOT) {
                if (!Character.isJavaIdentifierPart(c)) {
                    return false;
                }
                state = MIDDLE;
            }
            assert (state == MIDDLE);
            if (c == '.') {
                state = AFTER_DOT;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return state != AFTER_DOT;
    }

    public static boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return subpackageNameStr.equals(packageNameStr) || subpackageNameStr.startsWith(packageNameStr) && subpackageNameStr.charAt(packageNameStr.length()) == '.';
    }
}

