/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedPropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class NativePropertyAccessTranslator
extends PropertyAccessTranslator {
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final PropertyDescriptor propertyDescriptor;

    NativePropertyAccessTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "<init>"));
        }
        super(context);
        this.receiver = receiver;
        this.propertyDescriptor = descriptor.getOriginal();
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.translateAsGet(this.getReceiver());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    protected JsExpression translateAsGet(@Nullable JsExpression receiver) {
        JsExpression jsExpression = this.getCallType().constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                JsExpression jsExpression = NativePropertyAccessTranslator.this.doTranslateAsGet(receiver);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator$1", "construct"));
                }
                return jsExpression;
            }
        }, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression doTranslateAsGet(JsExpression receiver) {
        JsName nativePropertyName = this.context().getNameForDescriptor(this.propertyDescriptor);
        if (receiver != null) {
            JsNameRef jsNameRef = new JsNameRef(nativePropertyName, receiver);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "doTranslateAsGet"));
            }
            return jsNameRef;
        }
        JsNameRef jsNameRef = nativePropertyName.makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "doTranslateAsGet"));
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    protected JsExpression translateAsSet(@Nullable JsExpression receiver, final @NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "translateAsSet"));
        }
        assert (receiver != null);
        JsExpression jsExpression = this.getCallType().constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                JsExpression jsExpression = JsAstUtils.assignment(NativePropertyAccessTranslator.this.translateAsGet(receiver), setTo);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator$2", "construct"));
                }
                return jsExpression;
            }
        }, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = this.translateAsSet(this.getReceiver(), setTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getReceiver() {
        if (this.receiver != null) {
            return this.receiver;
        }
        assert (this.propertyDescriptor.getReceiverParameter() == null) : "Can't have native extension properties.";
        DeclarationDescriptor expectedThisDescriptor = JsDescriptorUtils.getExpectedThisDescriptor(this.propertyDescriptor);
        if (expectedThisDescriptor == null) {
            return null;
        }
        return this.context().getThisObject(expectedThisDescriptor);
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        CachedPropertyAccessTranslator cachedPropertyAccessTranslator = new CachedPropertyAccessTranslator(this.getReceiver(), this, this.context());
        if (cachedPropertyAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/NativePropertyAccessTranslator", "getCached"));
        }
        return cachedPropertyAccessTranslator;
    }
}

