/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public final class PsiUtils {
    private PsiUtils() {
    }

    @Nullable
    public static JetSimpleNameExpression getSelectorAsSimpleName(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getSelectorAsSimpleName"));
        }
        JetExpression selectorExpression = PsiUtils.getSelector(expression);
        if (!(selectorExpression instanceof JetSimpleNameExpression)) {
            return null;
        }
        return (JetSimpleNameExpression)selectorExpression;
    }

    @NotNull
    public static JetExpression getSelector(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getSelector"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        assert (selectorExpression != null) : "Selector should not be null.";
        JetExpression jetExpression = selectorExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getSelector"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetSimpleNameExpression getNotNullSimpleNameSelector(@NotNull JetQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getNotNullSimpleNameSelector"));
        }
        JetSimpleNameExpression selectorAsSimpleName = PsiUtils.getSelectorAsSimpleName(expression);
        assert (selectorAsSimpleName != null);
        JetSimpleNameExpression jetSimpleNameExpression = selectorAsSimpleName;
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getNotNullSimpleNameSelector"));
        }
        return jetSimpleNameExpression;
    }

    @NotNull
    public static JetToken getOperationToken(@NotNull JetOperationExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getOperationToken"));
        }
        JetSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType instanceof JetToken) : "Unary expression should have operation token of type JetToken";
        JetToken jetToken = (JetToken)elementType;
        if (jetToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getOperationToken"));
        }
        return jetToken;
    }

    @NotNull
    public static JetExpression getBaseExpression(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getBaseExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetExpression jetExpression = baseExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getBaseExpression"));
        }
        return jetExpression;
    }

    public static boolean isPrefix(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "isPrefix"));
        }
        return expression instanceof JetPrefixExpression;
    }

    public static boolean isAssignment(JetToken token) {
        return token == JetTokens.EQ;
    }

    public static boolean isInOrNotInOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/k2js/translate/utils/PsiUtils", "isInOrNotInOperation"));
        }
        return PsiUtils.isInOperation(binaryExpression) || PsiUtils.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/k2js/translate/utils/PsiUtils", "isNotInOperation"));
        }
        return binaryExpression.getOperationToken() == JetTokens.NOT_IN;
    }

    public static boolean isNegatedOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/k2js/translate/utils/PsiUtils", "isNegatedOperation"));
        }
        return binaryExpression.getOperationToken() == JetTokens.EXCLEQ || PsiUtils.isNotInOperation(binaryExpression);
    }

    private static boolean isInOperation(@NotNull JetBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/k2js/translate/utils/PsiUtils", "isInOperation"));
        }
        return binaryExpression.getOperationToken() == JetTokens.IN_KEYWORD;
    }

    @NotNull
    public static JetExpression getCallee(@NotNull JetCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getCallee"));
        }
        JetExpression calleeExpression = expression.getCalleeExpression();
        assert (calleeExpression != null);
        JetExpression jetExpression = calleeExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getCallee"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetExpression getLoopBody(@NotNull JetLoopExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getLoopBody"));
        }
        JetExpression body = expression.getBody();
        assert (body != null) : "Loops cannot have null bodies.";
        JetExpression jetExpression = body;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getLoopBody"));
        }
        return jetExpression;
    }

    @Nullable
    public static JetParameter getLoopParameter(@NotNull JetForExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getLoopParameter"));
        }
        return expression.getLoopParameter();
    }

    @NotNull
    public static List<JetParameter> getPrimaryConstructorParameters(@NotNull JetClassOrObject classDeclaration) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/k2js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
        }
        if (classDeclaration instanceof JetClass) {
            List<JetParameter> list2 = ((JetClass)classDeclaration).getPrimaryConstructorParameters();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
            }
            return list2;
        }
        List<JetParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
        }
        return list3;
    }

    @NotNull
    public static JetObjectDeclarationName getObjectDeclarationName(@NotNull JetObjectDeclaration objectDeclaration) {
        if (objectDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/k2js/translate/utils/PsiUtils", "getObjectDeclarationName"));
        }
        JetObjectDeclarationName nameAsDeclaration = objectDeclaration.getNameAsDeclaration();
        assert (nameAsDeclaration != null);
        JetObjectDeclarationName jetObjectDeclarationName = nameAsDeclaration;
        if (jetObjectDeclarationName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getObjectDeclarationName"));
        }
        return jetObjectDeclarationName;
    }

    @NotNull
    public static JetExpression getLoopRange(@NotNull JetForExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/PsiUtils", "getLoopRange"));
        }
        JetExpression rangeExpression = expression.getLoopRange();
        assert (rangeExpression != null);
        JetExpression jetExpression = rangeExpression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/PsiUtils", "getLoopRange"));
        }
        return jetExpression;
    }
}

