/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;

public class JsFirstExpressionVisitor
extends RecursiveJsVisitor {
    private boolean needsParentheses = false;

    public static boolean exec(JsExpressionStatement statement) {
        JsExpression expression = statement.getExpression();
        if (expression instanceof JsFunction) {
            return false;
        }
        JsFirstExpressionVisitor visitor = new JsFirstExpressionVisitor();
        visitor.accept(statement.getExpression());
        return visitor.needsParentheses;
    }

    private JsFirstExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(JsArrayAccess x) {
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(JsArrayLiteral x) {
    }

    @Override
    public void visitBinaryExpression(JsBinaryOperation x) {
        this.accept(x.getArg1());
    }

    @Override
    public void visitConditional(JsConditional x) {
        this.accept(x.getTestExpression());
    }

    @Override
    public void visitFunction(JsFunction x) {
        this.needsParentheses = true;
    }

    @Override
    public void visitInvocation(JsInvocation invocation) {
        this.accept(invocation.getQualifier());
    }

    @Override
    public void visitNameRef(JsNameRef nameRef) {
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(JsNew x) {
    }

    @Override
    public void visitObjectLiteral(JsObjectLiteral x) {
        this.needsParentheses = true;
    }

    @Override
    public void visitPostfixOperation(JsPostfixOperation x) {
        this.accept(x.getArg());
    }

    @Override
    public void visitPrefixOperation(JsPrefixOperation x) {
    }
}

