/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsTypeElementImpl
extends ClsElementImpl
implements PsiTypeElement {
    private final PsiElement myParent;
    private final String myTypeText;
    private final char myVariance;
    private final NullableLazyValue<ClsElementImpl> myChild;
    private final NotNullLazyValue<PsiType> myCachedType;

    public ClsTypeElementImpl(@NotNull PsiElement parent, @NotNull String typeText, char variance) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "<init>"));
        }
        if (typeText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "<init>"));
        }
        this.myParent = parent;
        this.myTypeText = TypeInfo.internFrequentType(typeText);
        this.myVariance = variance;
        this.myChild = new VolatileNullableLazyValue<ClsElementImpl>(){

            @Override
            @Nullable
            protected ClsElementImpl compute() {
                return ClsTypeElementImpl.this.calculateChild();
            }
        };
        this.myCachedType = new AtomicNotNullLazyValue<PsiType>(){

            @Override
            @NotNull
            protected PsiType compute() {
                PsiType psiType = ClsTypeElementImpl.this.calculateType();
                if (psiType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsTypeElementImpl$2", "compute"));
                }
                return psiType;
            }
        };
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        ClsElementImpl child = this.myChild.getValue();
        if (child != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = child;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        String shortClassName = PsiNameHelper.getShortClassName(this.myTypeText);
        return this.decorateTypeText(shortClassName);
    }

    private String decorateTypeText(String shortClassName) {
        switch (this.myVariance) {
            case '\u0000': {
                return shortClassName;
            }
            case '+': {
                return "? extends " + shortClassName;
            }
            case '-': {
                return "? super " + shortClassName;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : this.myVariance;
        return null;
    }

    public String getCanonicalText() {
        return this.decorateTypeText(this.myTypeText);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "appendMirrorText"));
        }
        buffer.append(this.decorateTypeText(this.myTypeText));
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.TYPE);
        ClsElementImpl child = this.myChild.getValue();
        if (child != null) {
            child.setMirror(element.getFirstChildNode());
        }
    }

    private boolean isArray() {
        return this.myTypeText.endsWith("[]");
    }

    private boolean isVarArgs() {
        return this.myTypeText.endsWith("...");
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myCachedType.getValue();
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "getType"));
        }
        return psiType;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    private ClsElementImpl calculateChild() {
        if (JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createPrimitiveType(this.myTypeText) != null) {
            return null;
        }
        if (this.isArray()) {
            return this.myVariance == '\u0000' ? new ClsTypeElementImpl(this, this.myTypeText.substring(0, this.myTypeText.length() - 2), this.myVariance) : new ClsTypeElementImpl(this, this.myTypeText, '\u0000');
        }
        if (this.isVarArgs()) {
            return new ClsTypeElementImpl(this, this.myTypeText.substring(0, this.myTypeText.length() - 3), this.myVariance);
        }
        return this.myVariance != '*' ? new ClsJavaCodeReferenceElementImpl(this, this.myTypeText) : null;
    }

    private PsiType calculateType() {
        PsiPrimitiveType result = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createPrimitiveType(this.myTypeText);
        if (result != null) {
            return result;
        }
        ClsElementImpl childElement = this.myChild.getValue();
        if (childElement instanceof ClsTypeElementImpl) {
            if (this.isArray()) {
                switch (this.myVariance) {
                    case '\u0000': {
                        return ((PsiTypeElement)((Object)childElement)).getType().createArrayType();
                    }
                    case '+': {
                        return PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)((Object)childElement)).getType());
                    }
                    case '-': {
                        return PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)((Object)childElement)).getType());
                    }
                }
                assert (false) : this.myVariance;
                return null;
            }
            assert (this.isVarArgs()) : this;
            return new PsiEllipsisType(((PsiTypeElement)((Object)childElement)).getType());
        }
        if (childElement instanceof ClsJavaCodeReferenceElementImpl) {
            PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)((Object)childElement), null);
            switch (this.myVariance) {
                case '\u0000': {
                    return psiClassReferenceType;
                }
                case '+': {
                    return PsiWildcardType.createExtends(this.getManager(), psiClassReferenceType);
                }
                case '-': {
                    return PsiWildcardType.createSuper(this.getManager(), psiClassReferenceType);
                }
                case '*': {
                    return PsiWildcardType.createUnbounded(this.getManager());
                }
            }
            assert (false) : this.myVariance;
            return null;
        }
        assert (childElement == null) : this;
        return PsiWildcardType.createUnbounded(this.getManager());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "addAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsTypeElementImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }
}

