/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import javax.swing.Icon;

public class ClassPresentationProvider
implements ItemPresentationProvider<PsiClass> {
    @Override
    public ItemPresentation getPresentation(final PsiClass psiClass) {
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return ClassPresentationUtil.getNameForClass(psiClass, false);
            }

            public String getLocationString() {
                PsiFile file = psiClass.getContainingFile();
                if (file instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)file;
                    String packageName = classOwner.getPackageName();
                    if (packageName.isEmpty()) {
                        return null;
                    }
                    return "(" + packageName + ")";
                }
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                if (psiClass.isDeprecated()) {
                    return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiClass.getIcon(3);
            }
        };
    }
}

