/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderedSet<T>
extends AbstractList<T>
implements RandomAccess,
Set<T> {
    private final OpenTHashSet<T> myHashSet;
    private final ArrayList<T> myElements;

    public OrderedSet() {
        this(ContainerUtil.canonicalStrategy());
    }

    public OrderedSet(TObjectHashingStrategy<T> hashingStrategy) {
        this(hashingStrategy, 4);
    }

    public OrderedSet(TObjectHashingStrategy<T> hashingStrategy, int capacity) {
        this.myHashSet = new OpenTHashSet<T>(capacity, hashingStrategy);
        this.myElements = new ArrayList(capacity);
    }

    @Override
    public int size() {
        return this.myElements.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.myHashSet.contains(o);
    }

    @Override
    public boolean add(T o) {
        if (this.myHashSet.add(o)) {
            this.myElements.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.myHashSet.remove(o)) {
            this.myElements.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.myHashSet.clear();
        this.myElements.clear();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.myElements.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/OrderedSet", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/OrderedSet", "toArray"));
        }
        T[] TArray = this.myElements.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/OrderedSet", "toArray"));
        }
        return TArray;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return this.myElements.get(index);
    }

    @Override
    public T set(int index, T element) {
        T removed = this.remove(index);
        this.add(index, element);
        return removed;
    }

    @Override
    public void add(int index, T element) {
        if (this.myHashSet.add(element)) {
            this.myElements.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        T t = this.myElements.remove(index);
        this.myHashSet.remove(t);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        int index = this.myHashSet.index(o);
        return index >= 0 ? this.myElements.indexOf(this.myHashSet.get(index)) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.myHashSet.index(o);
        return index >= 0 ? this.myElements.lastIndexOf(this.myHashSet.get(index)) : -1;
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        ListIterator<T> listIterator = this.myElements.listIterator();
        if (listIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/OrderedSet", "listIterator"));
        }
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        ListIterator<T> listIterator = this.myElements.listIterator(index);
        if (listIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/OrderedSet", "listIterator"));
        }
        return listIterator;
    }
}

