/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.LinkedDiffPaths;
import gnu.trove.TIntArrayList;
import java.util.Arrays;

class Reindexer {
    private final int[][] myOldIndecies = new int[2][];
    private final int[] myOriginalLengths = new int[]{-1, -1};

    Reindexer() {
    }

    public int[][] discardUnique(int[] ints1, int[] ints2) {
        int[] discarded1 = this.discard(ints2, ints1, 0);
        return new int[][]{discarded1, this.discard(discarded1, ints2, 1)};
    }

    private int[] discard(int[] needed, int[] toDiscard, int arrayIndex) {
        this.myOriginalLengths[arrayIndex] = toDiscard.length;
        int[] sorted1 = this.createSorted(needed);
        TIntArrayList discarded = new TIntArrayList(toDiscard.length);
        TIntArrayList oldIndecies = new TIntArrayList(toDiscard.length);
        for (int i = 0; i < toDiscard.length; ++i) {
            int index = toDiscard[i];
            if (Arrays.binarySearch(sorted1, index) < 0) continue;
            discarded.add(index);
            oldIndecies.add(i);
        }
        this.myOldIndecies[arrayIndex] = oldIndecies.toNativeArray();
        return discarded.toNativeArray();
    }

    private int[] createSorted(int[] ints1) {
        int[] sorted1 = new int[ints1.length];
        System.arraycopy(ints1, 0, sorted1, 0, ints1.length);
        Arrays.sort(sorted1);
        return sorted1;
    }

    public void reindex(LinkedDiffPaths paths, LCSBuilder builder) {
        final boolean[] changes1 = new boolean[this.myOriginalLengths[0]];
        final boolean[] changes2 = new boolean[this.myOriginalLengths[1]];
        Arrays.fill(changes1, true);
        Arrays.fill(changes2, true);
        paths.decodePath(new LCSBuilder(){
            private int x;
            private int y;
            private int originalX;
            private int originalY;
            {
                this.x = Reindexer.this.myOldIndecies[0].length - 1;
                this.y = Reindexer.this.myOldIndecies[1].length - 1;
                this.originalX = Reindexer.this.myOriginalLengths[0] - 1;
                this.originalY = Reindexer.this.myOriginalLengths[1] - 1;
            }

            @Override
            public void addChange(int first, int second) {
                this.x -= first;
                this.y -= second;
                this.originalX = Reindexer.this.markChanged(changes1, this.originalX, Reindexer.this.myOldIndecies[0], this.x);
                this.originalY = Reindexer.this.markChanged(changes2, this.originalY, Reindexer.this.myOldIndecies[1], this.y);
            }

            @Override
            public void addEqual(int length) {
                for (int i = length; i > 0; --i) {
                    this.originalX = Reindexer.this.markChanged(changes1, this.originalX, Reindexer.this.myOldIndecies[0], this.x);
                    this.originalY = Reindexer.this.markChanged(changes2, this.originalY, Reindexer.this.myOldIndecies[1], this.y);
                    --this.x;
                    --this.y;
                    changes1[this.originalX] = false;
                    changes2[this.originalY] = false;
                    --this.originalX;
                    --this.originalY;
                }
            }
        });
        int x = 0;
        int y = 0;
        while (x < changes1.length && y < changes2.length) {
            int startX = x;
            while (x < changes1.length && y < changes2.length && !changes1[x] && !changes2[y]) {
                ++x;
                ++y;
            }
            if (x > startX) {
                builder.addEqual(x - startX);
            }
            int dx = 0;
            int dy = 0;
            while (x < changes1.length && changes1[x]) {
                ++dx;
                ++x;
            }
            while (y < changes2.length && changes2[y]) {
                ++dy;
                ++y;
            }
            if (dx == 0 && dy == 0) continue;
            builder.addChange(dx, dy);
        }
        if (x != changes1.length || y != changes2.length) {
            builder.addChange(changes1.length - x, changes2.length - y);
        }
    }

    private int markChanged(boolean[] changes, int from, int[] oldIndecies, int newTo) {
        int oldTo = newTo != -1 ? oldIndecies[newTo] : -1;
        for (int i = from; i > oldTo; --i) {
            changes[i] = true;
        }
        return oldTo;
    }
}

