/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.ByteIterator;
import jet.ByteProgressionIterator;
import jet.Progression;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class ByteRange
implements Range<Byte>,
Progression<Byte> {
    public static final ByteRange EMPTY = new ByteRange(1, 0);
    private final byte start;
    private final byte end;

    public ByteRange(byte start, byte end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Byte item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public boolean contains(byte item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Byte getStart() {
        return this.start;
    }

    @Override
    public Byte getEnd() {
        return this.end;
    }

    @Override
    public Integer getIncrement() {
        return 1;
    }

    public ByteIterator iterator() {
        return new ByteProgressionIterator(this.start, this.end, 1);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteRange range = (ByteRange)o;
        return this.end == range.end && this.start == range.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }
}

