/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.TypeCastException;
import jet.Unit;
import jet.inline;
import jet.runtime.ArrayIterator;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$1;
import kotlin.KotlinPackage$sortBy$sortBy$1;
import kotlin.KotlinPackage$sum$1;
import kotlin.KotlinPackage$sum$2;
import kotlin.KotlinPackage$sum$3;
import kotlin.KotlinPackage$sum$4;
import kotlin.KotlinPackage$sum$5;
import kotlin.KotlinPackage$sum$6;
import kotlin.KotlinPackage-Arrays-5540bdac;
import kotlin.KotlinPackage-IterablesSpecial-4f1cf42e;
import kotlin.KotlinPackage-Maps-e4d92eef;
import kotlin.KotlinPackage-OrderingJVM-4763a71b;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinPackageFragment(abiVersion=13)
public final class KotlinPackage-_Arrays-c9ceb4b5 {
    @inline
    public static final <T> boolean all(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            if (predicate.invoke(element).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @inline
    public static final <T> boolean any(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            if (!predicate.invoke(element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final <T> void appendString(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="buffer") @NotNull Appendable buffer, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(Object[] objectArray, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_Arrays-c9ceb4b5.appendString(objectArray, appendable, string, string2, string3, n, string4);
    }

    @inline
    public static final <T> int count(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            T element = $receiver[i];
            if (predicate.invoke(element).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @NotNull
    public static final <T> List<T> drop(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_Arrays-c9ceb4b5.dropWhile($receiver, KotlinPackage-IterablesSpecial-4f1cf42e.countTo(n));
    }

    @inline
    @NotNull
    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @inline
    @NotNull
    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull L result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            T element = $receiver[i];
            if (!(start != 0 ? predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T> List<T> filter(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @inline
    @NotNull
    public static final <T> List<T> filterNot(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final <T> List<T> filterNotNull(@JetValueParameter(name="$receiver") T[] $receiver) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.filterNotNullTo($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            Object object2 = predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            Object object2 = predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @Nullable
    public static final <T> T find(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            if (!predicate.invoke(element).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @inline
    @NotNull
    public static final <T, R> List<R> flatMap(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @inline
    @NotNull
    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            Iterable<R> list2 = transform.invoke(element);
            for (R r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @inline
    @Nullable
    public static final <T, R> R fold(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="initial") @Nullable R initial, @JetValueParameter(name="operation") @NotNull Function2<? super R, ? super T, ? extends R> operation) {
        R answer = initial;
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    @inline
    @Nullable
    public static final <T, R> R foldRight(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="initial") @Nullable R initial, @JetValueParameter(name="operation") @NotNull Function2<? super T, ? super R, ? extends R> operation) {
        R r = initial;
        int index = $receiver.length - 1;
        while (index >= 0) {
            r = operation.invoke($receiver[index--], r);
        }
        return r;
    }

    @inline
    @NotNull
    public static final <T> void forEach(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super T, ? extends Unit> operation) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            operation.invoke(element);
        }
    }

    @inline
    @NotNull
    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        return KotlinPackage-_Arrays-c9ceb4b5.groupByTo($receiver, new HashMap(), toKey);
    }

    @inline
    @NotNull
    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull Map<K, List<T>> result, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            K key = toKey.invoke(element);
            List<T> list2 = KotlinPackage-Maps-e4d92eef.getOrPut(result, key, KotlinPackage$groupByTo$list$1.instance$);
            list2.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> String makeString(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_Arrays-c9ceb4b5.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(Object[] objectArray, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_Arrays-c9ceb4b5.makeString(objectArray, string, string2, string3, n, string4);
    }

    @inline
    @NotNull
    public static final <T, R> List<R> map(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @inline
    @NotNull
    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            T item = $receiver[i];
            result.add(transform.invoke(item));
        }
        return result;
    }

    @Nullable
    public static final <T extends Comparable<? super T>> T max(@JetValueParameter(name="$receiver") T[] $receiver) {
        Comparable max = null;
        for (int i = 0; i < $receiver.length; ++i) {
            boolean bl;
            T e = $receiver[i];
            boolean bl2 = true;
            if (max != null) {
                bl2 = false;
            }
            if (!bl2) {
                Comparable comparable = max;
                if (comparable == null) {
                    Intrinsics.throwNpe();
                }
                bl = comparable.compareTo(e) < 0;
            } else {
                bl = true;
            }
            if (!bl) continue;
            max = e;
        }
        return (T)max;
    }

    /*
     * WARNING - void declaration
     */
    @inline
    @Nullable
    public static final <R extends Comparable<? super R>, T> T maxBy(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        if (KotlinPackage-Arrays-5540bdac.isEmpty($receiver)) {
            return null;
        }
        T maxElem = $receiver[0];
        Comparable maxValue = (Comparable)f.invoke(maxElem);
        int n = 1;
        int n2 = KotlinPackage-Arrays-5540bdac.getLastIndex($receiver);
        if (n <= n2) {
            while (true) {
                void i;
                T e;
                Comparable v;
                if (maxValue.compareTo(v = (Comparable)f.invoke(e = $receiver[i])) < 0) {
                    maxElem = e;
                    maxValue = v;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return maxElem;
    }

    @Nullable
    public static final <T extends Comparable<? super T>> T min(@JetValueParameter(name="$receiver") T[] $receiver) {
        Comparable min = null;
        for (int i = 0; i < $receiver.length; ++i) {
            boolean bl;
            T e = $receiver[i];
            boolean bl2 = true;
            if (min != null) {
                bl2 = false;
            }
            if (!bl2) {
                Comparable comparable = min;
                if (comparable == null) {
                    Intrinsics.throwNpe();
                }
                bl = comparable.compareTo(e) > 0;
            } else {
                bl = true;
            }
            if (!bl) continue;
            min = e;
        }
        return (T)min;
    }

    /*
     * WARNING - void declaration
     */
    @inline
    @Nullable
    public static final <R extends Comparable<? super R>, T> T minBy(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        boolean bl = true;
        if ($receiver.length != 0) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        T minElem = $receiver[0];
        Comparable minValue = (Comparable)f.invoke(minElem);
        int n = 1;
        int n2 = KotlinPackage-Arrays-5540bdac.getLastIndex($receiver);
        if (n <= n2) {
            while (true) {
                void i;
                T e;
                Comparable v;
                if (minValue.compareTo(v = (Comparable)f.invoke(e = $receiver[i])) > 0) {
                    minElem = e;
                    minValue = v;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return minElem;
    }

    @inline
    @NotNull
    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            boolean bl = predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="collection") @NotNull Iterable<? extends T> collection) {
        return KotlinPackage-_Arrays-c9ceb4b5.plus($receiver, collection.iterator());
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="element") @Nullable T element) {
        ArrayList<T> answer = new ArrayList<T>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)answer);
        answer.add(element);
        return answer;
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="iterator") @NotNull Iterator<? extends T> iterator2) {
        ArrayList<T> answer = new ArrayList<T>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)answer);
        Iterator<T> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            T element = iterator3.next();
            answer.add(element);
        }
        return answer;
    }

    @inline
    @Nullable
    public static final <T> T reduce(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = ArrayIterator.iterator($receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        T result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    @inline
    @Nullable
    public static final <T> T reduceRight(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super T, ? super T, ? extends T> operation) {
        int index = $receiver.length - 1;
        if (index < 0) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        T r = $receiver[index--];
        while (index >= 0) {
            r = operation.invoke($receiver[index--], r);
        }
        return r;
    }

    @NotNull
    public static final <T> T[] requireNoNulls(@JetValueParameter(name="$receiver") T[] $receiver) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            boolean bl = true;
            if (element != null) {
                bl = false;
            }
            if (!bl) continue;
            throw (Throwable)new IllegalArgumentException("null element found in " + $receiver);
        }
        if ($receiver == null) {
            throw new TypeCastException("jet.Array<out T?> cannot be cast to jet.Array<out T>");
        }
        return $receiver;
    }

    @NotNull
    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver") T[] $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @inline
    @NotNull
    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-4763a71b.comparator(new KotlinPackage$sortBy$sortBy$1(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @NotNull
    public static final <T> List<T> take(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_Arrays-c9ceb4b5.takeWhile($receiver, KotlinPackage-IterablesSpecial-4f1cf42e.countTo(n));
    }

    @inline
    @NotNull
    public static final <T> List<T> takeWhile(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        T element;
        for (int i = 0; i < $receiver.length && predicate.invoke(element = $receiver[i]).booleanValue(); ++i) {
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver") T[] $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            T element = $receiver[i];
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver") T[] $receiver) {
        return (LinkedList)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)new LinkedList());
    }

    @NotNull
    public static final <T> List<T> toList(@JetValueParameter(name="$receiver") T[] $receiver) {
        return (ArrayList)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver") T[] $receiver) {
        return (LinkedHashSet)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @NotNull
    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver") T[] $receiver) {
        return (TreeSet)KotlinPackage-_Arrays-c9ceb4b5.toCollection($receiver, (Collection)new TreeSet());
    }

    @NotNull
    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver") T[] $receiver) {
        return new IndexIterator<T>(ArrayIterator.iterator($receiver));
    }

    public static final int sum(@JetValueParameter(name="$receiver") Byte[] $receiver) {
        return ((Number)KotlinPackage-_Arrays-c9ceb4b5.fold((Object[])$receiver, 0, KotlinPackage$sum$1.instance$)).intValue();
    }

    public static final int sum(@JetValueParameter(name="$receiver") Short[] $receiver) {
        return ((Number)KotlinPackage-_Arrays-c9ceb4b5.fold((Object[])$receiver, 0, KotlinPackage$sum$2.instance$)).intValue();
    }

    public static final int sum(@JetValueParameter(name="$receiver") Integer[] $receiver) {
        return ((Number)KotlinPackage-_Arrays-c9ceb4b5.fold((Object[])$receiver, 0, KotlinPackage$sum$3.instance$)).intValue();
    }

    public static final long sum(@JetValueParameter(name="$receiver") Long[] $receiver) {
        return ((Number)KotlinPackage-_Arrays-c9ceb4b5.fold((Object[])$receiver, Long.valueOf(0), KotlinPackage$sum$4.instance$)).longValue();
    }

    public static final float sum(@JetValueParameter(name="$receiver") Float[] $receiver) {
        return ((Number)KotlinPackage-_Arrays-c9ceb4b5.fold((Object[])$receiver, Float.valueOf(0.0f), KotlinPackage$sum$5.instance$)).floatValue();
    }

    public static final double sum(@JetValueParameter(name="$receiver") Double[] $receiver) {
        return ((Number)KotlinPackage-_Arrays-c9ceb4b5.fold((Object[])$receiver, 0.0, KotlinPackage$sum$6.instance$)).doubleValue();
    }
}

