/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.JavaSerializerExtension;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.NamespacePartCodegen;
import org.jetbrains.jet.codegen.ScriptCodegen;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.descriptors.serialization.BitEncoding;
import org.jetbrains.jet.descriptors.serialization.DescriptorSerializer;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class NamespaceCodegen
extends MemberCodegen {
    @NotNull
    private final ClassBuilderOnDemand v;
    @NotNull
    private final FqName name;
    @NotNull
    private final Collection<JetFile> files;
    private final NamespaceDescriptor descriptor;

    public NamespaceCodegen(@NotNull ClassBuilderOnDemand v, final @NotNull FqName fqName, @NotNull GenerationState state, @NotNull Collection<JetFile> namespaceFiles) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/NamespaceCodegen", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/NamespaceCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/NamespaceCodegen", "<init>"));
        }
        if (namespaceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceFiles", "org/jetbrains/jet/codegen/NamespaceCodegen", "<init>"));
        }
        super(state, null);
        NamespaceCodegen.checkAllFilesHaveSameNamespace(namespaceFiles);
        this.v = v;
        this.name = fqName;
        this.files = namespaceFiles;
        this.descriptor = state.getBindingContext().get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, this.name);
        assert (this.descriptor != null) : "No namespace found for FQ name " + this.name;
        final PsiFile sourceFile = namespaceFiles.size() == 1 ? namespaceFiles.iterator().next().getContainingFile() : null;
        v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

            @Override
            public void doSomething(@NotNull ClassBuilder v) {
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/NamespaceCodegen$1", "doSomething"));
                }
                v.defineClass(sourceFile, 50, 17, JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(fqName)).getInternalName(), null, "java/lang/Object", new String[0]);
                if (sourceFile != null) {
                    v.visitSource(sourceFile.getName(), null);
                }
            }
        });
    }

    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/NamespaceCodegen", "generate"));
        }
        ArrayList<JvmSerializationBindings> bindings = new ArrayList<JvmSerializationBindings>(this.files.size() + 1);
        boolean shouldGeneratePackageClass = NamespaceCodegen.shouldGenerateNSClass(this.files);
        if (shouldGeneratePackageClass) {
            bindings.add(this.v.getClassBuilder().getSerializationBindings());
        }
        for (JetFile file : this.files) {
            try {
                ClassBuilder builder = this.generate(file);
                if (builder == null) continue;
                bindings.add(builder.getSerializationBindings());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
        if (shouldGeneratePackageClass) {
            this.writeKotlinPackageAnnotationIfNeeded(JvmSerializationBindings.union(bindings));
        }
        assert (this.v.isActivated() == shouldGeneratePackageClass) : "Different algorithms for generating namespace class and for heuristics for: " + this.name.asString();
    }

    private void writeKotlinPackageAnnotationIfNeeded(@NotNull JvmSerializationBindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/jet/codegen/NamespaceCodegen", "writeKotlinPackageAnnotationIfNeeded"));
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        for (JetFile file : this.files) {
            if (!file.isScript()) continue;
            return;
        }
        DescriptorSerializer serializer = new DescriptorSerializer(new JavaSerializerExtension(bindings));
        ProtoBuf.Package packageProto = serializer.packageProto(this.descriptor).build();
        if (packageProto.getMemberCount() == 0) {
            return;
        }
        PackageData data2 = new PackageData(NameSerializationUtil.createNameResolver(serializer.getNameTable()), packageProto);
        AnnotationVisitor av = this.v.getClassBuilder().newAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), true);
        av.visit("abiVersion", 13);
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(data2.toBytes())) {
            array.visit(null, string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    @Nullable
    private ClassBuilder generate(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/NamespaceCodegen", "generate"));
        }
        boolean generateSrcClass = false;
        FieldOwnerContext packageFragmentContext = CodegenContext.STATIC.intoNamespace(this.descriptor);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
                generateSrcClass = true;
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                if (!this.state.isGenerateDeclaredClasses()) continue;
                this.generateClassOrObject((JetClassOrObject)declaration);
                continue;
            }
            if (!(declaration instanceof JetScript)) continue;
            ScriptCodegen.createScriptCodegen((JetScript)declaration, this.state, packageFragmentContext).generate();
        }
        if (!generateSrcClass) {
            return null;
        }
        Type packageFragmentType = NamespaceCodegen.getNamespacePartType(PackageClassUtils.getPackageClassFqName(this.name), file.getVirtualFile());
        ClassBuilder builder = this.state.getFactory().forPackageFragment(packageFragmentType, file);
        new NamespacePartCodegen(builder, file, packageFragmentType, packageFragmentContext, this.state).generate();
        FieldOwnerContext namespaceFacade = CodegenContext.STATIC.intoNamespaceFacade(packageFragmentType, this.descriptor);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (!(declaration instanceof JetNamedFunction) && !(declaration instanceof JetProperty)) continue;
            this.genFunctionOrProperty(namespaceFacade, (JetTypeParameterListOwner)declaration, this.v.getClassBuilder());
        }
        return builder;
    }

    public void generateClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/codegen/NamespaceCodegen", "generateClassOrObject"));
        }
        FieldOwnerContext context = CodegenContext.STATIC.intoNamespace(this.descriptor);
        this.genClassOrObject(context, classOrObject);
    }

    public static boolean shouldGenerateNSClass(@NotNull Collection<JetFile> namespaceFiles) {
        if (namespaceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceFiles", "org/jetbrains/jet/codegen/NamespaceCodegen", "shouldGenerateNSClass"));
        }
        NamespaceCodegen.checkAllFilesHaveSameNamespace(namespaceFiles);
        for (JetFile file : namespaceFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkAllFilesHaveSameNamespace(Collection<JetFile> namespaceFiles) {
        FqName commonFqName = null;
        for (JetFile file : namespaceFiles) {
            FqName fqName = JetPsiUtil.getFQName(file);
            if (commonFqName != null) {
                if (commonFqName.equals(fqName)) continue;
                throw new IllegalArgumentException("All files should have same package name");
            }
            commonFqName = JetPsiUtil.getFQName(file);
        }
    }

    public void done() {
        this.v.done();
    }

    @NotNull
    public static Type getNamespacePartType(@NotNull FqName facadeFqName, @NotNull VirtualFile file) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/jet/codegen/NamespaceCodegen", "getNamespacePartType"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/NamespaceCodegen", "getNamespacePartType"));
        }
        String fileName = FileUtil.getNameWithoutExtension(PathUtil.getFileName(file.getName()));
        String srcName = facadeFqName.shortName().asString() + "-" + NamespaceCodegen.replaceSpecialSymbols(fileName) + "-" + Integer.toHexString(CodegenUtil.getPathHashCode(file));
        FqName srcFqName = facadeFqName.parent().child(Name.identifier(srcName));
        Type type = AsmUtil.asmTypeByFqNameWithoutInnerClasses(srcFqName);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/NamespaceCodegen", "getNamespacePartType"));
        }
        return type;
    }

    @NotNull
    private static String replaceSpecialSymbols(@NotNull String str2) {
        if (str2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/jet/codegen/NamespaceCodegen", "replaceSpecialSymbols"));
        }
        String string = str2.replace('.', '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/NamespaceCodegen", "replaceSpecialSymbols"));
        }
        return string;
    }

    @NotNull
    public static String getNamespacePartInternalName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/NamespaceCodegen", "getNamespacePartInternalName"));
        }
        FqName packageFqName = JetPsiUtil.getFQName(file);
        String string = NamespaceCodegen.getNamespacePartType(PackageClassUtils.getPackageClassFqName(packageFqName), file.getVirtualFile()).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/NamespaceCodegen", "getNamespacePartInternalName"));
        }
        return string;
    }
}

