/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.WhenChecker;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class JetControlFlowProcessor {
    private final JetControlFlowBuilder builder = new JetControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public JetControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    public Pseudocode generatePseudocode(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode).postProcess();
        for (LocalDeclarationInstruction localDeclarationInstruction : pseudocode.getLocalDeclarations()) {
            ((PseudocodeImpl)localDeclarationInstruction.getBody()).postProcess();
        }
        return pseudocode;
    }

    private Pseudocode generate(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(false);
        if (subroutine instanceof JetDeclarationWithBody) {
            JetDeclarationWithBody declarationWithBody = (JetDeclarationWithBody)subroutine;
            List<JetParameter> valueParameters = declarationWithBody.getValueParameters();
            for (JetParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            JetExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        return this.builder.exitSubroutine(subroutine);
    }

    private void processLocalDeclaration(@NotNull JetDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "processLocalDeclaration"));
        }
        Label afterDeclaration = this.builder.createUnboundLabel();
        this.builder.nondeterministicJump(afterDeclaration);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends JetVisitorVoid {
        private final boolean inCondition;
        private final JetVisitorVoid conditionVisitor = new JetVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(@NotNull JetWhenConditionInRange condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRange"));
                }
                CFPVisitor.this.generateInstructions(condition.getRangeExpression(), CFPVisitor.this.inCondition);
                CFPVisitor.this.generateInstructions(condition.getOperationReference(), CFPVisitor.this.inCondition);
            }

            @Override
            public void visitWhenConditionIsPattern(@NotNull JetWhenConditionIsPattern condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPattern"));
                }
            }

            @Override
            public void visitWhenConditionWithExpression(@NotNull JetWhenConditionWithExpression condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpression"));
                }
                CFPVisitor.this.generateInstructions(condition.getExpression(), CFPVisitor.this.inCondition);
            }

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitJetElement"));
                }
                throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element.toString());
            }
        };

        private CFPVisitor(boolean inCondition) {
            this.inCondition = inCondition;
        }

        public void generateInstructions(@Nullable JetElement element) {
            this.generateInstructions(element, this.inCondition);
        }

        private void generateInstructions(@Nullable JetElement element, boolean inCondition) {
            if (element == null) {
                return;
            }
            CFPVisitor visitor = this.inCondition == inCondition ? this : new CFPVisitor(inCondition);
            element.accept(visitor);
            this.checkNothingType(element);
        }

        private void checkNothingType(JetElement element) {
            if (!(element instanceof JetExpression)) {
                return;
            }
            JetExpression expression = JetPsiUtil.deparenthesize((JetExpression)element);
            if (expression instanceof JetStatementExpression || expression instanceof JetTryExpression || expression instanceof JetIfExpression || expression instanceof JetWhenExpression) {
                return;
            }
            JetType type = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
            if (type != null && KotlinBuiltIns.getInstance().isNothing(type)) {
                JetControlFlowProcessor.this.builder.jumpToError();
            }
        }

        @Override
        public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParenthesizedExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
            JetExpression innerExpression = expression.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression, this.inCondition);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnnotatedExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression, this.inCondition);
            }
        }

        @Override
        public void visitThisExpression(@NotNull JetThisExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThisExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitConstantExpression(@NotNull JetConstantExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitConstantExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitSimpleNameExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitLabelQualifiedExpression(@NotNull JetLabelQualifiedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabelQualifiedExpression"));
            }
            String labelName = expression.getLabelName();
            JetExpression labeledExpression = expression.getLabeledExpression();
            if (labelName != null && labeledExpression != null) {
                this.visitLabeledExpression(labelName, labeledExpression);
            }
        }

        private void visitLabeledExpression(@NotNull String labelName, @NotNull JetExpression labeledExpression) {
            if (labelName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            if (labeledExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            JetExpression deparenthesized = JetPsiUtil.deparenthesize(labeledExpression);
            if (deparenthesized != null) {
                this.generateInstructions(labeledExpression, this.inCondition);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryExpression"));
            }
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            JetExpression right = expression.getRight();
            if (operationType == JetTokens.ANDAND) {
                this.generateInstructions(expression.getLeft(), true);
                Label resultLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jumpOnFalse(resultLabel);
                if (right != null) {
                    this.generateInstructions(right, true);
                }
                JetControlFlowProcessor.this.builder.bindLabel(resultLabel);
                if (!this.inCondition) {
                    JetControlFlowProcessor.this.builder.read(expression);
                }
            } else if (operationType == JetTokens.OROR) {
                this.generateInstructions(expression.getLeft(), true);
                Label resultLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jumpOnTrue(resultLabel);
                if (right != null) {
                    this.generateInstructions(right, true);
                }
                JetControlFlowProcessor.this.builder.bindLabel(resultLabel);
                if (!this.inCondition) {
                    JetControlFlowProcessor.this.builder.read(expression);
                }
            } else if (operationType == JetTokens.EQ) {
                JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
                if (right != null) {
                    this.generateInstructions(right, false);
                }
                if (left instanceof JetSimpleNameExpression) {
                    JetControlFlowProcessor.this.builder.write(expression, left);
                } else if (left instanceof JetArrayAccessExpression) {
                    JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)left;
                    this.visitAssignToArrayAccess(expression, arrayAccessExpression);
                } else if (left instanceof JetQualifiedExpression) {
                    JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)left;
                    this.generateInstructions(qualifiedExpression.getReceiverExpression(), false);
                    this.generateInstructions(expression.getOperationReference(), false);
                    JetControlFlowProcessor.this.builder.write(expression, left);
                } else {
                    JetControlFlowProcessor.this.builder.unsupported(expression);
                }
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
                if (left != null) {
                    this.generateInstructions(left, false);
                }
                if (right != null) {
                    this.generateInstructions(right, false);
                }
                if (left instanceof JetSimpleNameExpression || left instanceof JetArrayAccessExpression) {
                    this.generateInstructions(expression.getOperationReference(), false);
                    JetControlFlowProcessor.this.builder.write(expression, left);
                } else if (left != null) {
                    JetControlFlowProcessor.this.builder.unsupported(expression);
                }
            } else if (operationType == JetTokens.ELVIS) {
                JetControlFlowProcessor.this.builder.read(expression);
                this.generateInstructions(expression.getLeft(), false);
                this.generateInstructions(expression.getOperationReference(), false);
                Label afterElvis = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetControlFlowProcessor.this.builder.jumpOnTrue(afterElvis);
                if (right != null) {
                    this.generateInstructions(right, false);
                }
                JetControlFlowProcessor.this.builder.bindLabel(afterElvis);
            } else {
                this.generateInstructions(expression.getLeft(), false);
                if (right != null) {
                    this.generateInstructions(right, false);
                }
                this.generateInstructions(expression.getOperationReference(), false);
                JetControlFlowProcessor.this.builder.read(expression);
            }
        }

        private void visitAssignToArrayAccess(JetBinaryExpression expression, JetArrayAccessExpression arrayAccessExpression) {
            for (JetExpression index : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index, false);
            }
            this.generateInstructions(arrayAccessExpression.getArrayExpression(), false);
            this.generateInstructions(expression.getOperationReference(), false);
            JetControlFlowProcessor.this.builder.write(expression, arrayAccessExpression);
        }

        @Override
        public void visitUnaryExpression(@NotNull JetUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitUnaryExpression"));
            }
            JetSimpleNameExpression operationSign = expression.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (JetTokens.LABELS.contains(operationType)) {
                String referencedName = operationSign.getReferencedName();
                this.visitLabeledExpression(referencedName.substring(1), baseExpression);
            } else {
                this.generateInstructions(baseExpression, false);
                this.generateInstructions(operationSign, false);
                boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
                if (incrementOrDecrement) {
                    JetControlFlowProcessor.this.builder.write(expression, baseExpression);
                }
                JetControlFlowProcessor.this.builder.read(expression);
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull JetIfExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIfExpression"));
            }
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, true);
            }
            Label elseLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
            JetControlFlowProcessor.this.builder.jumpOnFalse(elseLabel);
            JetExpression thenBranch = expression.getThen();
            if (thenBranch != null) {
                this.generateInstructions(thenBranch, this.inCondition);
            } else {
                JetControlFlowProcessor.this.builder.readUnit(expression);
            }
            Label resultLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
            JetControlFlowProcessor.this.builder.jump(resultLabel);
            JetControlFlowProcessor.this.builder.bindLabel(elseLabel);
            JetExpression elseBranch = expression.getElse();
            if (elseBranch != null) {
                this.generateInstructions(elseBranch, this.inCondition);
            } else {
                JetControlFlowProcessor.this.builder.readUnit(expression);
            }
            JetControlFlowProcessor.this.builder.bindLabel(resultLabel);
        }

        @Override
        public void visitTryExpression(@NotNull JetTryExpression expression) {
            List<JetCatchClause> catchClauses;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTryExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
            JetFinallySection finallyBlock = expression.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            if (finallyBlock != null) {
                JetControlFlowProcessor.this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            boolean hasCatches = !(catchClauses = expression.getCatchClauses()).isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = JetControlFlowProcessor.this.builder.createUnboundLabel("onException");
                JetControlFlowProcessor.this.builder.nondeterministicJump(onException);
            }
            Label onExceptionToFinallyBlock = null;
            if (finallyBlock != null) {
                onExceptionToFinallyBlock = JetControlFlowProcessor.this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                JetControlFlowProcessor.this.builder.nondeterministicJump(onExceptionToFinallyBlock);
            }
            this.generateInstructions(expression.getTryBlock(), this.inCondition);
            ArrayList allowDeadLabels = Lists.newArrayList();
            if (hasCatches) {
                Label afterCatches = JetControlFlowProcessor.this.builder.createUnboundLabel("afterCatches");
                JetControlFlowProcessor.this.builder.jump(afterCatches);
                JetControlFlowProcessor.this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(JetControlFlowProcessor.this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    JetControlFlowProcessor.this.builder.nondeterministicJump(catchLabels);
                }
                boolean isFirst = true;
                for (JetCatchClause catchClause : catchClauses) {
                    JetExpression catchBody;
                    if (!isFirst) {
                        JetControlFlowProcessor.this.builder.bindLabel(catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    JetParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        JetControlFlowProcessor.this.builder.declare(catchParameter);
                        JetControlFlowProcessor.this.builder.write(catchParameter, catchParameter);
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody, false);
                    }
                    JetControlFlowProcessor.this.builder.jump(afterCatches);
                }
                JetControlFlowProcessor.this.builder.bindLabel(afterCatches);
            }
            if (finallyBlock != null) {
                JetControlFlowProcessor.this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = JetControlFlowProcessor.this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                JetControlFlowProcessor.this.builder.jump(skipFinallyToErrorBlock);
                JetControlFlowProcessor.this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                JetControlFlowProcessor.this.builder.jumpToError();
                JetControlFlowProcessor.this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
        }

        @Override
        public void visitWhileExpression(@NotNull JetWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhileExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
            LoopInfo loopInfo = JetControlFlowProcessor.this.builder.enterLoop(expression, null, null);
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, true);
            }
            boolean conditionIsTrueConstant = false;
            if (condition instanceof JetConstantExpression && condition.getNode().getElementType() == JetNodeTypes.BOOLEAN_CONSTANT && BooleanValue.TRUE == new CompileTimeConstantResolver().getBooleanValue((JetConstantExpression)condition, KotlinBuiltIns.getInstance().getBooleanType())) {
                conditionIsTrueConstant = true;
            }
            if (!conditionIsTrueConstant) {
                JetControlFlowProcessor.this.builder.jumpOnFalse(loopInfo.getExitPoint());
            }
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, false);
            }
            JetControlFlowProcessor.this.builder.jump(loopInfo.getEntryPoint());
            JetControlFlowProcessor.this.builder.exitLoop(expression);
            JetControlFlowProcessor.this.builder.readUnit(expression);
        }

        @Override
        public void visitDoWhileExpression(@NotNull JetDoWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDoWhileExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
            LoopInfo loopInfo = JetControlFlowProcessor.this.builder.enterLoop(expression, null, null);
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, false);
            }
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, true);
            }
            JetControlFlowProcessor.this.builder.jumpOnTrue(loopInfo.getEntryPoint());
            JetControlFlowProcessor.this.builder.exitLoop(expression);
            JetControlFlowProcessor.this.builder.readUnit(expression);
        }

        @Override
        public void visitForExpression(@NotNull JetForExpression expression) {
            JetParameter loopParameter;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitForExpression"));
            }
            JetControlFlowProcessor.this.builder.read(expression);
            JetExpression loopRange = expression.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange, false);
            }
            if ((loopParameter = expression.getLoopParameter()) != null) {
                this.generateInstructions(loopParameter, this.inCondition);
            } else {
                JetMultiDeclaration multiParameter = expression.getMultiParameter();
                this.generateInstructions(multiParameter, this.inCondition);
            }
            Label loopExitPoint = JetControlFlowProcessor.this.builder.createUnboundLabel();
            Label conditionEntryPoint = JetControlFlowProcessor.this.builder.createUnboundLabel();
            JetControlFlowProcessor.this.builder.bindLabel(conditionEntryPoint);
            JetControlFlowProcessor.this.builder.nondeterministicJump(loopExitPoint);
            LoopInfo loopInfo = JetControlFlowProcessor.this.builder.enterLoop(expression, loopExitPoint, conditionEntryPoint);
            JetControlFlowProcessor.this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, false);
            }
            JetControlFlowProcessor.this.builder.nondeterministicJump(loopInfo.getEntryPoint());
            JetControlFlowProcessor.this.builder.exitLoop(expression);
            JetControlFlowProcessor.this.builder.readUnit(expression);
        }

        @Override
        public void visitBreakExpression(@NotNull JetBreakExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBreakExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                JetControlFlowProcessor.this.builder.jump(JetControlFlowProcessor.this.builder.getExitPoint(loop));
            }
        }

        @Override
        public void visitContinueExpression(@NotNull JetContinueExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitContinueExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                JetControlFlowProcessor.this.builder.jump(JetControlFlowProcessor.this.builder.getEntryPoint(loop));
            }
        }

        private JetElement getCorrespondingLoop(JetLabelQualifiedExpression expression) {
            JetElement loop;
            String labelName = expression.getLabelName();
            if (labelName != null) {
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof JetLoopExpression) {
                    loop = (JetLoopExpression)labeledElement;
                } else {
                    JetControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = JetControlFlowProcessor.this.builder.getCurrentLoop();
                if (loop == null) {
                    JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                }
            }
            return loop;
        }

        @Override
        public void visitReturnExpression(@NotNull JetReturnExpression expression) {
            JetElement subroutine;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitReturnExpression"));
            }
            JetExpression returnedExpression = expression.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression, false);
            }
            JetSimpleNameExpression labelElement = expression.getTargetLabel();
            String labelName = expression.getLabelName();
            if (labelElement != null) {
                assert (labelName != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof JetElement);
                    subroutine = (JetElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = JetControlFlowProcessor.this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof JetFunction || subroutine instanceof JetPropertyAccessor) {
                if (returnedExpression == null) {
                    JetControlFlowProcessor.this.builder.returnNoValue(expression, subroutine);
                } else {
                    JetControlFlowProcessor.this.builder.returnValue(expression, subroutine);
                }
            }
        }

        @Override
        public void visitParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParameter"));
            }
            JetControlFlowProcessor.this.builder.declare(parameter);
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                this.generateInstructions(defaultValue, this.inCondition);
            }
            JetControlFlowProcessor.this.builder.write(parameter, parameter);
        }

        @Override
        public void visitBlockExpression(@NotNull JetBlockExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBlockExpression"));
            }
            List<JetElement> statements = expression.getStatements();
            for (JetElement statement : statements) {
                this.generateInstructions(statement, false);
            }
            if (statements.isEmpty()) {
                JetControlFlowProcessor.this.builder.readUnit(expression);
            }
        }

        @Override
        public void visitNamedFunction(@NotNull JetNamedFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitNamedFunction"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(function);
        }

        @Override
        public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitFunctionLiteralExpression"));
            }
            JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
            JetControlFlowProcessor.this.processLocalDeclaration(functionLiteral);
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull JetQualifiedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitQualifiedExpression"));
            }
            this.generateInstructions(expression.getReceiverExpression(), false);
            JetExpression selectorExpression = expression.getSelectorExpression();
            if (selectorExpression != null) {
                this.generateInstructions(selectorExpression, false);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        private void visitCall(JetCallElement call) {
            for (ValueArgument valueArgument : call.getValueArguments()) {
                JetExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression, false);
            }
            for (JetExpression jetExpression : call.getFunctionLiteralArguments()) {
                this.generateInstructions(jetExpression, false);
            }
        }

        @Override
        public void visitCallExpression(@NotNull JetCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitCallExpression"));
            }
            for (JetTypeProjection typeArgument : expression.getTypeArguments()) {
                this.generateInstructions(typeArgument, false);
            }
            this.visitCall(expression);
            this.generateInstructions(expression.getCalleeExpression(), false);
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitProperty(@NotNull JetProperty property2) {
            JetExpression delegate;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitProperty"));
            }
            JetControlFlowProcessor.this.builder.declare(property2);
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.generateInstructions(initializer, false);
                JetControlFlowProcessor.this.builder.write(property2, property2);
            }
            if ((delegate = property2.getDelegateExpression()) != null) {
                this.generateInstructions(delegate, false);
            }
            for (JetPropertyAccessor accessor : property2.getAccessors()) {
                this.generateInstructions(accessor, false);
            }
        }

        @Override
        public void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            JetExpression initializer = declaration.getInitializer();
            if (initializer != null) {
                this.generateInstructions(initializer, false);
            }
            List<JetMultiDeclarationEntry> entries = declaration.getEntries();
            for (JetMultiDeclarationEntry entry : entries) {
                JetControlFlowProcessor.this.builder.declare(entry);
                JetControlFlowProcessor.this.builder.write(entry, entry);
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull JetPropertyAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitPropertyAccessor"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            if (operationType == JetTokens.COLON || operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
                this.generateInstructions(expression.getLeft(), false);
                JetControlFlowProcessor.this.builder.read(expression);
            } else {
                this.visitJetElement(expression);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull JetThrowExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThrowExpression"));
            }
            JetExpression thrownExpression = expression.getThrownExpression();
            if (thrownExpression != null) {
                this.generateInstructions(thrownExpression, false);
            }
            JetControlFlowProcessor.this.builder.throwException(expression);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitArrayAccessExpression"));
            }
            for (JetExpression index : expression.getIndexExpressions()) {
                this.generateInstructions(index, false);
            }
            this.generateInstructions(expression.getArrayExpression(), false);
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitIsExpression(@NotNull JetIsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIsExpression"));
            }
            this.generateInstructions(expression.getLeftHandSide(), this.inCondition);
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitWhenExpression(@NotNull JetWhenExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhenExpression"));
            }
            JetExpression subjectExpression = expression.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression, this.inCondition);
            }
            boolean hasElse = false;
            Label doneLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
            Label nextLabel = null;
            Iterator<JetWhenEntry> iterator2 = expression.getEntries().iterator();
            while (iterator2.hasNext()) {
                JetWhenEntry whenEntry = iterator2.next();
                JetControlFlowProcessor.this.builder.read(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse) {
                    hasElse = true;
                    if (iterator2.hasNext()) {
                        JetControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                    }
                }
                Label bodyLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    JetWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    JetControlFlowProcessor.this.builder.nondeterministicJump(bodyLabel);
                }
                if (!isElse) {
                    nextLabel = JetControlFlowProcessor.this.builder.createUnboundLabel();
                    JetControlFlowProcessor.this.builder.nondeterministicJump(nextLabel);
                }
                JetControlFlowProcessor.this.builder.bindLabel(bodyLabel);
                this.generateInstructions(whenEntry.getExpression(), this.inCondition);
                JetControlFlowProcessor.this.builder.jump(doneLabel);
                if (isElse) continue;
                JetControlFlowProcessor.this.builder.bindLabel(nextLabel);
            }
            JetControlFlowProcessor.this.builder.bindLabel(doneLabel);
            if (!hasElse && WhenChecker.mustHaveElse(expression, JetControlFlowProcessor.this.trace)) {
                JetControlFlowProcessor.this.trace.report(Errors.NO_ELSE_IN_WHEN.on(expression));
            }
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpression"));
            }
            JetObjectDeclaration declaration = expression.getObjectDeclaration();
            this.generateInstructions(declaration, this.inCondition);
            List<JetDeclaration> declarations = declaration.getDeclarations();
            ArrayList<JetDeclaration> functions = Lists.newArrayList();
            for (JetDeclaration localDeclaration : declarations) {
                if (localDeclaration instanceof JetProperty || localDeclaration instanceof JetClassInitializer) continue;
                functions.add(localDeclaration);
            }
            for (JetDeclaration function : functions) {
                this.generateInstructions(function, this.inCondition);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitObjectDeclaration(@NotNull JetObjectDeclaration objectDeclaration) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectDeclaration"));
            }
            this.visitClassOrObject(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitStringTemplateExpression"));
            }
            for (JetStringTemplateEntry entry : expression.getEntries()) {
                if (!(entry instanceof JetStringTemplateEntryWithExpression)) continue;
                JetStringTemplateEntryWithExpression entryWithExpression = (JetStringTemplateEntryWithExpression)entry;
                this.generateInstructions(entryWithExpression.getExpression(), false);
            }
            JetControlFlowProcessor.this.builder.read(expression);
        }

        @Override
        public void visitTypeProjection(@NotNull JetTypeProjection typeProjection) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTypeProjection"));
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull JetClassInitializer classInitializer) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnonymousInitializer"));
            }
            this.generateInstructions(classInitializer.getBody(), this.inCondition);
        }

        private void visitClassOrObject(JetClassOrObject classOrObject) {
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                this.generateInstructions(specifier, this.inCondition);
            }
            List<JetDeclaration> declarations = classOrObject.getDeclarations();
            for (JetDeclaration declaration : declarations) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetClassInitializer)) continue;
                this.generateInstructions(declaration, this.inCondition);
            }
        }

        @Override
        public void visitClass(@NotNull JetClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitClass"));
            }
            List<JetParameter> parameters = klass.getPrimaryConstructorParameters();
            for (JetParameter parameter : parameters) {
                this.generateInstructions(parameter, this.inCondition);
            }
            this.visitClassOrObject(klass);
        }

        @Override
        public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperCallSpecifier"));
            }
            List<? extends ValueArgument> valueArguments = call.getValueArguments();
            for (ValueArgument valueArgument : valueArguments) {
                this.generateInstructions(valueArgument.getArgumentExpression(), this.inCondition);
            }
        }

        @Override
        public void visitDelegationByExpressionSpecifier(@NotNull JetDelegatorByExpressionSpecifier specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationByExpressionSpecifier"));
            }
            this.generateInstructions(specifier.getDelegateExpression(), this.inCondition);
        }

        @Override
        public void visitJetFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetFile"));
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty)) continue;
                this.generateInstructions(declaration, this.inCondition);
            }
        }

        @Override
        public void visitJetElement(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetElement"));
            }
            JetControlFlowProcessor.this.builder.unsupported(element);
        }

        private class FinallyBlockGenerator {
            private final JetFinallySection finallyBlock;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(JetFinallySection block) {
                this.finallyBlock = block;
            }

            public void generate() {
                JetBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    JetControlFlowProcessor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = JetControlFlowProcessor.this.builder.createUnboundLabel("start finally");
                JetControlFlowProcessor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression, CFPVisitor.this.inCondition);
                this.finishFinally = JetControlFlowProcessor.this.builder.createUnboundLabel("finish finally");
                JetControlFlowProcessor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }
}

