/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CompileTimeConstantResolver {
    private final KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();

    @Nullable
    public Diagnostic checkConstantExpressionType(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        Diagnostic diagnostic;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "checkConstantExpressionType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "checkConstantExpressionType"));
        }
        CompileTimeConstant<?> compileTimeConstant = this.getCompileTimeConstant(expression, expectedType);
        HashSet<DiagnosticFactory> errorsThatDependOnExpectedType = Sets.newHashSet(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE);
        if (compileTimeConstant instanceof ErrorValueWithDiagnostic && errorsThatDependOnExpectedType.contains((diagnostic = ((ErrorValueWithDiagnostic)compileTimeConstant).getDiagnostic()).getFactory())) {
            return diagnostic;
        }
        return null;
    }

    @NotNull
    public CompileTimeConstant<?> getCompileTimeConstant(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        CompileTimeConstant<?> value;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCompileTimeConstant"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCompileTimeConstant"));
        }
        IElementType elementType = expression.getNode().getElementType();
        if (elementType == JetNodeTypes.INTEGER_CONSTANT) {
            value = this.getIntegerValue(expression, expectedType);
        } else if (elementType == JetNodeTypes.FLOAT_CONSTANT) {
            value = this.getFloatValue(expression, expectedType);
        } else if (elementType == JetNodeTypes.BOOLEAN_CONSTANT) {
            value = this.getBooleanValue(expression, expectedType);
        } else if (elementType == JetNodeTypes.CHARACTER_CONSTANT) {
            value = this.getCharValue(expression, expectedType);
        } else if (elementType == JetNodeTypes.NULL) {
            value = CompileTimeConstantResolver.getNullValue(expression, expectedType);
        } else {
            throw new IllegalArgumentException("Unsupported constant: " + expression);
        }
        CompileTimeConstant<?> compileTimeConstant = value;
        if (compileTimeConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCompileTimeConstant"));
        }
        return compileTimeConstant;
    }

    @NotNull
    public CompileTimeConstant<?> getIntegerValue(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
        }
        String text = expression.getText();
        CompileTimeConstant<?> compileTimeConstant = this.getIntegerValue(CompileTimeConstantResolver.parseLongValue(text), expectedType, expression);
        if (compileTimeConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
        }
        return compileTimeConstant;
    }

    @NotNull
    public CompileTimeConstant<?> getIntegerValue(@Nullable Long value, @NotNull JetType expectedType, @NotNull JetConstantExpression expression) {
        long upperBound;
        long lowerBound;
        Function<Long, CompileTimeConstant<Integer>> create;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
        }
        if (value == null) {
            ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.INT_LITERAL_OUT_OF_RANGE.on(expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
            }
            return errorValue;
        }
        if (CompileTimeConstantResolver.noExpectedTypeOrError(expectedType)) {
            if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
                IntValue intValue = new IntValue(value.intValue());
                if (intValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
                }
                return intValue;
            }
            LongValue longValue = new LongValue(value);
            if (longValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
            }
            return longValue;
        }
        TypeConstructor constructor = expectedType.getConstructor();
        if (constructor == this.builtIns.getInt().getTypeConstructor()) {
            create = IntValue.CREATE;
            lowerBound = Integer.MIN_VALUE;
            upperBound = Integer.MAX_VALUE;
        } else if (constructor == this.builtIns.getLong().getTypeConstructor()) {
            create = LongValue.CREATE;
            lowerBound = Long.MIN_VALUE;
            upperBound = Long.MAX_VALUE;
        } else if (constructor == this.builtIns.getShort().getTypeConstructor()) {
            create = ShortValue.CREATE;
            lowerBound = -32768L;
            upperBound = 32767L;
        } else if (constructor == this.builtIns.getByte().getTypeConstructor()) {
            create = ByteValue.CREATE;
            lowerBound = -128L;
            upperBound = 127L;
        } else {
            JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
            JetType intType = this.builtIns.getIntType();
            JetType longType = this.builtIns.getLongType();
            if (typeChecker.isSubtypeOf(intType, expectedType)) {
                CompileTimeConstant<?> compileTimeConstant = this.getIntegerValue(value, intType, expression);
                if (compileTimeConstant == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
                }
                return compileTimeConstant;
            }
            if (typeChecker.isSubtypeOf(longType, expectedType)) {
                CompileTimeConstant<?> compileTimeConstant = this.getIntegerValue(value, longType, expression);
                if (compileTimeConstant == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
                }
                return compileTimeConstant;
            }
            ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "integer", expectedType));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
            }
            return errorValue;
        }
        if (value != null && lowerBound <= value && value <= upperBound) {
            CompileTimeConstant<Integer> compileTimeConstant = create.apply(value);
            if (compileTimeConstant == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
            }
            return compileTimeConstant;
        }
        ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "integer", expectedType));
        if (errorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getIntegerValue"));
        }
        return errorValue;
    }

    @Nullable
    public static Long parseLongValue(String text) {
        try {
            long value;
            if (text.startsWith("0x") || text.startsWith("0X")) {
                String hexString = text.substring(2);
                value = Long.parseLong(hexString, 16);
            } else if (text.startsWith("0b") || text.startsWith("0B")) {
                String binString = text.substring(2);
                value = Long.parseLong(binString, 2);
            } else {
                value = Long.parseLong(text);
            }
            return value;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDoubleValue(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public CompileTimeConstant<?> getFloatValue(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        block10: {
            FloatValue floatValue;
            block11: {
                String text;
                block8: {
                    DoubleValue doubleValue;
                    block9: {
                        if (expression == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getFloatValue"));
                        }
                        if (expectedType == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getFloatValue"));
                        }
                        text = expression.getText();
                        try {
                            if (!CompileTimeConstantResolver.noExpectedTypeOrError(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(this.builtIns.getDoubleType(), expectedType)) break block8;
                            doubleValue = new DoubleValue(Double.parseDouble(text));
                            if (doubleValue != null) break block9;
                        }
                        catch (NumberFormatException e) {
                            ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.FLOAT_LITERAL_OUT_OF_RANGE.on(expression));
                            if (errorValue == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getFloatValue"));
                            }
                            return errorValue;
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getFloatValue"));
                    }
                    return doubleValue;
                }
                if (!JetTypeChecker.INSTANCE.isSubtypeOf(this.builtIns.getFloatType(), expectedType)) break block10;
                floatValue = new FloatValue(Float.parseFloat(text));
                if (floatValue != null) break block11;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getFloatValue"));
            }
            return floatValue;
        }
        ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "floating-point", expectedType));
        if (errorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getFloatValue"));
        }
        return errorValue;
    }

    @Nullable
    private static CompileTimeConstant<?> checkNativeType(JetType expectedType, String title, JetType nativeType, JetConstantExpression expression) {
        if (!CompileTimeConstantResolver.noExpectedTypeOrError(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(nativeType, expectedType)) {
            return CompileTimeConstantResolver.createErrorValue(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, title, expectedType));
        }
        return null;
    }

    @NotNull
    public CompileTimeConstant<?> getBooleanValue(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getBooleanValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getBooleanValue"));
        }
        String text = expression.getText();
        CompileTimeConstant<?> error = CompileTimeConstantResolver.checkNativeType(expectedType, "boolean", this.builtIns.getBooleanType(), expression);
        if (error != null) {
            CompileTimeConstant<?> compileTimeConstant = error;
            if (compileTimeConstant == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getBooleanValue"));
            }
            return compileTimeConstant;
        }
        if ("true".equals(text)) {
            BooleanValue booleanValue = BooleanValue.TRUE;
            if (booleanValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getBooleanValue"));
            }
            return booleanValue;
        }
        if ("false".equals(text)) {
            BooleanValue booleanValue = BooleanValue.FALSE;
            if (booleanValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getBooleanValue"));
            }
            return booleanValue;
        }
        throw new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @NotNull
    public CompileTimeConstant<?> getCharValue(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
        }
        String text = expression.getText();
        CompileTimeConstant<?> error = CompileTimeConstantResolver.checkNativeType(expectedType, "character", this.builtIns.getCharType(), expression);
        if (error != null) {
            CompileTimeConstant<?> compileTimeConstant = error;
            if (compileTimeConstant == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
            }
            return compileTimeConstant;
        }
        if (text.length() < 2 || text.charAt(0) != '\'' || text.charAt(text.length() - 1) != '\'') {
            ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.INCORRECT_CHARACTER_LITERAL.on(expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
            }
            return errorValue;
        }
        if ((text = text.substring(1, text.length() - 1)).length() == 0) {
            ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.EMPTY_CHARACTER_LITERAL.on(expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
            }
            return errorValue;
        }
        if (text.charAt(0) != '\\') {
            if (text.length() == 1) {
                CharValue charValue = new CharValue(text.charAt(0));
                if (charValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
                }
                return charValue;
            }
            ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.TOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL.on(expression, expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
            }
            return errorValue;
        }
        CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantResolver.escapedStringToCharValue(text, expression);
        if (compileTimeConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getCharValue"));
        }
        return compileTimeConstant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static CompileTimeConstant<?> escapedStringToCharValue(@NotNull String text, @NotNull JetElement expression) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
        }
        assert (text.length() > 0 && text.charAt(0) == '\\') : "Only escaped sequences must be passed to this routine: " + text;
        String escape = text.substring(1);
        switch (escape.length()) {
            case 0: {
                CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantResolver.illegalEscape(expression);
                if (compileTimeConstant != null) return compileTimeConstant;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
            }
            case 1: {
                Character escaped = CompileTimeConstantResolver.translateEscape(escape.charAt(0));
                if (escaped == null) {
                    CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantResolver.illegalEscape(expression);
                    if (compileTimeConstant != null) return compileTimeConstant;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
                }
                CharValue charValue = new CharValue(escaped.charValue());
                if (charValue != null) return charValue;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    Integer intValue = Integer.valueOf(escape.substring(1), 16);
                    CharValue charValue = new CharValue((char)intValue.intValue());
                    if (charValue != null) return charValue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
            }
        }
        CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantResolver.illegalEscape(expression);
        if (compileTimeConstant != null) return compileTimeConstant;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "escapedStringToCharValue"));
    }

    @NotNull
    private static CompileTimeConstant<?> illegalEscape(@NotNull JetElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "illegalEscape"));
        }
        ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.ILLEGAL_ESCAPE.on(expression, expression));
        if (errorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "illegalEscape"));
        }
        return errorValue;
    }

    @Nullable
    public static Character translateEscape(char c) {
        switch (c) {
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'n': {
                return Character.valueOf('\n');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '$': {
                return Character.valueOf('$');
            }
        }
        return null;
    }

    @NotNull
    public static CompileTimeConstant<?> getNullValue(@NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getNullValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getNullValue"));
        }
        if (CompileTimeConstantResolver.noExpectedTypeOrError(expectedType) || expectedType.isNullable()) {
            NullValue nullValue = NullValue.NULL;
            if (nullValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getNullValue"));
            }
            return nullValue;
        }
        ErrorValue errorValue = CompileTimeConstantResolver.createErrorValue(Errors.NULL_FOR_NONNULL_TYPE.on(expression, expectedType));
        if (errorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "getNullValue"));
        }
        return errorValue;
    }

    private static boolean noExpectedTypeOrError(JetType expectedType) {
        return TypeUtils.noExpectedType(expectedType) || expectedType.isError();
    }

    @NotNull
    private static ErrorValue createErrorValue(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "createErrorValue"));
        }
        ErrorValueWithDiagnostic errorValueWithDiagnostic = new ErrorValueWithDiagnostic(diagnostic);
        if (errorValueWithDiagnostic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver", "createErrorValue"));
        }
        return errorValueWithDiagnostic;
    }

    public static class ErrorValueWithDiagnostic
    extends ErrorValue {
        private final Diagnostic diagnostic;

        public ErrorValueWithDiagnostic(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver$ErrorValueWithDiagnostic", "<init>"));
            }
            this.diagnostic = diagnostic;
        }

        @NotNull
        public Diagnostic getDiagnostic() {
            Diagnostic diagnostic = this.diagnostic;
            if (diagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver$ErrorValueWithDiagnostic", "getDiagnostic"));
            }
            return diagnostic;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            if (kotlinBuiltIns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantResolver$ErrorValueWithDiagnostic", "getType"));
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return DefaultErrorMessages.RENDERER.render(this.diagnostic);
        }
    }
}

