/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.KeywordStringsGenerated;

public class DescriptorRendererImpl
implements DescriptorRenderer {
    private final boolean shortNames;
    private final boolean withDefinedIn;
    private final Set<DescriptorRenderer.Modifier> modifiers;
    private final boolean startFromName;
    private final boolean debugMode;
    private final boolean classWithPrimaryConstructor;
    private final boolean verbose;
    private final boolean unitReturnType;
    private final boolean normalizedVisibilities;
    private final boolean showInternalKeyword;
    private final boolean alwaysRenderAny;
    private final boolean prettyFunctionTypes;
    @NotNull
    private final DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy;
    @NotNull
    private final DescriptorRenderer.ValueParametersHandler handler;
    @NotNull
    private final DescriptorRenderer.TextFormat textFormat;
    @NotNull
    private final Set<FqName> excludedAnnotationClasses;

    DescriptorRendererImpl(boolean shortNames, boolean withDefinedIn, Set<DescriptorRenderer.Modifier> modifiers, boolean startFromName, boolean debugMode, boolean classWithPrimaryConstructor, boolean verbose, boolean unitReturnType, boolean normalizedVisibilities, boolean showInternalKeyword, boolean alwaysRenderAny, boolean prettyFunctionTypes, @NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy, @NotNull DescriptorRenderer.ValueParametersHandler handler, @NotNull DescriptorRenderer.TextFormat textFormat, @NotNull Collection<FqName> excludedAnnotationClasses) {
        if (overrideRenderingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideRenderingPolicy", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (textFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFormat", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (excludedAnnotationClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedAnnotationClasses", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "<init>"));
        }
        this.shortNames = shortNames;
        this.withDefinedIn = withDefinedIn;
        this.modifiers = modifiers;
        this.startFromName = startFromName;
        this.handler = handler;
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        this.verbose = verbose;
        this.unitReturnType = unitReturnType;
        this.normalizedVisibilities = normalizedVisibilities;
        this.showInternalKeyword = showInternalKeyword;
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        this.debugMode = debugMode;
        this.textFormat = textFormat;
        this.excludedAnnotationClasses = Sets.newHashSet(excludedAnnotationClasses);
        this.alwaysRenderAny = alwaysRenderAny;
        this.prettyFunctionTypes = prettyFunctionTypes;
    }

    @NotNull
    private String renderKeyword(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderKeyword"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string = keyword;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderKeyword"));
                }
                return string;
            }
            case HTML: {
                String string = "<b>" + keyword + "</b>";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderKeyword"));
                }
                return string;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String escape(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "escape"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string2 = string;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "escape"));
                }
                return string2;
            }
            case HTML: {
                String string3 = string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "escape"));
                }
                return string3;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String lt() {
        String string = this.escape("<");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "lt"));
        }
        return string;
    }

    @NotNull
    private String arrow() {
        switch (this.textFormat) {
            case PLAIN: {
                String string = this.escape("->");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "arrow"));
                }
                return string;
            }
            case HTML: {
                if ("&rarr;" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "arrow"));
                }
                return "&rarr;";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderMessage"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string = message;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderMessage"));
                }
                return string;
            }
            case HTML: {
                String string = "<i>" + message + "</i>";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderMessage"));
                }
                return string;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderName(@NotNull Name identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderName"));
        }
        String asString = identifier.toString();
        String string = this.escape(KeywordStringsGenerated.KEYWORDS.contains(asString) ? '`' + asString + '`' : asString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderName"));
        }
        return string;
    }

    private void renderName(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderName"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderName"));
        }
        builder.append(this.renderName(descriptor.getName()));
    }

    @NotNull
    private String renderFqName(@NotNull FqNameUnsafe fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        String string = this.renderFqName(fqName.pathSegments());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        return string;
    }

    @NotNull
    private String renderFqName(@NotNull List<Name> pathSegments) {
        if (pathSegments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathSegments", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        StringBuilder buf = new StringBuilder();
        for (Name element : pathSegments) {
            if (buf.length() != 0) {
                buf.append(".");
            }
            buf.append(this.renderName(element));
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        return string;
    }

    @NotNull
    private String renderClassName(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderClassName"));
        }
        if (ErrorUtils.isError(klass)) {
            String string = klass.getTypeConstructor().toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderClassName"));
            }
            return string;
        }
        if (this.shortNames) {
            ArrayList<Name> qualifiedNameElements = Lists.newArrayList();
            DeclarationDescriptor current = klass;
            do {
                if (current.getKind() == ClassKind.CLASS_OBJECT) continue;
                qualifiedNameElements.add(current.getName());
            } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
            Collections.reverse(qualifiedNameElements);
            String string = this.renderFqName(qualifiedNameElements);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderClassName"));
            }
            return string;
        }
        String string = this.renderFqName(DescriptorUtils.getFQName(klass));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderClassName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String renderType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderType"));
        }
        String string = this.escape(this.renderTypeWithoutEscape(type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderType"));
        }
        return string;
    }

    private String renderTypeWithoutEscape(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeWithoutEscape"));
        }
        if (type == TypeUtils.CANT_INFER_LAMBDA_PARAM_TYPE || type == TypeUtils.CANT_INFER_TYPE_PARAMETER) {
            return "???";
        }
        if (type.isError()) {
            return type.toString();
        }
        if (KotlinBuiltIns.getInstance().isExactFunctionOrExtensionFunctionType(type) && this.prettyFunctionTypes) {
            return this.renderFunctionType(type);
        }
        return this.renderDefaultType(type);
    }

    @NotNull
    private String renderDefaultType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderDefaultType"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderTypeName(type.getConstructor()));
        if (!type.getArguments().isEmpty()) {
            sb.append("<");
            this.appendTypeProjections(type.getArguments(), sb);
            sb.append(">");
        }
        if (type.isNullable()) {
            sb.append("?");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderDefaultType"));
        }
        return string;
    }

    @NotNull
    private String renderTypeName(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeName"));
        }
        ClassifierDescriptor cd = typeConstructor.getDeclarationDescriptor();
        if (cd instanceof TypeParameterDescriptor) {
            String string = this.renderName(cd.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeName"));
            }
            return string;
        }
        if (cd instanceof ClassDescriptor) {
            String string = this.renderClassName((ClassDescriptor)cd);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeName"));
            }
            return string;
        }
        assert (cd == null) : "Unexpected classifier: " + cd.getClass();
        String string = typeConstructor.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeName"));
        }
        return string;
    }

    private void appendTypeProjections(@NotNull List<TypeProjection> typeProjections, @NotNull StringBuilder builder) {
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "appendTypeProjections"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "appendTypeProjections"));
        }
        Iterator<TypeProjection> iterator2 = typeProjections.iterator();
        while (iterator2.hasNext()) {
            TypeProjection typeProjection = iterator2.next();
            if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                builder.append((Object)typeProjection.getProjectionKind()).append(" ");
            }
            builder.append(this.renderType(typeProjection.getType()));
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    @NotNull
    private String renderFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunctionType"));
        }
        StringBuilder sb = new StringBuilder();
        JetType receiverType = KotlinBuiltIns.getInstance().getReceiverType(type);
        if (receiverType != null) {
            sb.append(this.renderType(receiverType));
            sb.append(".");
        }
        sb.append("(");
        this.appendTypeProjections(KotlinBuiltIns.getInstance().getParameterTypeProjectionsFromFunctionType(type), sb);
        sb.append(") " + this.arrow() + " ");
        sb.append(this.renderType(KotlinBuiltIns.getInstance().getReturnTypeFromFunctionType(type)));
        if (type.isNullable()) {
            String string = "(" + sb + ")?";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunctionType"));
            }
            return string;
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunctionType"));
        }
        return string;
    }

    private void appendDefinedIn(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "appendDefinedIn"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "appendDefinedIn"));
        }
        if (descriptor instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        builder.append(" ").append(this.renderMessage("defined in")).append(" ");
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration != null) {
            FqNameUnsafe fqName = DescriptorUtils.getFQName(containingDeclaration);
            builder.append(FqName.ROOT.equalsTo(fqName) ? "root package" : this.renderFqName(fqName));
        }
    }

    private void renderAnnotations(@NotNull Annotated annotated, @NotNull StringBuilder builder) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderAnnotations"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderAnnotations"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.ANNOTATIONS)) {
            return;
        }
        for (AnnotationDescriptor annotation : annotated.getAnnotations()) {
            ClassDescriptor annotationClass = (ClassDescriptor)annotation.getType().getConstructor().getDeclarationDescriptor();
            assert (annotationClass != null);
            if (this.excludedAnnotationClasses.contains(DescriptorUtils.getFQName(annotationClass).toSafe())) continue;
            builder.append(this.renderType(annotation.getType()));
            if (this.verbose) {
                builder.append("(").append(StringUtil.join(DescriptorUtils.getSortedValueArguments(annotation, this), ", ")).append(")");
            }
            builder.append(" ");
        }
    }

    private void renderVisibility(@NotNull Visibility visibility, @NotNull StringBuilder builder) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderVisibility"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderVisibility"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.VISIBILITY)) {
            return;
        }
        if (this.normalizedVisibilities) {
            visibility = visibility.normalize();
        }
        if (!this.showInternalKeyword && visibility == Visibilities.INTERNAL) {
            return;
        }
        builder.append(this.renderKeyword(visibility.toString())).append(" ");
    }

    private void renderModality(@NotNull Modality modality, @NotNull StringBuilder builder) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderModality"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderModality"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MODALITY)) {
            return;
        }
        String keyword = modality.name().toLowerCase();
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private void renderInner(boolean isInner, @NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderInner"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.INNER)) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private void renderModalityForCallable(@NotNull CallableMemberDescriptor callable2, @NotNull StringBuilder builder) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderModalityForCallable"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderModalityForCallable"));
        }
        if (!DescriptorUtils.isTopLevelDeclaration(callable2) || callable2.getModality() != Modality.FINAL) {
            if (this.overridesSomething(callable2) && this.overrideRenderingPolicy == DescriptorRenderer.OverrideRenderingPolicy.RENDER_OVERRIDE && callable2.getModality() == Modality.OPEN) {
                return;
            }
            this.renderModality(callable2.getModality(), builder);
        }
    }

    private boolean overridesSomething(CallableMemberDescriptor callable2) {
        return !callable2.getOverriddenDescriptors().isEmpty();
    }

    private void renderOverride(@NotNull CallableMemberDescriptor callableMember, @NotNull StringBuilder builder) {
        if (callableMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMember", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderOverride"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderOverride"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMember) && this.overrideRenderingPolicy != DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN) {
            builder.append("override ");
            if (this.verbose) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MEMBER_KIND)) {
            return;
        }
        if (this.verbose && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            builder.append("/*").append(callableMember.getKind().name().toLowerCase()).append("*/ ");
        }
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "render"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), stringBuilder);
        if (this.withDefinedIn) {
            this.appendDefinedIn(declarationDescriptor, stringBuilder);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "render"));
        }
        return string;
    }

    private void renderTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull StringBuilder builder, boolean topLevel) {
        String variance;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeParameter"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeParameter"));
        }
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.verbose) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!(variance = typeParameter.getVariance().toString()).isEmpty()) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            JetType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!((Object)KotlinBuiltIns.getInstance().getDefaultBound()).equals(upperBound) || this.alwaysRenderAny) {
                builder.append(" : ").append(this.renderType(upperBound));
            }
        } else if (topLevel) {
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (((Object)upperBound).equals(KotlinBuiltIns.getInstance().getDefaultBound())) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                builder.append(this.renderType(upperBound));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(">");
        }
    }

    private void renderTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder, boolean withSpace) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeParameters"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderTypeParameters"));
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            Iterator<TypeParameterDescriptor> iterator2 = typeParameters.iterator();
            while (iterator2.hasNext()) {
                TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
                this.renderTypeParameter(typeParameterDescriptor, builder, false);
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(">");
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private void renderFunction(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunction"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunction"));
        }
        if (!this.startFromName) {
            this.renderAnnotations(function, builder);
            this.renderVisibility(function.getVisibility(), builder);
            this.renderModalityForCallable(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            builder.append(this.renderKeyword("fun")).append(" ");
            this.renderTypeParameters(function.getTypeParameters(), builder, true);
            ReceiverParameterDescriptor receiver = function.getReceiverParameter();
            if (receiver != null) {
                builder.append(this.escape(this.renderType(receiver.getType()))).append(".");
            }
        }
        this.renderName(function, builder);
        this.renderValueParameters(function, builder);
        JetType returnType = function.getReturnType();
        if (this.unitReturnType || !KotlinBuiltIns.getInstance().isUnit(returnType)) {
            builder.append(": ").append(returnType == null ? "[NULL]" : this.escape(this.renderType(returnType)));
        }
        this.renderWhereSuffix(function.getTypeParameters(), builder);
    }

    private void renderConstructor(@NotNull ConstructorDescriptor constructor, @NotNull StringBuilder builder) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderConstructor"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderConstructor"));
        }
        this.renderAnnotations(constructor, builder);
        this.renderVisibility(constructor.getVisibility(), builder);
        this.renderMemberKind(constructor, builder);
        builder.append(this.renderKeyword("constructor")).append(" ");
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        this.renderName(classDescriptor, builder);
        this.renderTypeParameters(classDescriptor.getTypeConstructor().getParameters(), builder, false);
        this.renderValueParameters(constructor, builder);
        this.renderWhereSuffix(constructor.getTypeParameters(), builder);
    }

    private void renderWhereSuffix(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderWhereSuffix"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderWhereSuffix"));
        }
        ArrayList<String> upperBoundStrings = Lists.newArrayList();
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (typeParameter.getUpperBounds().size() <= 1) continue;
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (!first) {
                    upperBoundStrings.add(this.renderName(typeParameter.getName()) + " : " + this.escape(this.renderType(upperBound)));
                }
                first = false;
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            builder.append(StringUtil.join(upperBoundStrings, ", "));
        }
    }

    @Override
    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunctionParameters"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.renderValueParameters(functionDescriptor, stringBuilder);
        String string = stringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderFunctionParameters"));
        }
        return string;
    }

    private void renderValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderValueParameters"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderValueParameters"));
        }
        this.handler.appendBeforeValueParameters(function, builder);
        for (ValueParameterDescriptor parameter : function.getValueParameters()) {
            this.handler.appendBeforeValueParameter(parameter, builder);
            this.renderValueParameter(parameter, builder, false);
            this.handler.appendAfterValueParameter(parameter, builder);
        }
        this.handler.appendAfterValueParameters(function, builder);
    }

    private void renderValueParameter(@NotNull ValueParameterDescriptor valueParameter, @NotNull StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderValueParameter"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderValueParameter"));
        }
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.verbose) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        this.renderAnnotations(valueParameter, builder);
        this.renderVariable(valueParameter, builder, topLevel);
        boolean bl = withDefaultValue = this.debugMode ? valueParameter.declaresDefaultValue() : valueParameter.hasDefaultValue();
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private void renderValVarPrefix(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderValVarPrefix"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderValVarPrefix"));
        }
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private void renderVariable(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder, boolean topLevel) {
        JetType typeToRender;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderVariable"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderVariable"));
        }
        JetType realType = variable.getType();
        JetType varargElementType = variable instanceof ValueParameterDescriptor ? ((ValueParameterDescriptor)variable).getVarargElementType() : null;
        JetType jetType = typeToRender = varargElementType != null ? varargElementType : realType;
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.startFromName) {
            this.renderValVarPrefix(variable, builder);
        }
        this.renderName(variable, builder);
        builder.append(": ").append(this.escape(this.renderType(typeToRender)));
        if (this.verbose && varargElementType != null) {
            builder.append(" /*").append(this.escape(this.renderType(realType))).append("*/");
        }
    }

    private void renderProperty(@NotNull PropertyDescriptor property2, @NotNull StringBuilder builder) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderProperty"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderProperty"));
        }
        if (!this.startFromName) {
            this.renderAnnotations(property2, builder);
            this.renderVisibility(property2.getVisibility(), builder);
            this.renderModalityForCallable(property2, builder);
            this.renderOverride(property2, builder);
            this.renderMemberKind(property2, builder);
            this.renderValVarPrefix(property2, builder);
        }
        this.renderTypeParameters(property2.getTypeParameters(), builder, true);
        ReceiverParameterDescriptor receiver = property2.getReceiverParameter();
        if (receiver != null) {
            builder.append(this.escape(this.renderType(receiver.getType()))).append(".");
        }
        this.renderName(property2, builder);
        builder.append(": ").append(this.escape(this.renderType(property2.getType())));
        this.renderWhereSuffix(property2.getTypeParameters(), builder);
    }

    private void renderClass(@NotNull ClassDescriptor klass, @NotNull StringBuilder builder) {
        Collection<JetType> supertypes;
        ConstructorDescriptor primaryConstructor;
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderClass"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderClass"));
        }
        if (!this.startFromName) {
            this.renderAnnotations(klass, builder);
            this.renderVisibility(klass.getVisibility(), builder);
            if (!(klass.getKind() == ClassKind.TRAIT && klass.getModality() == Modality.ABSTRACT || klass.getKind().isSingleton() && klass.getModality() == Modality.FINAL)) {
                this.renderModality(klass.getModality(), builder);
            }
            this.renderInner(klass.isInner(), builder);
            builder.append(this.renderKeyword(DescriptorRendererImpl.getClassKindPrefix(klass)));
        }
        if (klass.getKind() != ClassKind.CLASS_OBJECT || this.verbose) {
            builder.append(" ");
            this.renderName(klass, builder);
        }
        List<TypeParameterDescriptor> typeParameters = klass.getTypeConstructor().getParameters();
        this.renderTypeParameters(typeParameters, builder, false);
        if (!klass.getKind().isSingleton() && this.classWithPrimaryConstructor && (primaryConstructor = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            this.renderValueParameters(primaryConstructor, builder);
        }
        if (!(klass.equals(KotlinBuiltIns.getInstance().getNothing()) || (supertypes = klass.getTypeConstructor().getSupertypes()).isEmpty() || !this.alwaysRenderAny && supertypes.size() == 1 && KotlinBuiltIns.getInstance().isAny(supertypes.iterator().next()))) {
            builder.append(" : ");
            Iterator<JetType> iterator2 = supertypes.iterator();
            while (iterator2.hasNext()) {
                JetType supertype = iterator2.next();
                builder.append(this.renderType(supertype));
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
        }
        this.renderWhereSuffix(typeParameters, builder);
    }

    @NotNull
    private static String getClassKindPrefix(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
        }
        switch (klass.getKind()) {
            case CLASS: {
                if ("class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "class";
            }
            case TRAIT: {
                if ("trait" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "trait";
            }
            case ENUM_CLASS: {
                if ("enum class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "enum class";
            }
            case OBJECT: {
                if ("object" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "object";
            }
            case ANNOTATION_CLASS: {
                if ("annotation class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "annotation class";
            }
            case CLASS_OBJECT: {
                if ("class object" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "class object";
            }
            case ENUM_ENTRY: {
                if ("enum entry" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "enum entry";
            }
        }
        throw new IllegalStateException("unknown class kind: " + (Object)((Object)klass.getKind()));
    }

    private void renderModuleOrScript(@NotNull DeclarationDescriptor moduleOrScript, @NotNull StringBuilder builder) {
        if (moduleOrScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrScript", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderModuleOrScript"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderModuleOrScript"));
        }
        this.renderName(moduleOrScript, builder);
    }

    private void renderNamespace(@NotNull NamespaceDescriptor namespace, @NotNull StringBuilder builder) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderNamespace"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/renderer/DescriptorRendererImpl", "renderNamespace"));
        }
        builder.append(this.renderKeyword("package")).append(" ");
        this.renderName(namespace, builder);
    }

    private class RenderDeclarationDescriptorVisitor
    extends DeclarationDescriptorVisitorEmptyBodies<Void, StringBuilder> {
        private RenderDeclarationDescriptorVisitor() {
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderValueParameter(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderVariable(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderProperty(descriptor, builder);
            return null;
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderFunction(descriptor, builder);
            return null;
        }

        @Override
        public Void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor, StringBuilder data2) {
            throw new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
            return null;
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderTypeParameter(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitNamespaceDescriptor(NamespaceDescriptor namespaceDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderNamespace(namespaceDescriptor, builder);
            return null;
        }

        @Override
        public Void visitModuleDeclaration(ModuleDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(descriptor, builder);
            return null;
        }

        @Override
        public Void visitScriptDescriptor(ScriptDescriptor scriptDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(scriptDescriptor, builder);
            return null;
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderClass(descriptor, builder);
            return null;
        }
    }
}

