/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class CommonSuppliers {
    private static final Supplier<?> ARRAY_LIST_SUPPLIER = new Supplier(){

        public List get() {
            return Lists.newArrayList();
        }
    };
    private static final Supplier<?> LINKED_HASH_SET_SUPPLIER = new Supplier(){

        public Set get() {
            return Sets.newLinkedHashSet();
        }
    };
    private static final Supplier<?> HASH_SET_SUPPLIER = new Supplier(){

        public Set get() {
            return Sets.newHashSet();
        }
    };

    private CommonSuppliers() {
    }

    public static <T> Supplier<List<T>> getArrayListSupplier() {
        return ARRAY_LIST_SUPPLIER;
    }

    public static <T> Supplier<Set<T>> getLinkedHashSetSupplier() {
        return LINKED_HASH_SET_SUPPLIER;
    }

    public static <T> Supplier<Set<T>> getHashSetSupplier() {
        return HASH_SET_SUPPLIER;
    }

    public static <K, V> SetMultimap<K, V> newLinkedHashSetHashSetMultimap() {
        return Multimaps.newSetMultimap(Maps.newHashMap(), CommonSuppliers.getLinkedHashSetSupplier());
    }
}

