/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.markup.TextAttributes");
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    private boolean myEnforcedDefaults = false;
    @NotNull
    private AttributesFlyweight myAttrs;

    public TextAttributes() {
        this(null, null, null, EffectType.BOXED, 0);
    }

    public TextAttributes(@Nullable Color foregroundColor, @Nullable Color backgroundColor, @Nullable Color effectColor, EffectType effectType, int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, errorStripeColor);
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public TextAttributes clone() {
        TextAttributes cloned = new TextAttributes();
        cloned.myAttrs = this.myAttrs;
        cloned.myEnforcedDefaults = this.myEnforcedDefaults;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return this.myAttrs == ((TextAttributes)obj).myAttrs;
    }

    public int hashCode() {
        return this.myAttrs.hashCode();
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.getErrorStripeColor() + "]";
    }
}

