/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint", "<init>"));
        }
        this.myT = t;
        this.myS = s;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            return TypeConversionUtil.isAssignable(this.myT, this.myS);
        }
        if (this.myS instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(boxedType, this.myS));
            return true;
        }
        constraints.add(new SubtypingConstraint(this.myT, this.myS, true));
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result = this.myT.hashCode();
        result = 31 * result + this.myS.hashCode();
        return result;
    }
}

