/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SourceUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.SourceUtil");
    private static final TokenSet REF_FILTER = TokenSet.orSet(ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, TokenSet.create(JavaElementType.ANNOTATION));

    private SourceUtil() {
    }

    @NotNull
    public static String getReferenceText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        final StringBuilder buffer = new StringBuilder();
        ((TreeElement)ref.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                if (!REF_FILTER.contains(leaf.getElementType())) {
                    char lastInBuffer;
                    String leafText = leaf.getText();
                    if (buffer.length() > 0 && !leafText.isEmpty() && Character.isJavaIdentifierPart(leafText.charAt(0)) && ((lastInBuffer = buffer.charAt(buffer.length() - 1)) == '?' || Character.isJavaIdentifierPart(lastInBuffer))) {
                        buffer.append(" ");
                    }
                    buffer.append(leafText);
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (!REF_FILTER.contains(composite.getElementType())) {
                    super.visitComposite(composite);
                }
            }
        });
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        return string;
    }

    @NotNull
    public static String getReferenceText(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        String string = LightTreeUtil.toFilteredString(tree, node, REF_FILTER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        return string;
    }

    public static TreeElement addParenthToReplacedChild(@NotNull IElementType parenthType, @NotNull TreeElement newChild, @NotNull PsiManager manager) {
        if (parenthType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/SourceUtil", "addParenthToReplacedChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/SourceUtil", "addParenthToReplacedChild"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/tree/SourceUtil", "addParenthToReplacedChild"));
        }
        CompositeElement parenthExpr = ASTFactory.composite(parenthType);
        TreeElement dummyExpr = (TreeElement)newChild.clone();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(newChild);
        new DummyHolder(manager, parenthExpr, null, charTableByTree);
        parenthExpr.putUserData(CharTable.CHAR_TABLE_KEY, charTableByTree);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.LPARENTH, "("));
        parenthExpr.rawAddChildren(dummyExpr);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.RPARENTH, ")"));
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(manager.getProject());
            PsiElement formatted = codeStyleManager.reformat((PsiElement)SourceTreeToPsiMap.treeToPsiNotNull(parenthExpr));
            parenthExpr = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(formatted);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        newChild.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(newChild));
        dummyExpr.rawReplaceWithList(newChild);
        newChild = parenthExpr;
        TreeUtil.clearCaches(TreeUtil.getFileElement(newChild));
        return newChild;
    }
}

