/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.TailRecursionKind;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;

public class TailRecursionCodegen {
    @NotNull
    private final MethodContext context;
    @NotNull
    private final ExpressionCodegen codegen;
    @NotNull
    private final InstructionAdapter v;
    @NotNull
    private final GenerationState state;

    public TailRecursionCodegen(@NotNull MethodContext context, @NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull GenerationState state) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/TailRecursionCodegen", "<init>"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/TailRecursionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/TailRecursionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/TailRecursionCodegen", "<init>"));
        }
        this.context = context;
        this.codegen = codegen;
        this.v = v;
        this.state = state;
    }

    public boolean isTailRecursion(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/codegen/TailRecursionCodegen", "isTailRecursion"));
        }
        TailRecursionKind status = this.state.getBindingContext().get(BindingContext.TAIL_RECURSION_CALL, resolvedCall);
        return status != null && status.isDoGenerateTailRecursion();
    }

    public void generateTailRecursion(ResolvedCall<? extends CallableDescriptor> resolvedCall) {
        CallableDescriptor fd = resolvedCall.getResultingDescriptor();
        assert (fd instanceof FunctionDescriptor) : "the resolved call is not refer to the function descriptor so why do we use generateTailRecursion for something strange?";
        CallableMethod callable2 = (CallableMethod)this.codegen.resolveToCallable((FunctionDescriptor)fd, false);
        this.assignParameterValues(fd, callable2, resolvedCall.getValueArgumentsByIndex());
        if (callable2.getReceiverClass() != null) {
            if (resolvedCall.getReceiverArgument() != fd.getReceiverParameter().getValue()) {
                StackValue expression = this.context.getReceiverExpression(this.codegen.typeMapper);
                expression.store(callable2.getReceiverClass(), this.v);
            } else {
                AsmUtil.pop(this.v, callable2.getReceiverClass());
            }
        }
        if (callable2.getThisType() != null) {
            AsmUtil.pop(this.v, callable2.getThisType());
        }
        this.v.goTo(this.context.getMethodStartLabel());
    }

    private void assignParameterValues(CallableDescriptor fd, CallableMethod callableMethod, List<ResolvedValueArgument> valueArguments) {
        List<Type> types = callableMethod.getValueParameterTypes();
        for (ValueParameterDescriptor parameterDescriptor : Lists.reverse(fd.getValueParameters())) {
            ResolvedValueArgument arg = valueArguments.get(parameterDescriptor.getIndex());
            Type type = types.get(parameterDescriptor.getIndex());
            if (arg instanceof ExpressionValueArgument) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall;
                JetExpression argumentExpression;
                ExpressionValueArgument ev = (ExpressionValueArgument)arg;
                ValueArgument argument = ev.getValueArgument();
                JetExpression jetExpression = argumentExpression = argument == null ? null : argument.getArgumentExpression();
                if (argumentExpression instanceof JetSimpleNameExpression && (resolvedCall = this.state.getBindingContext().get(BindingContext.RESOLVED_CALL, argumentExpression)) != null && resolvedCall.getResultingDescriptor().equals(parameterDescriptor.getOriginal())) {
                    AsmUtil.pop(this.v, type);
                    continue;
                }
            } else if (arg instanceof DefaultValueArgument) {
                AsmUtil.pop(this.v, type);
                DefaultParameterValueLoader.DEFAULT.putValueOnStack(parameterDescriptor, this.codegen);
            } else if (!(arg instanceof VarargValueArgument)) {
                throw new UnsupportedOperationException("Unknown argument type: " + arg + " in " + fd);
            }
            this.store(parameterDescriptor, type);
        }
    }

    private void store(ValueParameterDescriptor parameterDescriptor, Type type) {
        int index = this.getParameterVariableIndex(parameterDescriptor);
        this.v.store(index, type);
    }

    private int getParameterVariableIndex(ValueParameterDescriptor parameterDescriptor) {
        int index = this.codegen.lookupLocalIndex(parameterDescriptor);
        if (index == -1) {
            index = this.codegen.lookupLocalIndex(parameterDescriptor.getOriginal());
        }
        if (index == -1) {
            throw new IllegalStateException("Failed to obtain parameter index: " + parameterDescriptor);
        }
        return index;
    }
}

