/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.ArrayList;
import java.util.Collection;
import jet.Function0;
import jet.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.EnumEntrySyntheticClassDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.storage.NotNullLazyValue;

public final class JavaClassNonStaticMembersScope
extends JavaClassMembersScope {
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final JavaClass javaClass;

    public JavaClassNonStaticMembersScope(@NotNull ClassDescriptor descriptor, @NotNull JavaClass javaClass, @NotNull JavaMemberResolver memberResolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "<init>"));
        }
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberResolver", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "<init>"));
        }
        super((ClassOrNamespaceDescriptor)descriptor, MembersProvider.forClass(javaClass, false), memberResolver);
        this.descriptor = descriptor;
        this.javaClass = javaClass;
    }

    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Collection<ConstructorDescriptor> collection = this.memberResolver.resolveConstructors(this.javaClass, this.descriptor);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "getConstructors"));
        }
        return collection;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        Collection<JavaClass> innerClasses = this.javaClass.getInnerClasses();
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(innerClasses.size());
        for (JavaClass innerClass : innerClasses) {
            result.add(this.resolveInnerClass(innerClass));
        }
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            result.addAll(this.computeEnumEntries());
        }
        ArrayList<ClassDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "computeInnerClasses"));
        }
        return arrayList;
    }

    private Collection<ClassDescriptor> computeEnumEntries() {
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>();
        final Collection<NamedMembers> enumNonStaticMembers = MembersProvider.forClass(this.javaClass, true).allMembers();
        NotNullLazyValue<Collection<Name>> enumMemberNames = LockBasedStorageManager.NO_LOCKS.createLazyValue(new Function0<Collection<Name>>(){

            @Override
            public Collection<Name> invoke() {
                return KotlinPackage.map(enumNonStaticMembers, new Function1<NamedMembers, Name>(){

                    @Override
                    public Name invoke(@NotNull NamedMembers members) {
                        if (members == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope$1$1", "invoke"));
                        }
                        return members.getName();
                    }
                });
            }
        });
        block0: for (NamedMembers members : enumNonStaticMembers) {
            for (JavaField field : members.getFields()) {
                if (!field.isEnumEntry()) continue;
                EnumEntrySyntheticClassDescriptor enumEntry = EnumEntrySyntheticClassDescriptor.create(LockBasedStorageManager.NO_LOCKS, this.descriptor, members.getName(), enumMemberNames);
                result.add(enumEntry);
                continue block0;
            }
        }
        return result;
    }

    @NotNull
    private ClassDescriptor resolveInnerClass(@NotNull JavaClass innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "resolveInnerClass"));
        }
        FqName fqName = innerClass.getFqName();
        assert (fqName != null) : "Inner class has no qualified name: " + innerClass;
        ClassDescriptor classDescriptor = this.memberResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        assert (classDescriptor != null) : "Couldn't resolve inner class " + fqName;
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassNonStaticMembersScope", "resolveInnerClass"));
        }
        return classDescriptor2;
    }
}

