/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaClassStaticMembersScope
extends JavaClassMembersScope {
    @NotNull
    private final FqName packageFQN;
    @NotNull
    private final JavaClass javaClass;

    public JavaClassStaticMembersScope(@NotNull NamespaceDescriptor descriptor, @NotNull FqName packageFQN, @NotNull JavaClass javaClass, @NotNull JavaMemberResolver memberResolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberResolver", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        super((ClassOrNamespaceDescriptor)descriptor, MembersProvider.forClass(javaClass, true), memberResolver);
        this.packageFQN = packageFQN;
        this.javaClass = javaClass;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "getNamespace"));
        }
        return this.memberResolver.resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        for (JavaClass nested : this.javaClass.getInnerClasses()) {
            NamespaceDescriptor namespace = this.getNamespace(nested.getName());
            if (namespace == null) continue;
            result.add(namespace);
        }
        Collection<DeclarationDescriptor> collection = result;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "computeAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        List<ClassDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "computeInnerClasses"));
        }
        return list2;
    }
}

