/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.InnerDeclarationTranslator;

class InnerFunctionTranslator
extends InnerDeclarationTranslator {
    private final FunctionDescriptor descriptor;

    public InnerFunctionTranslator(@NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context, @NotNull JsFunction fun) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "<init>"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "<init>"));
        }
        super(context, fun);
        this.descriptor = descriptor;
    }

    @NotNull
    public JsExpression translate(@NotNull JsNameRef nameRef, @NotNull TranslationContext outerContext) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "translate"));
        }
        if (outerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerContext", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "translate"));
        }
        JsExpression jsExpression = this.translate(nameRef, this.getThis(outerContext));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "translate"));
        }
        return jsExpression;
    }

    @Override
    protected JsExpression createExpression(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "createExpression"));
        }
        return nameRef;
    }

    @Override
    protected JsInvocation createInvocation(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "createInvocation"));
        }
        return new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)nameRef), new SmartList<JsExpression>(self));
    }

    @NotNull
    private JsExpression getThis(TranslationContext outerContext) {
        ClassDescriptor outerClassDescriptor = this.context.usageTracker().getOuterClassDescriptor();
        if (outerClassDescriptor != null && this.descriptor.getReceiverParameter() == null) {
            JsExpression jsExpression = outerContext.getThisObject(outerClassDescriptor);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "getThis"));
            }
            return jsExpression;
        }
        JsNullLiteral jsNullLiteral = JsLiteral.NULL;
        if (jsNullLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerFunctionTranslator", "getThis"));
        }
        return jsNullLiteral;
    }
}

