/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedArrayAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public class ArrayAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final JetArrayAccessExpression expression;

    static ArrayAccessTranslator newInstance(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "newInstance"));
        }
        return new ArrayAccessTranslator(expression, context);
    }

    protected ArrayAccessTranslator(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.translateAsGet(this.translateArrayExpression(), this.translateIndexExpressions());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression translateAsGet(@NotNull JsExpression arrayExpression, @NotNull List<JsExpression> indexExpression) {
        if (arrayExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayExpression", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        if (indexExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexExpression", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        JsExpression jsExpression = this.translateAsMethodCall(arrayExpression, indexExpression, true);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = this.translateAsSet(this.translateArrayExpression(), this.translateIndexExpressions(), setTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression translateAsSet(@NotNull JsExpression arrayExpression, @NotNull List<JsExpression> indexExpressions, @NotNull JsExpression toSetTo) {
        if (arrayExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayExpression", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        if (indexExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexExpressions", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        ArrayList<JsExpression> arguments2 = Lists.newArrayList(indexExpressions);
        arguments2.add(toSetTo);
        JsExpression jsExpression = this.translateAsMethodCall(arrayExpression, arguments2, false);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsMethodCall(@NotNull JsExpression arrayExpression, @NotNull List<JsExpression> arguments2, boolean isGetter) {
        if (arrayExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayExpression", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsMethodCall"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsMethodCall"));
        }
        JsExpression jsExpression = CallBuilder.build(this.context()).receiver(arrayExpression).args(arguments2).resolvedCall(BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, isGetter)).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateAsMethodCall"));
        }
        return jsExpression;
    }

    @NotNull
    protected List<JsExpression> translateIndexExpressions() {
        List<JsExpression> list2 = TranslationUtils.translateExpressionList(this.context(), this.expression.getIndexExpressions());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateIndexExpressions"));
        }
        return list2;
    }

    @NotNull
    protected JsExpression translateArrayExpression() {
        JetExpression arrayExpression = this.expression.getArrayExpression();
        assert (arrayExpression != null) : "Code with parsing errors shouldn't be translated";
        JsExpression jsExpression = Translation.translateAsExpression(arrayExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "translateArrayExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        CachedArrayAccessTranslator cachedArrayAccessTranslator = new CachedArrayAccessTranslator(this.expression, this.context());
        if (cachedArrayAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ArrayAccessTranslator", "getCached"));
        }
        return cachedArrayAccessTranslator;
    }
}

