/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal, @Nullable Set<PsiMember> processed) {
        block11: {
            PsiClass[] superClasses;
            block12: {
                PsiMethod[] superMethods;
                if (listOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (!skipExternal && ExternalAnnotationsManager.getInstance(listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!checkHierarchy) break block11;
                if (!(listOwner instanceof PsiMethod)) break block12;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, checkHierarchy, skipExternal, processed)) continue;
                    return true;
                }
                break block11;
            }
            if (!(listOwner instanceof PsiClass)) break block11;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, checkHierarchy, skipExternal, processed)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.Nullable");
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.NotNull");
    }
}

