/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class ProperTextRange
extends TextRange {
    public ProperTextRange(int startOffset, int endOffset) {
        super(startOffset, endOffset);
        ProperTextRange.assertProperRange(this);
    }

    public ProperTextRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ProperTextRange", "<init>"));
        }
        this(range.getStartOffset(), range.getEndOffset());
    }

    @Override
    @NotNull
    public ProperTextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ProperTextRange", "cutOut"));
        }
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        ProperTextRange properTextRange = new ProperTextRange(this.getStartOffset() + subRange.getStartOffset(), Math.min(this.getEndOffset(), this.getStartOffset() + subRange.getEndOffset()));
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "cutOut"));
        }
        return properTextRange;
    }

    @Override
    @NotNull
    public ProperTextRange shiftRight(int delta) {
        if (delta == 0) {
            ProperTextRange properTextRange = this;
            if (properTextRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "shiftRight"));
            }
            return properTextRange;
        }
        ProperTextRange properTextRange = new ProperTextRange(this.getStartOffset() + delta, this.getEndOffset() + delta);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "shiftRight"));
        }
        return properTextRange;
    }

    @Override
    @NotNull
    public ProperTextRange grown(int lengthDelta) {
        if (lengthDelta == 0) {
            ProperTextRange properTextRange = this;
            if (properTextRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "grown"));
            }
            return properTextRange;
        }
        ProperTextRange properTextRange = new ProperTextRange(this.getStartOffset(), this.getEndOffset() + lengthDelta);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "grown"));
        }
        return properTextRange;
    }

    @Override
    public ProperTextRange intersection(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ProperTextRange", "intersection"));
        }
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.intersection(textRange);
        if (range == null) {
            return null;
        }
        return new ProperTextRange(range);
    }

    @Override
    @NotNull
    public ProperTextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ProperTextRange", "union"));
        }
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.union(textRange);
        ProperTextRange properTextRange = new ProperTextRange(range);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "union"));
        }
        return properTextRange;
    }

    @NotNull
    public static ProperTextRange create(@NotNull Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/ProperTextRange", "create"));
        }
        ProperTextRange properTextRange = new ProperTextRange(segment.getStartOffset(), segment.getEndOffset());
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "create"));
        }
        return properTextRange;
    }

    @NotNull
    public static ProperTextRange create(int startOffset, int endOffset) {
        ProperTextRange properTextRange = new ProperTextRange(startOffset, endOffset);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ProperTextRange", "create"));
        }
        return properTextRange;
    }
}

