/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.SmartList;
import java.util.ListIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectNode<T> {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private final ObjectTree<T> myTree;
    private ObjectNode<T> myParent;
    private final T myObject;
    private SmartList<ObjectNode<T>> myChildren;
    private final Throwable myTrace;
    private final long myOwnModification;

    /*
     * WARNING - void declaration
     */
    public ObjectNode(@NotNull ObjectTree<T> tree, @Nullable ObjectNode<T> parentNode, @NotNull T object2, long modification, @Nullable Throwable throwable) {
        void trace;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectNode", "<init>"));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/util/objectTree/ObjectNode", "<init>"));
        }
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object2;
        this.myTrace = trace;
        this.myOwnModification = modification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ObjectNode<T>[] getChildrenArray() {
        Object object2 = this.myTree.treeLock;
        // MONITORENTER : object2
        if (this.myChildren != null && !this.myChildren.isEmpty()) {
            ObjectNode[] objectNodeArray = this.myChildren.toArray(new ObjectNode[this.myChildren.size()]);
            // MONITOREXIT : object2
            if (objectNodeArray != null) return objectNodeArray;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectNode", "getChildrenArray"));
        }
        // MONITOREXIT : object2
        if (EMPTY_ARRAY != null) return EMPTY_ARRAY;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectNode", "getChildrenArray"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(@NotNull ObjectNode<T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectNode", "addChild"));
        }
        Object object2 = this.myTree.treeLock;
        synchronized (object2) {
            if (this.myChildren == null) {
                this.myChildren = new SmartList();
            }
            this.myChildren.add(child);
            child.myParent = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(@NotNull ObjectNode<T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectNode", "removeChild"));
        }
        Object object2 = this.myTree.treeLock;
        synchronized (object2) {
            assert (this.myChildren != null) : "No children to remove child: " + this + ' ' + child;
            ListIterator iterator2 = this.myChildren.listIterator(this.myChildren.size());
            while (iterator2.hasPrevious()) {
                if (!child.equals(iterator2.previous())) continue;
                iterator2.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> getParent() {
        Object object2 = this.myTree.treeLock;
        synchronized (object2) {
            return this.myParent;
        }
    }

    void execute(final boolean disposeTree, final @NotNull ObjectTreeAction<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/objectTree/ObjectNode", "execute"));
        }
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), new ObjectTreeAction<ObjectNode<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ObjectNode<T> each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectNode$1", "execute"));
                }
                try {
                    action.beforeTreeExecution(ObjectNode.this.myObject);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                ObjectNode[] childrenArray = ObjectNode.this.getChildrenArray();
                for (int i = childrenArray.length - 1; i >= 0; --i) {
                    childrenArray[i].execute(disposeTree, action);
                }
                if (disposeTree) {
                    Object i = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                    synchronized (i) {
                        ObjectNode.this.myChildren = null;
                    }
                }
                try {
                    action.execute(ObjectNode.this.myObject);
                    ObjectNode.this.myTree.fireExecuted(ObjectNode.this.myObject);
                }
                catch (ProcessCanceledException e) {
                    throw new ProcessCanceledException(e);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                if (disposeTree) {
                    ObjectNode.this.remove();
                }
            }

            @Override
            public void beforeTreeExecution(@NotNull ObjectNode<T> parent) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/objectTree/ObjectNode$1", "beforeTreeExecution"));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        this.myTree.putNode(this.myObject, null);
        Object object2 = this.myTree.treeLock;
        synchronized (object2) {
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            } else {
                this.myParent.removeChild(this);
            }
        }
    }

    @NotNull
    public T getObject() {
        T t = this.myObject;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectNode", "getObject"));
        }
        return t;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject.toString();
    }
}

