/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/CheckUtil", "checkWritable"));
        }
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.directory", ((PsiDirectory)element).getVirtualFile().getPresentableUrl()));
            }
            PsiFile file = element.getContainingFile();
            if (file == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.file", virtualFile.getPresentableUrl()));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/CheckUtil", "checkDelete"));
        }
        VfsUtilCore.visitChildrenRecursively(file, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/CheckUtil$1", "visitFile"));
                }
                if (FileTypeRegistry.getInstance().isFileIgnored(file)) {
                    return false;
                }
                if (!file.isWritable()) {
                    throw new IncorrectOperationException(PsiBundle.message("cannot.delete.a.read.only.file", file.getPresentableUrl()));
                }
                return true;
            }
        });
    }
}

