/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class IntegerValueTypeConstant
implements CompileTimeConstant<IntegerValueTypeConstructor> {
    private final IntegerValueTypeConstructor value;

    public IntegerValueTypeConstant(long value) {
        this.value = new IntegerValueTypeConstructor(value);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getType"));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.getValue(), false, Collections.emptyList(), ErrorUtils.createErrorScope("Scope for number value type (" + this.getValue().toString() + ")", true));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getType"));
        }
        return jetTypeImpl;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitNumberTypeValue(this, data2);
    }

    @Override
    @NotNull
    public IntegerValueTypeConstructor getValue() {
        IntegerValueTypeConstructor integerValueTypeConstructor = this.value;
        if (integerValueTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getValue"));
        }
        return integerValueTypeConstructor;
    }

    public String toString() {
        return this.value.toString();
    }
}

