/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CaptureKind;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ExpressionTypingUtils {
    private ExpressionTypingUtils() {
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull JetExpression expression, @Nullable JetType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (type == null) {
            return null;
        }
        return new ExpressionReceiver(expression, type);
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        return ExpressionTypingUtils.getExpressionReceiver(expression, facade.getTypeInfo(expression, context).getType());
    }

    @NotNull
    protected static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        JetType type = facade.safeGetTypeInfo(expression, context).getType();
        assert (type != null) : "safeGetTypeInfo should return @NotNull type";
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, type);
        if (expressionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        return expressionReceiver;
    }

    @NotNull
    public static WritableScopeImpl newWritableScopeImpl(ExpressionTypingContext context, @NotNull String scopeDebugName) {
        if (scopeDebugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeDebugName", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        WritableScopeImpl scope = new WritableScopeImpl(context.scope, context.scope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(context.trace), scopeDebugName);
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        WritableScopeImpl writableScopeImpl = scope;
        if (writableScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        return writableScopeImpl;
    }

    public static boolean isBoolean(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isBoolean"));
        }
        return JetTypeChecker.INSTANCE.isSubtypeOf(type, KotlinBuiltIns.getInstance().getBooleanType());
    }

    public static boolean ensureBooleanResult(JetExpression operationSign, Name name, JetType resultType, ExpressionTypingContext context) {
        return ExpressionTypingUtils.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context);
    }

    public static boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !ExpressionTypingUtils.isBoolean(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, KotlinBuiltIns.getInstance().getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    @NotNull
    public static JetType getDefaultType(IElementType constantType) {
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getIntType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getDoubleType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getBooleanType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            JetType jetType = KotlinBuiltIns.getInstance().getCharType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.NULL) {
            JetType jetType = KotlinBuiltIns.getInstance().getNullableNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    public static boolean isTypeFlexible(@Nullable JetExpression expression) {
        if (expression == null) {
            return false;
        }
        return TokenSet.create(JetNodeTypes.INTEGER_CONSTANT, JetNodeTypes.FLOAT_CONSTANT).contains(expression.getNode().getElementType());
    }

    private static boolean isCapturedInInline(@NotNull BindingContext context, @NotNull DeclarationDescriptor scopeContainer, @NotNull DeclarationDescriptor variableParent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isCapturedInInline"));
        }
        if (scopeContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeContainer", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isCapturedInInline"));
        }
        if (variableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableParent", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isCapturedInInline"));
        }
        PsiElement scopeDeclaration = BindingContextUtils.descriptorToDeclaration(context, scopeContainer);
        if (!(scopeDeclaration instanceof JetFunctionLiteral)) {
            return false;
        }
        PsiElement parent = scopeDeclaration.getParent();
        assert (parent instanceof JetFunctionLiteralExpression) : "parent of JetFunctionLiteral is " + parent;
        JetCallExpression callExpression = ExpressionTypingUtils.getCallExpression((JetFunctionLiteralExpression)parent);
        if (callExpression == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> call = context.get(BindingContext.RESOLVED_CALL, callExpression.getCalleeExpression());
        if (call == null) {
            return false;
        }
        CallableDescriptor callable2 = call.getResultingDescriptor();
        if (callable2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)callable2).isInline()) {
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            assert (scopeContainerParent != null) : "parent is null for " + scopeContainer;
            return scopeContainerParent == variableParent || ExpressionTypingUtils.isCapturedInInline(context, scopeContainerParent, variableParent);
        }
        return false;
    }

    @Nullable
    private static JetCallExpression getCallExpression(@NotNull JetFunctionLiteralExpression functionLiteralExpression) {
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getCallExpression"));
        }
        PsiElement parent = functionLiteralExpression.getParent();
        if (parent instanceof JetValueArgument) {
            PsiElement valueArgumentList = parent.getParent();
            assert (valueArgumentList instanceof JetValueArgumentList) : "parent of value argument is " + valueArgumentList;
            if (valueArgumentList.getParent() instanceof JetCallExpression) {
                return (JetCallExpression)valueArgumentList.getParent();
            }
        } else if (parent instanceof JetCallExpression) {
            return (JetCallExpression)parent;
        }
        return null;
    }

    public static void checkCapturingInClosure(JetSimpleNameExpression expression, BindingTrace trace, JetScope scope) {
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        if (variable != null) {
            DeclarationDescriptor variableParent = variable.getContainingDeclaration();
            DeclarationDescriptor scopeContainer = scope.getContainingDeclaration();
            if (scopeContainer != variableParent && variableParent instanceof CallableDescriptor && trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable) != CaptureKind.NOT_INLINE) {
                boolean inline2 = ExpressionTypingUtils.isCapturedInInline(trace.getBindingContext(), scopeContainer, variableParent);
                trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline2 ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
            }
        }
    }

    public static boolean isVariableIterable(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull Project project, @NotNull VariableDescriptor variableDescriptor, @NotNull JetScope scope) {
        ExpressionTypingContext context;
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isVariableIterable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isVariableIterable"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isVariableIterable"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isVariableIterable"));
        }
        JetExpression expression = JetPsiFactory.createExpression(project, "fake");
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, variableDescriptor.getType());
        return ControlStructureTypingVisitor.checkIterableConvention(expressionReceiver, context = ExpressionTypingContext.newContext(expressionTypingServices, new BindingTraceContext(), scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE)) != null;
    }

    public static List<CallableDescriptor> canFindSuitableCall(@NotNull FqName callableFQN, @NotNull Project project, @NotNull JetExpression receiverExpression, @NotNull JetType receiverType, @NotNull JetScope scope, @NotNull ModuleDescriptor module) {
        if (callableFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableFQN", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "canFindSuitableCall"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "canFindSuitableCall"));
        }
        if (receiverExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverExpression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "canFindSuitableCall"));
        }
        if (receiverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "canFindSuitableCall"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "canFindSuitableCall"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "canFindSuitableCall"));
        }
        JetImportDirective importDirective = JetPsiFactory.createImportDirective(project, callableFQN.asString());
        Collection<? extends DeclarationDescriptor> declarationDescriptors = new QualifiedExpressionResolver().analyseImportReference(importDirective, scope, new BindingTraceContext(), module);
        ArrayList<CallableDescriptor> callableExtensionDescriptors = new ArrayList<CallableDescriptor>();
        ExpressionReceiver receiverValue = new ExpressionReceiver(receiverExpression, receiverType);
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            CallableDescriptor callableDescriptor;
            if (!(declarationDescriptor instanceof CallableDescriptor) || !ExpressionTypingUtils.checkIsExtensionCallable(receiverValue, callableDescriptor = (CallableDescriptor)declarationDescriptor)) continue;
            callableExtensionDescriptors.add(callableDescriptor);
        }
        return callableExtensionDescriptors;
    }

    public static boolean checkIsExtensionCallable(@NotNull ReceiverValue receiverArgument, @NotNull CallableDescriptor callableDescriptor) {
        JetType notNullableType;
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkIsExtensionCallable"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkIsExtensionCallable"));
        }
        JetType type = receiverArgument.getType();
        if (type instanceof NamespaceType) {
            return false;
        }
        if (ExpressionTypingUtils.checkReceiverResolution(receiverArgument, type, callableDescriptor)) {
            return true;
        }
        return type.isNullable() && ExpressionTypingUtils.checkReceiverResolution(receiverArgument, notNullableType = TypeUtils.makeNotNullable(type), callableDescriptor);
    }

    private static boolean checkReceiverResolution(@NotNull ReceiverValue receiverArgument, @NotNull JetType receiverType, @NotNull CallableDescriptor callableDescriptor) {
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkReceiverResolution"));
        }
        if (receiverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkReceiverResolution"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkReceiverResolution"));
        }
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        if (!receiverArgument.exists() && receiverParameter == null) {
            return true;
        }
        if (!receiverArgument.exists() || receiverParameter == null) {
            return false;
        }
        Set<Name> typeNamesInReceiver = ExpressionTypingUtils.collectUsedTypeNames(receiverParameter.getType());
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        LinkedHashMap<TypeParameterDescriptor, Variance> typeVariables = Maps.newLinkedHashMap();
        for (TypeParameterDescriptor typeParameterDescriptor : callableDescriptor.getTypeParameters()) {
            if (!typeNamesInReceiver.contains(typeParameterDescriptor.getName())) continue;
            typeVariables.put(typeParameterDescriptor, Variance.INVARIANT);
        }
        constraintSystem.registerTypeVariables(typeVariables);
        constraintSystem.addSubtypeConstraint(receiverType, receiverParameter.getType(), ConstraintPosition.RECEIVER_POSITION);
        return constraintSystem.getStatus().isSuccessful() && ConstraintsUtil.checkBoundsAreSatisfied(constraintSystem, true);
    }

    private static Set<Name> collectUsedTypeNames(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "collectUsedTypeNames"));
        }
        HashSet<Name> typeNames = new HashSet<Name>();
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor != null) {
            typeNames.add(descriptor.getName());
        }
        for (TypeProjection argument : jetType.getArguments()) {
            typeNames.addAll(ExpressionTypingUtils.collectUsedTypeNames(argument.getType()));
        }
        return typeNames;
    }

    @NotNull
    public static OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context, @NotNull ReceiverValue receiver, @NotNull Name name, JetType ... argumentTypes) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        TemporaryBindingTrace traceWithFakeArgumentInfo = TemporaryBindingTrace.create(context.trace, "trace to store fake argument for", name);
        ArrayList<JetExpression> fakeArguments = Lists.newArrayList();
        for (JetType type : argumentTypes) {
            fakeArguments.add(ExpressionTypingUtils.createFakeExpressionOfType(context.expressionTypingServices.getProject(), traceWithFakeArgumentInfo, "fakeArgument" + fakeArguments.size(), type));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = ExpressionTypingUtils.makeAndResolveFakeCall(receiver, (ExpressionTypingContext)context.replaceBindingTrace(traceWithFakeArgumentInfo), fakeArguments, name).getSecond();
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    public static JetExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName, @NotNull JetType argumentType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentName", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentType", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        JetExpression fakeExpression = JetPsiFactory.createExpression(project, argumentName);
        trace.record(BindingContext.EXPRESSION_TYPE, fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    @NotNull
    public static OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context, @NotNull ReceiverValue receiver, @NotNull Name name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = ExpressionTypingUtils.resolveFakeCall(receiver, context, Collections.<JetExpression>emptyList(), name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public static OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context, @NotNull List<JetExpression> valueArguments, @NotNull Name name) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = ExpressionTypingUtils.makeAndResolveFakeCall(receiver, context, valueArguments, name).getSecond();
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public static Pair<Call, OverloadResolutionResults<FunctionDescriptor>> makeAndResolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context, @NotNull List<JetExpression> valueArguments, @NotNull Name name) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        final JetSimpleNameExpression fake = JetPsiFactory.createSimpleName(context.expressionTypingServices.getProject(), "fake");
        TemporaryBindingTrace fakeTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve fake call for", name);
        Call call = CallMaker.makeCallWithExpressions(fake, receiver, null, fake, valueArguments);
        OverloadResolutionResults<FunctionDescriptor> results = ((ExpressionTypingContext)context.replaceBindingTrace(fakeTrace)).resolveCallWithGivenName(call, fake, name);
        if (results.isSuccess()) {
            fakeTrace.commit(new TraceEntryFilter(){

                @Override
                public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                    return key != fake;
                }
            }, true);
        }
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> pair = Pair.create(call, results);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        return pair;
    }

    public static void defineLocalVariablesFromMultiDeclaration(@NotNull WritableScope writableScope, @NotNull JetMultiDeclaration multiDeclaration, @NotNull ReceiverValue receiver, @NotNull JetExpression reportErrorsOn, @NotNull ExpressionTypingContext context) {
        if (writableScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        int componentIndex = 1;
        for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
            Name componentName = Name.identifier("component" + componentIndex);
            ++componentIndex;
            JetType expectedType = ExpressionTypingUtils.getExpectedTypeForComponent(context, entry);
            OverloadResolutionResults<FunctionDescriptor> results = ExpressionTypingUtils.resolveFakeCall((ExpressionTypingContext)context.replaceExpectedType(expectedType), receiver, componentName);
            JetType componentType = null;
            if (results.isSuccess()) {
                context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                componentType = results.getResultingDescriptor().getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(componentType, expectedType)) {
                    context.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on(reportErrorsOn, componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on(reportErrorsOn, componentName, results.getResultingCalls()));
            } else {
                context.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on(reportErrorsOn, componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            VariableDescriptorImpl variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptorWithType(writableScope, entry, componentType, context.trace);
            VariableDescriptor olderVariable = writableScope.getLocalVariable(variableDescriptor.getName());
            ExpressionTypingUtils.checkVariableShadowing(context, variableDescriptor, olderVariable);
            writableScope.addVariableDescriptor(variableDescriptor);
        }
    }

    public static void checkVariableShadowing(@NotNull ExpressionTypingContext context, @NotNull VariableDescriptor variableDescriptor, VariableDescriptor oldDescriptor) {
        PsiElement declaration;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (oldDescriptor != null && DescriptorUtils.isLocal(variableDescriptor.getContainingDeclaration(), oldDescriptor) && (declaration = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), variableDescriptor)) != null) {
            context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
    }

    @NotNull
    private static JetType getExpectedTypeForComponent(ExpressionTypingContext context, JetMultiDeclarationEntry entry) {
        JetTypeReference entryTypeRef = entry.getTypeRef();
        if (entryTypeRef != null) {
            JetType jetType = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, entryTypeRef, context.trace, true);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpectedTypeForComponent"));
            }
            return jetType;
        }
        JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getExpectedTypeForComponent"));
        }
        return jetType;
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull JetElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (expressionToWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToWatch", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (mismatchFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mismatchFound", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils$2", "report"));
                }
                DiagnosticFactory factory = diagnostic.getFactory();
                if ((factory == Errors.TYPE_MISMATCH || factory == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH || factory == Errors.NULL_FOR_NONNULL_TYPE) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory) && PsiTreeUtil.isAncestor(expressionToWatch, diagnostic.getPsiElement(), false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }

    @NotNull
    public static JetTypeInfo getTypeInfoOrNullType(@Nullable JetExpression expression, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        JetTypeInfo jetTypeInfo = expression != null ? facade.getTypeInfo(expression, context) : JetTypeInfo.create(null, context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        return jetTypeInfo;
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull JetBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isBinaryExpressionDependentOnExpectedType"));
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        return operationType == JetTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType) || operationType == JetTokens.ELVIS;
    }

    public static boolean isUnaryExpressionDependentOnExpectedType(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingUtils", "isUnaryExpressionDependentOnExpectedType"));
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        return JetTokens.LABELS.contains(operationType) || operationType == JetTokens.EXCLEXCL;
    }
}

