/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PredefinedAnnotation;

public final class AnnotationsUtils {
    private AnnotationsUtils() {
    }

    private static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        CompileTimeConstant<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value = constant.getValue();
        assert (value instanceof String) : "Native function annotation should have one String parameter";
        return (String)value;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation);
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        for (PredefinedAnnotation annotation : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
            String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor, annotation);
            return name != null ? name : descriptor.getName().asString();
        }
        return null;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation.getFQName());
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull String fqn) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        for (AnnotationDescriptor annotationDescriptor : descriptor.getAnnotations()) {
            if (!AnnotationsUtils.getAnnotationClassFQName(annotationDescriptor).equals(fqn)) continue;
            return annotationDescriptor;
        }
        return null;
    }

    @NotNull
    private static String getAnnotationClassFQName(@NotNull AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationClassFQName"));
        }
        ClassifierDescriptor annotationDeclaration = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        assert (annotationDeclaration != null) : "Annotation supposed to have a declaration";
        String string = DescriptorUtils.getFQName(annotationDeclaration).asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationClassFQName"));
        }
        return string;
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "isNativeObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.NATIVE);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "isLibraryObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.LIBRARY);
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "isPredefinedObject"));
        }
        for (PredefinedAnnotation annotation : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation.getFQName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull String fqn) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (AnnotationsUtils.getAnnotationByName(descriptor, fqn) != null) {
            return true;
        }
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
        return containingClass != null && AnnotationsUtils.getAnnotationByName((DeclarationDescriptor)containingClass, fqn) != null;
    }
}

