/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImmediateClassType
extends PsiClassType {
    private final PsiClass myClass;
    private final PsiSubstitutor mySubstitutor;
    private final PsiManager myManager;
    private String myCanonicalText;
    private String myPresentableText;
    private String myInternalCanonicalText;
    private final PsiClassType.ClassResolveResult myClassResolveResult;

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        this(aClass, substitutor, null, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        this(aClass, substitutor, languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        super(languageLevel, annotations);
        this.myClassResolveResult = new PsiClassType.ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return PsiImmediateClassType.this.myClass;
            }

            @Override
            public PsiSubstitutor getSubstitutor() {
                return PsiImmediateClassType.this.mySubstitutor;
            }

            @Override
            public boolean isValidResult() {
                return true;
            }

            @Override
            public boolean isAccessible() {
                return true;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return true;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };
        this.myClass = aClass;
        this.myManager = aClass.getManager();
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
    }

    @Override
    public PsiClass resolve() {
        return this.myClass;
    }

    @Override
    public String getClassName() {
        return this.myClass.getName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiTypeParameter[] parameters = this.myClass.getTypeParameters();
        if (parameters.length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        ArrayList<PsiType> lst = new ArrayList<PsiType>();
        for (PsiTypeParameter parameter : parameters) {
            PsiType substituted = this.mySubstitutor.substitute(parameter);
            if (substituted == null) continue;
            lst.add(substituted);
        }
        PsiType[] psiTypeArray = lst.toArray(new PsiType[lst.size()]);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = this.myClassResolveResult;
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance(this.myClass.getProject()).getElementFactory().createType(this.myClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "rawType"));
        }
        return psiClassType;
    }

    @Override
    public String getPresentableText() {
        if (this.myPresentableText == null) {
            StringBuilder buffer = new StringBuilder();
            this.buildText(this.myClass, this.mySubstitutor, buffer, false, false);
            this.myPresentableText = buffer.toString();
        }
        return this.myPresentableText;
    }

    @Override
    public String getCanonicalText() {
        if (this.myCanonicalText == null) {
            assert (this.mySubstitutor.isValid());
            StringBuilder buffer = new StringBuilder();
            this.buildText(this.myClass, this.mySubstitutor, buffer, true, false);
            this.myCanonicalText = buffer.toString();
        }
        return this.myCanonicalText;
    }

    @Override
    public String getInternalCanonicalText() {
        if (this.myInternalCanonicalText == null) {
            StringBuilder buffer = new StringBuilder();
            this.buildText(this.myClass, this.mySubstitutor, buffer, true, true);
            this.myInternalCanonicalText = buffer.toString();
        }
        return this.myInternalCanonicalText;
    }

    private void buildText(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull StringBuilder buffer, boolean canonical, boolean internal) {
        PsiElement parent;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult baseResolveResult = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            PsiSubstitutor baseSub = baseResolveResult.getSubstitutor();
            if (baseClass != null) {
                this.buildText(baseClass, baseSub, buffer, canonical, internal);
            }
            return;
        }
        if (canonical == internal) {
            buffer.append(this.getAnnotationsTextPrefix(internal, false, true));
        }
        PsiClass enclosingClass = null;
        if (!aClass.hasModifierProperty("static") && (parent = aClass.getParent()) instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) {
            enclosingClass = (PsiClass)parent;
        }
        if (enclosingClass != null) {
            this.buildText(enclosingClass, substitutor, buffer, canonical, false);
            buffer.append('.');
            buffer.append(aClass.getName());
        } else {
            String qualifiedName;
            String name = !canonical ? aClass.getName() : ((qualifiedName = aClass.getQualifiedName()) == null ? aClass.getName() : qualifiedName);
            buffer.append(name);
        }
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            StringBuilder pineBuffer = new StringBuilder();
            pineBuffer.append('<');
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiType substitutionResult;
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiUtilCore.ensureValid(typeParameter);
                if (i > 0) {
                    pineBuffer.append(',');
                }
                if ((substitutionResult = substitutor.substitute(typeParameter)) == null) {
                    pineBuffer = null;
                    break;
                }
                PsiUtil.ensureValidType(substitutionResult);
                if (canonical) {
                    if (internal) {
                        pineBuffer.append(substitutionResult.getInternalCanonicalText());
                        continue;
                    }
                    pineBuffer.append(substitutionResult.getCanonicalText());
                    continue;
                }
                pineBuffer.append(substitutionResult.getPresentableText());
            }
            if (pineBuffer != null) {
                buffer.append((CharSequence)pineBuffer);
                buffer.append('>');
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid() && this.mySubstitutor.isValid();
    }

    @Override
    public boolean equalsToText(String text) {
        PsiType patternType;
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory();
        try {
            patternType = factory.createTypeFromText(text, this.myClass);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return this.equals(patternType);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myClass.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getLanguageLevel"));
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(this.myClass);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            PsiImmediateClassType psiImmediateClassType = this;
            if (psiImmediateClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
            }
            return psiImmediateClassType;
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(this.myClass, this.mySubstitutor, languageLevel, this.getAnnotations());
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
        }
        return psiImmediateClassType;
    }
}

