/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.JetControlFlowProcessor;
import org.jetbrains.jet.lang.cfg.PseudocodeTraverser;
import org.jetbrains.jet.lang.cfg.PseudocodeVariablesData;
import org.jetbrains.jet.lang.cfg.TailRecursionDetector;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.CallInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LoadUnitValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalFunctionDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.MarkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnNoValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnconditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.TailRecursionKind;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetMainDetector;

public class JetFlowInformationProvider {
    private final JetElement subroutine;
    private final Pseudocode pseudocode;
    private final BindingTrace trace;
    private PseudocodeVariablesData pseudocodeVariablesData;

    private JetFlowInformationProvider(@NotNull JetElement declaration, @NotNull BindingTrace trace, @NotNull Pseudocode pseudocode) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "<init>"));
        }
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "<init>"));
        }
        this.subroutine = declaration;
        this.trace = trace;
        this.pseudocode = pseudocode;
    }

    public JetFlowInformationProvider(@NotNull JetElement declaration, @NotNull BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "<init>"));
        }
        this(declaration, trace, new JetControlFlowProcessor(trace).generatePseudocode(declaration));
    }

    public PseudocodeVariablesData getPseudocodeVariablesData() {
        if (this.pseudocodeVariablesData == null) {
            this.pseudocodeVariablesData = new PseudocodeVariablesData(this.pseudocode, this.trace.getBindingContext());
        }
        return this.pseudocodeVariablesData;
    }

    public void checkFunction(@NotNull JetDeclarationWithBody function, @NotNull JetType expectedReturnType, boolean isLocalObject) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkFunction"));
        }
        if (expectedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReturnType", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkFunction"));
        }
        boolean isPropertyAccessor = function instanceof JetPropertyAccessor;
        if (!isPropertyAccessor) {
            this.recordInitializedVariables();
        }
        this.checkDefiniteReturn(expectedReturnType);
        this.checkLocalFunctions();
        if (isLocalObject) {
            return;
        }
        if (!isPropertyAccessor) {
            this.markUninitializedVariables();
        }
        this.markUnusedVariables();
        this.markUnusedLiteralsInBlock();
        this.markTailCalls();
    }

    private void collectReturnExpressions(final @NotNull Collection<JetElement> returnedExpressions) {
        if (returnedExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedExpressions", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "collectReturnExpressions"));
        }
        final HashSet<Instruction> instructions = Sets.newHashSet(this.pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = this.pseudocode.getExitInstruction();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(){

                @Override
                public void visitReturnValue(ReturnValueInstruction instruction) {
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitReturnNoValue(ReturnNoValueInstruction instruction) {
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitJump(AbstractJumpInstruction instruction) {
                }

                @Override
                public void visitUnconditionalJump(UnconditionalJumpInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                private void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction previousInstruction : instruction.getPreviousInstructions()) {
                        previousInstruction.accept(this);
                    }
                }

                @Override
                public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                @Override
                public void visitMarkInstruction(MarkInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                @Override
                public void visitInstruction(Instruction instruction) {
                    if (!(instruction instanceof JetElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    JetElementInstruction elementInstruction = (JetElementInstruction)instruction;
                    returnedExpressions.add(elementInstruction.getElement());
                }
            });
        }
    }

    private void checkLocalFunctions() {
        for (LocalFunctionDeclarationInstruction localDeclarationInstruction : this.pseudocode.getLocalDeclarations()) {
            JetElement element = localDeclarationInstruction.getElement();
            if (!(element instanceof JetNamedFunction)) continue;
            JetNamedFunction localFunction = (JetNamedFunction)element;
            SimpleFunctionDescriptor functionDescriptor = this.trace.getBindingContext().get(BindingContext.FUNCTION, localFunction);
            JetType expectedType = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            JetFlowInformationProvider providerForLocalDeclaration = new JetFlowInformationProvider(localFunction, this.trace, localDeclarationInstruction.getBody());
            providerForLocalDeclaration.checkDefiniteReturn(expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE);
            providerForLocalDeclaration.markTailCalls();
        }
    }

    public void checkDefiniteReturn(final @NotNull JetType expectedReturnType) {
        if (expectedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReturnType", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkDefiniteReturn"));
        }
        assert (this.subroutine instanceof JetDeclarationWithBody);
        JetDeclarationWithBody function = (JetDeclarationWithBody)this.subroutine;
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        ArrayList<JetElement> returnedExpressions = Lists.newArrayList();
        this.collectReturnExpressions(returnedExpressions);
        final boolean blockBody = function.hasBlockBody();
        final Set<JetElement> rootUnreachableElements = this.collectUnreachableCode();
        for (JetElement element : rootUnreachableElements) {
            this.trace.report(Errors.UNREACHABLE_CODE.on(element));
        }
        final boolean[] noReturnError = new boolean[]{false};
        for (JetElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new JetVisitorVoid(){

                @Override
                public void visitReturnExpression(@NotNull JetReturnExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$2", "visitReturnExpression"));
                    }
                    if (!blockBody) {
                        JetFlowInformationProvider.this.trace.report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on(expression));
                    }
                }

                @Override
                public void visitExpression(@NotNull JetExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$2", "visitExpression"));
                    }
                    if (blockBody && !TypeUtils.noExpectedType(expectedReturnType) && !KotlinBuiltIns.getInstance().isUnit(expectedReturnType) && !rootUnreachableElements.contains(expression)) {
                        noReturnError[0] = true;
                    }
                }
            });
        }
        if (noReturnError[0]) {
            this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on(function));
        }
    }

    private Set<JetElement> collectUnreachableCode() {
        ArrayList<JetElement> unreachableElements = Lists.newArrayList();
        for (Instruction deadInstruction : this.pseudocode.getDeadInstructions()) {
            if (!(deadInstruction instanceof JetElementInstruction) || deadInstruction instanceof LoadUnitValueInstruction) continue;
            unreachableElements.add(((JetElementInstruction)deadInstruction).getElement());
        }
        return JetPsiUtil.findRootExpressions(unreachableElements);
    }

    public void markUninitializedVariables() {
        final HashSet varWithUninitializedErrorGenerated = Sets.newHashSet();
        final HashSet varWithValReassignErrorGenerated = Sets.newHashSet();
        final boolean processClassOrObject = this.subroutine instanceof JetClassOrObject;
        PseudocodeVariablesData pseudocodeVariablesData = this.getPseudocodeVariablesData();
        Map initializers = pseudocodeVariablesData.getVariableInitializers();
        final Set<VariableDescriptor> declaredVariables = pseudocodeVariablesData.getDeclaredVariables(this.pseudocode, true);
        final HashMap reportedDiagnosticMap = Maps.newHashMap();
        PseudocodeTraverser.traverse(this.pseudocode, PseudocodeTraverser.TraversalOrder.FORWARD, initializers, new PseudocodeTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> in, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> out) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$3", "execute"));
                }
                assert (in != null && out != null);
                VariableInitContext ctxt = new VariableInitContext(instruction, reportedDiagnosticMap, in, out);
                if (ctxt.variableDescriptor == null) {
                    return;
                }
                if (instruction instanceof ReadValueInstruction) {
                    JetElement element = ((ReadValueInstruction)instruction).getElement();
                    boolean error = JetFlowInformationProvider.this.checkBackingField(ctxt, element);
                    if (!error && declaredVariables.contains(ctxt.variableDescriptor)) {
                        JetFlowInformationProvider.this.checkIsInitialized(ctxt, element, varWithUninitializedErrorGenerated);
                    }
                    return;
                }
                if (!(instruction instanceof WriteValueInstruction)) {
                    return;
                }
                JetElement element = ((WriteValueInstruction)instruction).getlValue();
                boolean error = JetFlowInformationProvider.this.checkBackingField(ctxt, element);
                if (!(element instanceof JetExpression)) {
                    return;
                }
                if (!error) {
                    error = JetFlowInformationProvider.this.checkValReassignment(ctxt, (JetExpression)element, varWithValReassignErrorGenerated);
                }
                if (!error && processClassOrObject) {
                    error = JetFlowInformationProvider.this.checkAssignmentBeforeDeclaration(ctxt, (JetExpression)element);
                }
                if (!error && processClassOrObject) {
                    JetFlowInformationProvider.this.checkInitializationUsingBackingField(ctxt, (JetExpression)element);
                }
            }
        });
    }

    public void recordInitializedVariables() {
        PseudocodeVariablesData pseudocodeVariablesData = this.getPseudocodeVariablesData();
        Pseudocode pseudocode = pseudocodeVariablesData.getPseudocode();
        Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializers = pseudocodeVariablesData.getVariableInitializers();
        this.recordInitializedVariables(pseudocode, initializers);
        for (LocalFunctionDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            this.recordInitializedVariables(instruction.getBody(), initializers);
        }
    }

    private void checkIsInitialized(@NotNull VariableInitContext ctxt, @NotNull JetElement element, @NotNull Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkIsInitialized"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkIsInitialized"));
        }
        if (varWithUninitializedErrorGenerated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varWithUninitializedErrorGenerated", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkIsInitialized"));
        }
        if (!(element instanceof JetSimpleNameExpression)) {
            return;
        }
        boolean isInitialized = ctxt.exitInitState.isInitialized;
        VariableDescriptor variableDescriptor = ctxt.variableDescriptor;
        if (variableDescriptor instanceof PropertyDescriptor && !this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
            isInitialized = true;
        }
        if (!isInitialized && !varWithUninitializedErrorGenerated.contains(variableDescriptor)) {
            if (!(variableDescriptor instanceof PropertyDescriptor)) {
                varWithUninitializedErrorGenerated.add(variableDescriptor);
            }
            if (variableDescriptor instanceof ValueParameterDescriptor) {
                this.report(Errors.UNINITIALIZED_PARAMETER.on((JetSimpleNameExpression)element, (ValueParameterDescriptor)variableDescriptor), ctxt);
            } else {
                this.report(Errors.UNINITIALIZED_VARIABLE.on((JetSimpleNameExpression)element, variableDescriptor), ctxt);
            }
        }
    }

    private boolean checkValReassignment(@NotNull VariableInitContext ctxt, @NotNull JetExpression expression, @NotNull Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        if (varWithValReassignErrorGenerated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varWithValReassignErrorGenerated", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkValReassignment"));
        }
        VariableDescriptor variableDescriptor = ctxt.variableDescriptor;
        if (JetPsiUtil.isBackingFieldReference(expression) && variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            JetPropertyAccessor accessor = PsiTreeUtil.getParentOfType((PsiElement)expression, JetPropertyAccessor.class);
            if (accessor != null) {
                DeclarationDescriptor accessorDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, accessor);
                if (propertyDescriptor.getGetter() == accessorDescriptor) {
                    return false;
                }
            }
        }
        boolean isInitializedNotHere = ctxt.enterInitState.isInitialized;
        boolean hasBackingField = true;
        if (variableDescriptor instanceof PropertyDescriptor) {
            hasBackingField = this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor);
        }
        if (variableDescriptor.isVar() && variableDescriptor instanceof PropertyDescriptor) {
            DeclarationDescriptor descriptor = BindingContextUtils.getEnclosingDescriptor(this.trace.getBindingContext(), expression);
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)variableDescriptor).getSetter();
            if (Visibilities.isVisible(variableDescriptor, descriptor) && !Visibilities.isVisible(setterDescriptor, descriptor) && setterDescriptor != null) {
                this.report(Errors.INVISIBLE_SETTER.on(expression, variableDescriptor, setterDescriptor.getVisibility(), variableDescriptor.getContainingDeclaration()), ctxt);
                return true;
            }
        }
        if (!(!isInitializedNotHere && hasBackingField || variableDescriptor.isVar() || varWithValReassignErrorGenerated.contains(variableDescriptor))) {
            boolean hasReassignMethodReturningUnit = false;
            JetSimpleNameExpression operationReference = null;
            PsiElement parent = expression.getParent();
            if (parent instanceof JetBinaryExpression) {
                operationReference = ((JetBinaryExpression)parent).getOperationReference();
            } else if (parent instanceof JetUnaryExpression) {
                operationReference = ((JetUnaryExpression)parent).getOperationReference();
            }
            if (operationReference != null) {
                Collection<? extends DeclarationDescriptor> descriptors;
                DeclarationDescriptor descriptor = this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor instanceof FunctionDescriptor && KotlinBuiltIns.getInstance().isUnit(((FunctionDescriptor)descriptor).getReturnType())) {
                    hasReassignMethodReturningUnit = true;
                }
                if (descriptor == null && (descriptors = this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference)) != null) {
                    for (DeclarationDescriptor declarationDescriptor : descriptors) {
                        if (!KotlinBuiltIns.getInstance().isUnit(((FunctionDescriptor)declarationDescriptor).getReturnType())) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                varWithValReassignErrorGenerated.add(variableDescriptor);
                this.report(Errors.VAL_REASSIGNMENT.on(expression, variableDescriptor), ctxt);
                return true;
            }
        }
        return false;
    }

    private boolean checkAssignmentBeforeDeclaration(@NotNull VariableInitContext ctxt, @NotNull JetExpression expression) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkAssignmentBeforeDeclaration"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkAssignmentBeforeDeclaration"));
        }
        if (!ctxt.enterInitState.isDeclared && !ctxt.exitInitState.isDeclared && !ctxt.enterInitState.isInitialized && ctxt.exitInitState.isInitialized) {
            this.report(Errors.INITIALIZATION_BEFORE_DECLARATION.on(expression, ctxt.variableDescriptor), ctxt);
            return true;
        }
        return false;
    }

    private boolean checkInitializationUsingBackingField(@NotNull VariableInitContext ctxt, @NotNull JetExpression expression) {
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkInitializationUsingBackingField"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkInitializationUsingBackingField"));
        }
        VariableDescriptor variableDescriptor = ctxt.variableDescriptor;
        if (variableDescriptor instanceof PropertyDescriptor && !ctxt.enterInitState.isInitialized && ctxt.exitInitState.isInitialized) {
            JetSimpleNameExpression simpleNameExpression;
            if (!variableDescriptor.isVar()) {
                return false;
            }
            if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
                return false;
            }
            PsiElement property2 = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), variableDescriptor);
            assert (property2 instanceof JetProperty);
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.FINAL && ((JetProperty)property2).getSetter() == null) {
                return false;
            }
            JetExpression variable = expression;
            if (expression instanceof JetDotQualifiedExpression && ((JetDotQualifiedExpression)expression).getReceiverExpression() instanceof JetThisExpression) {
                variable = ((JetDotQualifiedExpression)expression).getSelectorExpression();
            }
            if (variable instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)variable).getReferencedNameElementType() != JetTokens.FIELD_IDENTIFIER) {
                if (((PropertyDescriptor)variableDescriptor).getModality() != Modality.FINAL) {
                    this.report(Errors.INITIALIZATION_USING_BACKING_FIELD_OPEN_SETTER.on(expression, variableDescriptor), ctxt);
                } else {
                    this.report(Errors.INITIALIZATION_USING_BACKING_FIELD_CUSTOM_SETTER.on(expression, variableDescriptor), ctxt);
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkBackingField(@NotNull VariableContext cxtx, @NotNull JetElement element) {
        if (cxtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cxtx", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkBackingField"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "checkBackingField"));
        }
        VariableDescriptor variableDescriptor = cxtx.variableDescriptor;
        boolean[] error = new boolean[1];
        if (!this.isCorrectBackingFieldReference(element, cxtx, error, true)) {
            return false;
        }
        if (error[0]) {
            return true;
        }
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            this.report(Errors.NOT_PROPERTY_BACKING_FIELD.on(element), cxtx);
            return true;
        }
        PsiElement property2 = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), variableDescriptor);
        boolean insideSelfAccessors = PsiTreeUtil.isAncestor(property2, element, false);
        if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue() && !insideSelfAccessors) {
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.ABSTRACT) {
                this.report(Errors.NO_BACKING_FIELD_ABSTRACT_PROPERTY.on(element), cxtx);
            } else {
                this.report(Errors.NO_BACKING_FIELD_CUSTOM_ACCESSORS.on(element), cxtx);
            }
            return true;
        }
        if (insideSelfAccessors) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(this.trace.getBindingContext(), element);
        DeclarationDescriptor containingDeclaration = variableDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && DescriptorUtils.isAncestor(containingDeclaration, declarationDescriptor, false)) {
            return false;
        }
        this.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element), cxtx);
        return true;
    }

    private boolean isCorrectBackingFieldReference(@Nullable JetElement element, VariableContext ctxt, boolean[] error, boolean reportError) {
        error[0] = false;
        if (JetPsiUtil.isBackingFieldReference(element)) {
            return true;
        }
        if (element instanceof JetDotQualifiedExpression && this.isCorrectBackingFieldReference(((JetDotQualifiedExpression)element).getSelectorExpression(), ctxt, error, false)) {
            if (((JetDotQualifiedExpression)element).getReceiverExpression() instanceof JetThisExpression) {
                return true;
            }
            error[0] = true;
            if (reportError) {
                this.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element), ctxt);
            }
        }
        return false;
    }

    private void recordInitializedVariables(@NotNull Pseudocode pseudocode, @NotNull Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>>> initializersMap) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "recordInitializedVariables"));
        }
        if (initializersMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializersMap", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "recordInitializedVariables"));
        }
        PseudocodeTraverser.Edges<Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState>> initializers = initializersMap.get(pseudocode.getExitInstruction());
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(pseudocode, false);
        for (VariableDescriptor variable : declaredVariables) {
            if (!(variable instanceof PropertyDescriptor)) continue;
            PseudocodeVariablesData.VariableInitState variableInitState = (PseudocodeVariablesData.VariableInitState)((Map)initializers.in).get(variable);
            if (variableInitState == null) {
                return;
            }
            this.trace.record(BindingContext.IS_INITIALIZED, (PropertyDescriptor)variable, variableInitState.isInitialized);
        }
    }

    public void markUnusedVariables() {
        final PseudocodeVariablesData pseudocodeVariablesData = this.getPseudocodeVariablesData();
        Map variableStatusData = pseudocodeVariablesData.getVariableUseStatusData();
        final HashMap reportedDiagnosticMap = Maps.newHashMap();
        PseudocodeTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>> variableStatusAnalyzeStrategy = new PseudocodeTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> in, @Nullable Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> out) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$4", "execute"));
                }
                assert (in != null && out != null);
                VariableUseContext ctxt = new VariableUseContext(instruction, reportedDiagnosticMap, in, out);
                Set<VariableDescriptor> declaredVariables = pseudocodeVariablesData.getDeclaredVariables(instruction.getOwner(), false);
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, JetFlowInformationProvider.this.trace.getBindingContext());
                if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !DescriptorUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
                    return;
                }
                PseudocodeVariablesData.VariableUseState variableUseState = in.get(variableDescriptor);
                if (instruction instanceof WriteValueInstruction) {
                    if (JetFlowInformationProvider.this.trace.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null) {
                        return;
                    }
                    JetElement element = ((WriteValueInstruction)instruction).getElement();
                    if (variableUseState != PseudocodeVariablesData.VariableUseState.LAST_READ) {
                        IElementType operationToken;
                        if (element instanceof JetBinaryExpression && ((JetBinaryExpression)element).getOperationToken() == JetTokens.EQ) {
                            JetExpression right = ((JetBinaryExpression)element).getRight();
                            if (right != null) {
                                JetFlowInformationProvider.this.report(Errors.UNUSED_VALUE.on(right, right, variableDescriptor), ctxt);
                            }
                        } else if (element instanceof JetPostfixExpression && ((operationToken = ((JetPostfixExpression)element).getOperationReference().getReferencedNameElementType()) == JetTokens.PLUSPLUS || operationToken == JetTokens.MINUSMINUS)) {
                            JetFlowInformationProvider.this.report(Errors.UNUSED_CHANGED_VALUE.on(element, element), ctxt);
                        }
                    }
                } else if (instruction instanceof VariableDeclarationInstruction) {
                    JetDeclaration element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
                    if (!(element instanceof JetNamedDeclaration)) {
                        return;
                    }
                    PsiElement nameIdentifier = ((JetNamedDeclaration)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return;
                    }
                    if (!PseudocodeVariablesData.VariableUseState.isUsed(variableUseState)) {
                        PsiElement psiElement;
                        if (JetPsiUtil.isVariableNotParameterDeclaration(element)) {
                            JetFlowInformationProvider.this.report(Errors.UNUSED_VARIABLE.on((JetNamedDeclaration)element, variableDescriptor), ctxt);
                        } else if (element instanceof JetParameter && (psiElement = element.getParent().getParent()) instanceof JetFunction) {
                            boolean isMain;
                            boolean bl = isMain = psiElement instanceof JetNamedFunction && JetMainDetector.isMain((JetNamedFunction)psiElement);
                            if (psiElement instanceof JetFunctionLiteral) {
                                return;
                            }
                            DeclarationDescriptor descriptor = JetFlowInformationProvider.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, psiElement);
                            assert (descriptor instanceof FunctionDescriptor) : psiElement.getText();
                            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
                            if (!isMain && !functionDescriptor.getModality().isOverridable() && functionDescriptor.getOverriddenDescriptors().isEmpty()) {
                                JetFlowInformationProvider.this.report(Errors.UNUSED_PARAMETER.on((JetParameter)element, variableDescriptor), ctxt);
                            }
                        }
                    } else if (variableUseState == PseudocodeVariablesData.VariableUseState.ONLY_WRITTEN_NEVER_READ && JetPsiUtil.isVariableNotParameterDeclaration(element)) {
                        JetFlowInformationProvider.this.report(Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((JetNamedDeclaration)element, variableDescriptor), ctxt);
                    } else if (variableUseState == PseudocodeVariablesData.VariableUseState.LAST_WRITTEN && element instanceof JetVariableDeclaration) {
                        if (element instanceof JetProperty) {
                            JetExpression initializer = ((JetProperty)element).getInitializer();
                            if (initializer != null) {
                                JetFlowInformationProvider.this.report(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on(initializer, variableDescriptor), ctxt);
                            }
                        } else if (element instanceof JetMultiDeclarationEntry) {
                            JetFlowInformationProvider.this.report(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on(element, variableDescriptor), ctxt);
                        }
                    }
                }
            }
        };
        PseudocodeTraverser.traverse(this.pseudocode, PseudocodeTraverser.TraversalOrder.BACKWARD, variableStatusData, variableStatusAnalyzeStrategy);
    }

    public void markUnusedLiteralsInBlock() {
        final HashMap reportedDiagnosticMap = Maps.newHashMap();
        PseudocodeTraverser.traverse(this.pseudocode, PseudocodeTraverser.TraversalOrder.FORWARD, new PseudocodeTraverser.InstructionAnalyzeStrategy(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$5", "execute"));
                }
                if (!(instruction instanceof ReadValueInstruction)) {
                    return;
                }
                VariableContext ctxt = new VariableContext(instruction, reportedDiagnosticMap);
                JetElement element = ((ReadValueInstruction)instruction).getElement();
                if (!(element instanceof JetFunctionLiteralExpression || element instanceof JetConstantExpression || element instanceof JetStringTemplateExpression || element instanceof JetSimpleNameExpression)) {
                    return;
                }
                PsiElement parent = element.getParent();
                if (parent instanceof JetBlockExpression && !JetPsiUtil.isImplicitlyUsed(element)) {
                    if (element instanceof JetFunctionLiteralExpression) {
                        JetFlowInformationProvider.this.report(Errors.UNUSED_FUNCTION_LITERAL.on((JetFunctionLiteralExpression)element), ctxt);
                    } else {
                        JetFlowInformationProvider.this.report(Errors.UNUSED_EXPRESSION.on(element), ctxt);
                    }
                }
            }
        });
    }

    public void markTailCalls() {
        final DeclarationDescriptor subroutineDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.subroutine);
        if (!(subroutineDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        if (!KotlinBuiltIns.getInstance().isTailRecursive(subroutineDescriptor)) {
            return;
        }
        final HashMap calls = new HashMap();
        PseudocodeTraverser.traverse(this.pseudocode, PseudocodeTraverser.TraversalOrder.FORWARD, new PseudocodeTraverser.InstructionAnalyzeStrategy(){

            @Override
            public void execute(@NotNull Instruction instruction) {
                class KindAndCall {
                    TailRecursionKind kind;
                    ResolvedCall<?> call;

                    KindAndCall(TailRecursionKind kind, ResolvedCall<?> call) {
                        this.kind = kind;
                        this.call = call;
                    }
                }
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$6", "execute"));
                }
                if (!(instruction instanceof CallInstruction)) {
                    return;
                }
                CallInstruction callInstruction = (CallInstruction)instruction;
                ResolvedCall<? extends CallableDescriptor> resolvedCall = JetFlowInformationProvider.this.trace.get(BindingContext.RESOLVED_CALL, callInstruction.getElement());
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor functionDescriptor = resolvedCall.getResultingDescriptor();
                if (!functionDescriptor.getOriginal().equals(subroutineDescriptor)) {
                    return;
                }
                JetElement element = callInstruction.getElement();
                JetExpression parent = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JetTryExpression.class, JetFunction.class, JetClassInitializer.class);
                if (parent instanceof JetTryExpression) {
                    calls.put(element, new KindAndCall(TailRecursionKind.IN_TRY, resolvedCall));
                    return;
                }
                boolean isTail = PseudocodeTraverser.traverseFollowingInstructions(callInstruction, new HashSet<Instruction>(), PseudocodeTraverser.TraversalOrder.FORWARD, new TailRecursionDetector(JetFlowInformationProvider.this.subroutine, callInstruction));
                boolean sameThisObject = JetFlowInformationProvider.this.sameThisObject(resolvedCall);
                TailRecursionKind kind = isTail && sameThisObject ? TailRecursionKind.TAIL_CALL : TailRecursionKind.NON_TAIL;
                KindAndCall kindAndCall = (KindAndCall)calls.get(element);
                calls.put(element, new KindAndCall(JetFlowInformationProvider.combineKinds(kind, kindAndCall == null ? null : kindAndCall.kind), resolvedCall));
            }
        });
        boolean hasTailCalls = false;
        for (Map.Entry entry : calls.entrySet()) {
            JetElement element = (JetElement)entry.getKey();
            KindAndCall kindAndCall = (KindAndCall)entry.getValue();
            switch (kindAndCall.kind) {
                case TAIL_CALL: {
                    this.trace.record(BindingContext.TAIL_RECURSION_CALL, kindAndCall.call, TailRecursionKind.TAIL_CALL);
                    hasTailCalls = true;
                    break;
                }
                case IN_TRY: {
                    this.trace.report(Errors.TAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED.on(element));
                    break;
                }
                case NON_TAIL: {
                    this.trace.report(Errors.NON_TAIL_RECURSIVE_CALL.on(element));
                }
            }
        }
        if (!hasTailCalls) {
            this.trace.report(Errors.NO_TAIL_CALLS_FOUND.on((JetNamedFunction)this.subroutine));
        }
    }

    private boolean sameThisObject(ResolvedCall<?> resolvedCall) {
        JetExpression expression;
        ReceiverParameterDescriptor thisObject = resolvedCall.getResultingDescriptor().getExpectedThisObject();
        ReceiverValue thisObjectValue = resolvedCall.getThisObject();
        if (thisObject == null || !thisObjectValue.exists()) {
            return true;
        }
        DeclarationDescriptor classDescriptor = null;
        if (thisObjectValue instanceof ThisReceiver) {
            classDescriptor = ((ThisReceiver)thisObjectValue).getDeclarationDescriptor();
        } else if (thisObjectValue instanceof ExpressionReceiver && (expression = JetPsiUtil.deparenthesize(((ExpressionReceiver)thisObjectValue).getExpression())) instanceof JetThisExpression) {
            JetThisExpression thisExpression = (JetThisExpression)expression;
            classDescriptor = this.trace.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
        }
        return thisObject.getContainingDeclaration() == classDescriptor;
    }

    private static TailRecursionKind combineKinds(TailRecursionKind kind, @Nullable TailRecursionKind existingKind) {
        TailRecursionKind resultingKind = existingKind == null || existingKind == kind ? kind : (JetFlowInformationProvider.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.TAIL_CALL) ? TailRecursionKind.IN_TRY : (JetFlowInformationProvider.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.NON_TAIL) ? TailRecursionKind.IN_TRY : TailRecursionKind.NON_TAIL));
        return resultingKind;
    }

    private static boolean check(Object a, Object b, Object x, Object y) {
        return a == x && b == y || a == y && b == x;
    }

    private void report(@NotNull Diagnostic diagnostic, @NotNull VariableContext ctxt) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "report"));
        }
        if (ctxt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctxt", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "report"));
        }
        Instruction instruction = ctxt.instruction;
        if (instruction.getCopies().isEmpty()) {
            this.trace.report(diagnostic);
            return;
        }
        Map<Instruction, DiagnosticFactory> previouslyReported = ctxt.reportedDiagnosticMap;
        previouslyReported.put(instruction, diagnostic.getFactory());
        boolean alreadyReported = false;
        boolean sameErrorForAllCopies = true;
        for (Instruction copy : instruction.getCopies()) {
            DiagnosticFactory previouslyReportedErrorFactory = previouslyReported.get(copy);
            if (previouslyReportedErrorFactory != null) {
                alreadyReported = true;
            }
            if (previouslyReportedErrorFactory == diagnostic.getFactory()) continue;
            sameErrorForAllCopies = false;
        }
        if (JetFlowInformationProvider.mustBeReportedOnAllCopies(diagnostic.getFactory())) {
            if (sameErrorForAllCopies) {
                this.trace.report(diagnostic);
            }
        } else if (!alreadyReported) {
            this.trace.report(diagnostic);
        }
    }

    private static boolean mustBeReportedOnAllCopies(@NotNull DiagnosticFactory diagnosticFactory) {
        if (diagnosticFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider", "mustBeReportedOnAllCopies"));
        }
        return diagnosticFactory == Errors.UNUSED_VARIABLE || diagnosticFactory == Errors.UNUSED_PARAMETER || diagnosticFactory == Errors.UNUSED_CHANGED_VALUE;
    }

    private class VariableUseContext
    extends VariableContext {
        final PseudocodeVariablesData.VariableUseState enterUseState;
        final PseudocodeVariablesData.VariableUseState exitUseState;

        private VariableUseContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory> map, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> in, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableUseState> out) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableUseContext", "<init>"));
            }
            super(instruction, map);
            this.enterUseState = this.variableDescriptor != null ? in.get(this.variableDescriptor) : null;
            this.exitUseState = this.variableDescriptor != null ? out.get(this.variableDescriptor) : null;
        }
    }

    private class VariableInitContext
    extends VariableContext {
        final PseudocodeVariablesData.VariableInitState enterInitState;
        final PseudocodeVariablesData.VariableInitState exitInitState;

        private VariableInitContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory> map, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> in, @NotNull Map<VariableDescriptor, PseudocodeVariablesData.VariableInitState> out) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableInitContext", "<init>"));
            }
            super(instruction, map);
            this.enterInitState = this.variableDescriptor != null ? in.get(this.variableDescriptor) : null;
            this.exitInitState = this.variableDescriptor != null ? out.get(this.variableDescriptor) : null;
        }
    }

    private class VariableContext {
        final Map<Instruction, DiagnosticFactory> reportedDiagnosticMap;
        final Instruction instruction;
        final VariableDescriptor variableDescriptor;

        private VariableContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory> map) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableContext", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/lang/cfg/JetFlowInformationProvider$VariableContext", "<init>"));
            }
            this.instruction = instruction;
            this.reportedDiagnosticMap = map;
            this.variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, true, JetFlowInformationProvider.this.trace.getBindingContext());
        }
    }
}

