/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.Function1;
import jet.Function2;
import jet.JetObject;
import jet.KotlinClass;
import jet.TypeCastException;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import jet.suppress;
import kotlin.KotlinPackage;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.BinaryOperationKey;
import org.jetbrains.jet.lang.evaluate.CompileTimeType;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$evaluateBinaryAndCheck$1;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$evaluateBinaryAndCheck$2;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$visitCallExpression$arguments$1;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$visitConstantExpression$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage-ConstantExpressionEvaluator-4b9931f7;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage-OperationsMapGenerated-11c8cd45;
import org.jetbrains.jet.lang.evaluate.UnaryOperationKey;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinClass(abiVersion=13, data={"5\u0018)Y2i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0005Y\u0006twMC\u0002kKRT\u0011B[3uEJ\f\u0017N\\:\u000b\u0007=\u0014xM\u0003\u0006KKR4\u0016n]5u_JT1\u0001]:j\u0015M\u0019u.\u001c9jY\u0016$\u0016.\\3D_:\u001cH/\u00198u\u0015%\u0019wN\\:uC:$8OC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017PC\u0004KKR$\u0016\u0010]3\u000b\u000bQL\b/Z:\u000b\rqJg.\u001b;?\u0015\u0015!(/Y2f\u00151\u0011\u0015N\u001c3j]\u001e$&/Y2f\u0015e\u0019'/Z1uK\u000e{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b\u000bY\fG.^3\u000b\u0015\u0015D\bO]3tg&|gNC\u0007KKR,\u0005\u0010\u001d:fgNLwN\u001c\u0006\rKb\u0004Xm\u0019;fIRK\b/\u001a\u0006\u0007SN\u0004VO]3\u000b\u000f\t{w\u000e\\3b]*!!.\u0019<b\u0015\u0019y%M[3di*92M]3bi\u0016|\u0005/\u001a:bi&|g.\u0011:hk6,g\u000e\u001e\u0006\u000fKb\u0004(/Z:tS>tG+\u001f9f\u0015=\u0019w.\u001c9jY\u0016$\u0016.\\3UsB,'bD\"p[BLG.\u001a+j[\u0016$\u0016\u0010]3\u000b#=\u0003XM]1uS>t\u0017I]4v[\u0016tGOC\u0017D_:\u001cH/\u00198u\u000bb\u0004(/Z:tS>tWI^1mk\u0006$xN\u001d\u0013Pa\u0016\u0014\u0018\r^5p]\u0006\u0013x-^7f]RT\u0001f\u0019:fCR,w\n]3sCRLwN\\!sOVlWM\u001c;G_J4\u0015N]:u!\u0006\u0014\u0018-\\3uKJT\u0001\"\u0019:hk6,g\u000e\u001e\u0006\u0016%\u0016\u001cx\u000e\u001c<fIZ\u000bG.^3Be\u001e,X.\u001a8u\u0015\u0015iw\u000eZ3m\u0015\u0015\u0019\u0017\r\u001c7t\u0015%\u0001\u0018M]1nKR,'O\u0003\rWC2,X\rU1sC6,G/\u001a:EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*\u00113M]3bi\u0016|\u0005/\u001a:bi&|g.\u0011:hk6,g\u000e\u001e$peJ+7-Z5wKJTAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2T!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*1RM^1mk\u0006$XMQ5oCJL\u0018I\u001c3DQ\u0016\u001c7N\u0003\u0005sK\u000e,\u0017N^3s\u0015\u0011q\u0017-\\3\u000b\rM#(/\u001b8h\u00159\u0019\u0017\r\u001c7FqB\u0014Xm]:j_:TA\"\u001a<bYV\fG/Z\"bY2TaBZ;mY\u0016C\bO]3tg&|gN\u0003\nsK\u000e,\u0017N^3s\u000bb\u0004(/Z:tS>t'\"F3wC2,\u0018\r^3V]\u0006\u0014\u00180\u00118e\u0007\",7m\u001b\u0006\u0011SN$\u0015N^5tS>t')\u001f.fe>T\u0001C]3t_24X-\u0011:hk6,g\u000e^:\u000b\u001dY\fG.^3Be\u001e,X.\u001a8ug*!A*[:u\u001551\u0016\r\\;f\u0003J<W/\\3oi*!Q\u000f^5m\u0015e\u0019HO]5oO\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:\u000bo\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8sIM$(/\u001b8h\u000bb\u0004(/Z:tS>tWI^1mk\u0006$xN\u001d\u00132\u0015q9W\r^*ue&tw-\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT\u0001bZ3u)J\f7-\u001a\u0006\u0016m&\u001c\u0018\u000e\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015MQU\r\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015M1\u0018n]5u\u0007\u0006dG.\u0012=qe\u0016\u001c8/[8o\u0015EQU\r^\"bY2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0018m&\u001c\u0018\u000e^\"p]N$\u0018M\u001c;FqB\u0014Xm]:j_:TQCS3u\u0007>t7\u000f^1oi\u0016C\bO]3tg&|gNC\bwSNLGOS3u\u000b2,W.\u001a8u\u0015\u001d)G.Z7f]RT!BS3u\u000b2,W.\u001a8u\u0015q1\u0018n]5u!\u0006\u0014XM\u001c;iKNL'0\u001a3FqB\u0014Xm]:j_:T!DS3u!\u0006\u0014XM\u001c;iKNL'0\u001a3FqB\u0014Xm]:j_:TQC^5tSR\u0004&/\u001a4jq\u0016C\bO]3tg&|gNC\nKKR\u0004&/\u001a4jq\u0016C\bO]3tg&|gN\u0003\rwSNLG/U;bY&4\u0017.\u001a3FqB\u0014Xm]:j_:TaCS3u#V\fG.\u001b4jK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001am&\u001c\u0018\u000e^*j[BdWMT1nK\u0016C\bO]3tg&|gNC\fKKR\u001c\u0016.\u001c9mK:\u000bW.Z#yaJ,7o]5p]*ib/[:jiN#(/\u001b8h)\u0016l\u0007\u000f\\1uK\u0016C\bO]3tg&|gNC\u000eKKR\u001cFO]5oOR+W\u000e\u001d7bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0015m&\u001c\u0018\u000e^+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u000b%)+G/\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c_\u0004\u0015\t\u0001RA\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\u0005)!\u0001b\u0001\t\u0002\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001b\u0001\t\b\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)!\u0001b\u0001\t\u000b\u0015\u0011A\u0001\u0002E\u0005\u000b\r!I\u0001\u0003\u0003\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0017AY\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001RB\u0003\u0004\t\u001bAa\u0001\u0004\u0001\u0006\u0007\u0011!\u0001\u0002\u0003\u0007\u0001\u000b\t!A\u0001\u0003\u0005\u0006\u0007\u0011\u0019\u0001B\u0003\u0007\u0001\u000b\r!Y\u0001c\u0006\r\u0001\u0015\u0011A\u0011\u0002\u0005\u0005\u000b\u0005AA\"\u0002\u0002\u0005\u0015!\tQA\u0001C\u000b\u00113)!\u0001B\u0002\t\u0015\u0015\u0011AQ\u0002\u0005\u0007\u000b\r!!\u0001#\b\r\u0001\u0015\u0019AQ\u0001\u0005\u0010\u0019\u0001)!\u0001\u0002\u0002\t \u0015\u0011AA\u0001E\u000f\u000b\t!A\u0001\u0003\n\u0006\u0005\u0011u\u00012E\u0003\u0004\t=A\u0011\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001rE\u0003\u0004\tAA1\u0003\u0004\u0001\u0006\u0005\u0011y\u0001\"E\u0003\u0003\tAA1#B\u0002\u0005\u001f!)B\u0002A\u0003\u0004\tAAY\u0003\u0004\u0001\u0006\u0005\u0011y\u0001\"F\u0003\u0004\t\u0017Ay\u0003\u0004\u0001\u0006\u0005\u0011U\u0001rF\u0003\u0004\t\u0017AA\u0004\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0012\b\u0007\u0001\u000b\t!!\u0002C\u000f\u0006\u0005\u0011-\u0002\u0002H\u0003\u0003\t\tAa$B\u0002\u0005\u0007!\u0001C\u0002A\u0003\u0003\t\rA\u0001%B\u0002\u0005\u0007!\tC\u0002A\u0003\u0003\t\rA\u0011%B\u0002\u0005\u0007!\u0011C\u0002A\u0003\u0003\t\rA!%B\u0002\u0005\u0007!\u001dC\u0002A\u0003\u0003\t\rA9%B\u0002\u0005\u0007!%C\u0002A\u0003\u0003\t\rAI%B\u0002\u0005\u0007!-C\u0002A\u0003\u0003\t\rAY%B\u0002\u0005\u0007!5C\u0002A\u0003\u0003\t\rAi%B\u0002\u0005\u0007!=C\u0002A\u0003\u0003\t\rAy%B\u0002\u0005\u0007!EC\u0002A\u0003\u0003\t\rA\t&B\u0002\u0005\u0007!MC\u0002A\u0003\u0003\t\rA\u0019\u0006b\u0002\r\u0006E\u0001\u0011\u0004E\u0003\u0002\u0011\u000fI\u0011\"\u0003\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u0002%\u0019\u0011BA\u0003\u0002\u0011\u001dar\",\u001d\u0005\u0001aEQt\u0002\u0003\u0001\u0011%i1!B\u0001\t\r1\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\t\u0002UB\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001b\u0002G\u0001!\u000e\tQT\u0002\u0003\u0002\u0011-i!!B\u0001\t\u0013A\u001b\u0019!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0006\u0005\u0012%\t\u00012C\u0007\u0002\u0011-i\u0011\u0001c\u0006\u000e\u0003!aQ\"\u0001C\u0001[5\"\u0011\u0001G\u0007\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0002ueA\u0001\u0001\u0005\u000f\u001b!)\u0011\u0001#\u0007\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001U\u0002\u0002C\r)\u0011\u0001C\u0007\r\u0002E\u001b\u0011\u0002B\u0007\n\u0003!mQ\"\u0001E\f\u001b\u0005AA\"D\u0001\t\u001d5nB!\u0001\r\u0011;\u001b!\u0001\u0001#\t\u000e\u0005\u0015\t\u0001r\u0004)\u0004\u0001u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001#\tQ\u0007\u0003\t3!B\u0001\t\u001b1\u0005\u0011kA\u0004\u0005!%\t\u00012D\u0007\u0002\u0011Ei\u0011\u0001c\t.H\u0011\t\u0001\u0004FO\r\t\u0001AI#\u0004\u0005\u0006\u0003!\u0011\u0012\"\u0002C\u0001\u0013\r)\u0011\u0001#\n\r\u0002A\u001b\u0001!(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011#\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0002$\u0001R\u0007\u001d!A#C\u0001\t\u001c5\t\u0001bE\u0007\u0002\u0011/iK\u0005B\u0001\u0019\u0002u5A\u0001\u0001E\n\u001b\t)\u0011\u0001#\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011A\u0011\n\u000b\u0005AQ!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0007\u0019\u0003a\t!U\u0002\b\t\u0003I\u0011\u0001c\u0005\u000e\u0003!]Q\"\u0001\u0005\r[C\"\u0011\u0001\u0007\f\u001e\u000e\u0011\u0001\u0001RF\u0007\u0003\u000b\u0005AQ\u0002U\u0002\u0001;\u001b!\u0001\u0001#\n\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0002u5A\u0001\u0001\u0005\u0018\u001b\t)\u0011\u0001c\nQ\u0007\u0005ij\u0001\u0002\u0001\t15\u0011Q!\u0001E\t!\u000e\r\u0011eA\u0003\u0002\u0011\u0019a\t!U\u0002\f\tYI\u0011\u0001C\u0006\u000e\u0003!mQ\"\u0001E\u000e\u001b\u0005AA#D\u0001\t\u00185>D!\u0001M\u0019;\u001b!\u0001\u0001C\r\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0001u5A\u0001\u0001\u0005\u0019\u001b\t)\u0011\u0001#\u0005Q\u0007\u0003ij\u0001\u0002\u0001\t45\u0011Q!\u0001E\t!\u000e\tQt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u000f1\u0005\u0001ka\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u0017\u0011E\u0012\"\u0001E\n\u001b\u0005A9\"D\u0001\t\u00185\t\u0001rC\u0007\u0002\u00111is\u0005B\u0001\u00195u5A\u0001\u0001E\u0017\u001b\t)\u0011\u0001C\u0007Q\u0007\u0001ij\u0001\u0002\u0001\t/5\u0011Q!\u0001E\u0014!\u000e\u0005QT\u0002\u0003\u0001\u0011ai!!B\u0001\t\u0012A\u001b\u0011!I\u0002\u0006\u0003!1A\u0012A)\u0004\u0013\u0011Q\u0012\"\u0001\u0005\f\u001b\u0005AY\"D\u0001\t)5\t\u0001rCW\u001e\t\u0005A*$(\u0004\u0005\u0001!9RBA\u0003\u0002\u0011O\u00016\u0001AO\b\t\u0001A)#D\u0002\u0006\u0003!1A\u0012\u0001)\u0004\u0002\u0005\u0012Q!\u0001\u0005\n#\u000e9AQG\u0005\u0002\t\u0003i\u0011\u0001\u0003\u000b\u000e\u0003!YQV\u000b\u0003\u00021mi*\u0002\u0002\u0001\t851Q!\u0001E\u0015\u0013\rI!!B\u0001\t+A\u001b\u0001!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011\u001d\u00016\u0011A\u0011\r\u000b\u0005AI#C\u0005\n\u0011\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005\u0011kA\u0004\u00057%\t\u0001BF\u0007\u0002\u0011Yi\u0011\u0001\u0003\u0007.\u001f\u0011\tG\u0001g\u000f\"\u0005\u0015\t\u0001BB+\u0004\u0011\u0015\u0019A1H\u0005\u0002\u0011[i1\u0001\"\u0010\n\u0003!5Rf\u0004\u0003a\ta=\u0011EA\u0003\u0002\u0011\u001f)6\u0001C\u0003\u0004\t\u001fI\u0011\u0001\u0003\u0005\u000e\u0007\u0011y\u0012\"\u0001\u0005\t[\u0013\"1\u0002g\u0010\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005Aq\u0003U\u0002\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001b\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0019\u0003\t6a\u0002C \u0013\u0005A\u0019\"D\u0001\t05\t\u0001\u0002DW%\t-A\n%(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011a\u00016\u0001AO\b\t\u0001A)\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9A\u0011I\u0005\u0002\u0011'i\u0011\u0001#\r\u000e\u0003!aQ\u0016\n\u0003\f1\u0007jj\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\u001a!\u000e\u0001Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011\r\u0013\"\u0001E\n\u001b\u0005A\u0019$D\u0001\t\u00195&Ca\u0003M#;\u001b!\u0001\u0001C\u0012\u000e\u0005\u0015\t\u0001B\u0007)\u0004\u0001u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005F%\t\u00012C\u0007\u0002\u0011ki\u0011\u0001\u0003\u0007.J\u0011Y\u0001\u0004JO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!Y\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0003\t\u0013\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\r\u0002E\u001bq\u0001\u0002\u0013\n\u0003!MQ\"\u0001E\u001c\u001b\u0005AA\",\u0013\u0005\u0017a)ST\u0002\u0003\u0001\u0011'i!!B\u0001\t9A\u001b\u0001!h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011\u001da\t\u0001UB\u0001C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u0007\u001d!Q%C\u0001\t\u00145\t\u0001\u0012H\u0007\u0002\u00111iK\u0005B\u0006\u0019Mu5A\u0001\u0001E\n\u001b\t)\u0011\u0001C\u000fQ\u0007\u0001iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011A\u0011\n\u000b\u0005AQ!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0007\u0019\u0003a\t!U\u0002\b\t\u0019J\u0011\u0001c\u0005\u000e\u0003!mR\"\u0001\u0005\r[\u0013\"1\u0002G\u0014\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005Aa\u0004U\u0002\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001b\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0019\u0003\t6a\u0002\u0003(\u0013\u0005A\u0019\"D\u0001\t>5\t\u0001\u0002DW%\t-A\u0002&(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011}\u00016\u0001AO\b\t\u0001A)\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9A\u0001K\u0005\u0002\u0011'i\u0011\u0001c\u0010\u000e\u0003!aQ\u0016\n\u0003\f1%jj\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005!!\u000e\u0001Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011I\u0013\"\u0001E\n\u001b\u0005A\t%D\u0001\t\u0019U&Rq\u0005\u0003b\u0002a9QT\u0002\u0003\u0001\u0011\u001fi!!B\u0001\t\u0010A\u001b\u0001!\t\u0002\u0006\u0003!\u0015\u0011kA\u0003\u0005\u000f%\tA\u0001A\u0007\u0002\u0011!\u0001"})
@suppress(names={"PARAMETER_NAME_CHANGED_ON_OVERRIDE"})
public final class ConstantExpressionEvaluator
extends JetVisitor<CompileTimeConstant<? extends Object>, JetType> {
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    public static final object object$ = object.$init$b$0();

    private final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        CompileTimeConstant recordedCompileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        boolean bl = true;
        if (recordedCompileTimeConstant == null) {
            bl = false;
        }
        if (bl) {
            return recordedCompileTimeConstant;
        }
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant<? extends Object> compileTimeConstant = expression.accept(this, jetType);
        boolean bl2 = true;
        if (compileTimeConstant == null) {
            bl2 = false;
        }
        if (bl2) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitConstantExpression(@JetValueParameter(name="expression") @NotNull JetConstantExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object object2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitConstantExpression"));
        }
        String text = expression.getText();
        boolean bl = true;
        if (text != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object object3 = expression.getNode().getElementType();
        if (Intrinsics.areEqual(object3, JetNodeTypes.INTEGER_CONSTANT)) {
            object2 = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.parseLong(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.FLOAT_CONSTANT)) {
            object2 = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.BOOLEAN_CONSTANT)) {
            object2 = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.parseBoolean(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.CHARACTER_CONSTANT)) {
            object2 = CompileTimeConstantChecker.parseChar(expression);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.NULL)) {
            object2 = null;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        Long result = object2;
        boolean bl2 = true;
        if (result != null) {
            bl2 = false;
        }
        if (bl2 ? Intrinsics.areEqual(expression.getNode().getElementType(), JetNodeTypes.NULL) : false) {
            return NullValue.NULL;
        }
        object3 = new ConstantExpressionEvaluator$visitConstantExpression$1(expression, text);
        return this.createCompileTimeConstant(result, expression, expectedType, !((ConstantExpressionEvaluator$visitConstantExpression$1)object3).invoke());
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitParenthesizedExpression(@JetValueParameter(name="expression") @NotNull JetParenthesizedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitParenthesizedExpression"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        boolean bl = true;
        if (deparenthesizedExpression == null) {
            bl = false;
        }
        if (bl ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) {
            boolean bl2;
            CompileTimeConstant<? extends Object> compileTimeConstant = this.evaluate(deparenthesizedExpression, expectedType);
            Boolean isDeparentesizedPure = (Boolean)this.trace.get(BindingContext.IS_PURE_CONSTANT_EXPRESSION, deparenthesizedExpression);
            boolean bl3 = true;
            if (isDeparentesizedPure == null) {
                bl3 = false;
            }
            if (bl3) {
                Boolean bl4 = isDeparentesizedPure;
                if (bl4 == null) {
                    Intrinsics.throwNpe();
                }
                bl2 = bl4;
            } else {
                bl2 = false;
            }
            if (bl2) {
                this.trace.record(BindingContext.IS_PURE_CONSTANT_EXPRESSION, expression, true);
            }
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitPrefixExpression(@JetValueParameter(name="expression") @NotNull JetPrefixExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitPrefixExpression"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        boolean bl = true;
        if (deparenthesizedExpression == null) {
            bl = false;
        }
        return (bl ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) ? this.evaluate(deparenthesizedExpression, expectedType) : (CompileTimeConstant)super.visitPrefixExpression(expression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitStringTemplateExpression(@JetValueParameter(name="expression") @NotNull JetStringTemplateExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitStringTemplateExpression"));
        }
        StringBuilder sb = new StringBuilder();
        int interupted = 0;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry = jetStringTemplateEntryArray[i];
            StringValue constant = this.stringExpressionEvaluator.evaluate(entry);
            boolean bl = true;
            if (constant != null) {
                bl = false;
            }
            if (bl) {
                interupted = 1;
                break;
            }
            sb.append(constant.getValue());
        }
        return interupted == 0 ? ConstantExpressionEvaluator.createCompileTimeConstant$default(this, sb.toString(), expression, expectedType, false, 8) : (CompileTimeConstant)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitBinaryExpression"));
        }
        JetExpression leftExpression = expression.getLeft();
        boolean bl = true;
        if (leftExpression != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        IElementType operationToken = expression.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
            boolean bl2;
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            CompileTimeConstant<? extends Object> leftConstant = this.evaluate(leftExpression, booleanType);
            boolean bl3 = true;
            if (leftConstant != null) {
                bl3 = false;
            }
            if (bl3) {
                return null;
            }
            JetExpression rightExpression = expression.getRight();
            boolean bl4 = true;
            if (rightExpression != null) {
                bl4 = false;
            }
            if (bl4) {
                return null;
            }
            CompileTimeConstant<? extends Object> rightConstant = this.evaluate(rightExpression, booleanType);
            boolean bl5 = true;
            if (rightConstant != null) {
                bl5 = false;
            }
            if (bl5) {
                return null;
            }
            Object leftValue = leftConstant.getValue();
            Object rightValue = rightConstant.getValue();
            boolean bl6 = !(!(leftValue instanceof Boolean)) ? !(rightValue instanceof Boolean) : true;
            if (bl6) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.ANDAND)) {
                Object object2 = leftValue;
                if (object2 == null) {
                    throw new TypeCastException("jet.Any? cannot be cast to jet.Boolean");
                }
                if (((Boolean)object2).booleanValue()) {
                    Object object3 = rightValue;
                    if (object3 == null) {
                        throw new TypeCastException("jet.Any? cannot be cast to jet.Boolean");
                    }
                    bl2 = (Boolean)object3;
                } else {
                    bl2 = false;
                }
            } else if (Intrinsics.areEqual(iElementType, JetTokens.OROR)) {
                Object object4 = leftValue;
                if (object4 == null) {
                    throw new TypeCastException("jet.Any? cannot be cast to jet.Boolean");
                }
                if (!((Boolean)object4).booleanValue()) {
                    Object object5 = rightValue;
                    if (object5 == null) {
                        throw new TypeCastException("jet.Any? cannot be cast to jet.Boolean");
                    }
                    bl2 = (Boolean)object5;
                } else {
                    bl2 = true;
                }
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result = bl2;
            return ConstantExpressionEvaluator.createCompileTimeConstant$default(this, result, expression, expectedType, false, 8);
        }
        return this.evaluateCall(expression, expression.getOperationReference(), leftExpression, expectedType);
    }

    private final CompileTimeConstant<? extends Object> evaluateCall(@JetValueParameter(name="fullExpression") JetExpression fullExpression, @JetValueParameter(name="callExpression") JetExpression callExpression, @JetValueParameter(name="receiverExpression") JetExpression receiverExpression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        ResolvedCall resolvedCall = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, callExpression);
        boolean bl = true;
        if (resolvedCall != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object d = resolvedCall.getResultingDescriptor();
        Name resultingDescriptorName = d != null ? d.getName() : null;
        boolean bl2 = true;
        if (resultingDescriptorName != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        boolean bl3 = true;
        if (argumentForReceiver != null) {
            bl3 = false;
        }
        if (bl3) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            Object result = this.evaluateUnaryAndCheck(argumentForReceiver, resultingDescriptorName.asString(), callExpression);
            Boolean bl4 = (Boolean)this.trace.get(BindingContext.IS_PURE_CONSTANT_EXPRESSION, argumentForReceiver.getExpression());
            boolean isArgumentPure = bl4 != null ? bl4 : false;
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createCompileTimeConstant(result, fullExpression, expectedType, !isNumberConversionMethod ? isArgumentPure : false);
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant<? extends Object> compileTimeConstant;
            Map.Entry isNumberConversionMethod = (Map.Entry)KotlinPackage.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)KotlinPackage.component1(isNumberConversionMethod);
            ResolvedValueArgument argument = (ResolvedValueArgument)KotlinPackage.component2(isNumberConversionMethod);
            OperationArgument argumentForParameter = null;
            argumentForParameter = this.createOperationArgumentForFirstParameter(argument, parameter);
            boolean bl5 = true;
            if (argumentForParameter != null) {
                bl5 = false;
            }
            if (bl5) {
                return null;
            }
            if (this.isDivisionByZero(resultingDescriptorName.asString(), argumentForParameter.getValue())) {
                return ErrorValue.create("Division by zero");
            }
            Object result = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, resultingDescriptorName.asString(), callExpression);
            Name name = resultingDescriptorName;
            if (Intrinsics.areEqual(name, OperatorConventions.COMPARE_TO)) {
                compileTimeConstant = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createCompileTimeConstantForCompareTo(result, callExpression);
            } else if (Intrinsics.areEqual(name, OperatorConventions.EQUALS)) {
                compileTimeConstant = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createCompileTimeConstantForEquals(result, callExpression);
            } else {
                int n;
                Boolean bl6 = (Boolean)this.trace.get(BindingContext.IS_PURE_CONSTANT_EXPRESSION, argumentForReceiver.getExpression());
                if ((bl6 != null ? bl6 : 0) != 0) {
                    Boolean bl7 = (Boolean)this.trace.get(BindingContext.IS_PURE_CONSTANT_EXPRESSION, argumentForParameter.getExpression());
                    n = (bl7 != null ? bl7 : 0) ? 1 : 0;
                } else {
                    n = 0;
                }
                int areArgumentsPure = n;
                compileTimeConstant = this.createCompileTimeConstant(result, fullExpression, expectedType, areArgumentsPure != 0);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final Object evaluateUnaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions = EvaluatePackage-OperationsMapGenerated-11c8cd45.getUnaryOperations().get(new UnaryOperationKey<Object>(receiver.getCtcType(), name));
        boolean bl = true;
        if (functions != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions;
        Function1<? super Object, ? extends Object> function = pair.component1();
        Function1<? super Long, ? extends Long> check = pair.component2();
        Object result = null;
        result = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, EvaluatePackage-OperationsMapGenerated-11c8cd45.getEmptyUnaryFun())) {
            return result;
        }
        KotlinPackage.assert(EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.isIntegerType(receiver.getValue()), "Only integer constants should be checked for overflow");
        KotlinPackage.assert(Intrinsics.areEqual(name, "minus"), "Only negation should be checked for overflow");
        if (Intrinsics.areEqual(receiver.getValue(), result)) {
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)callExpression, JetExpression.class);
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            this.trace.report(Errors.INTEGER_OVERFLOW.on((JetExpression)((PsiElement)jetExpression)));
        }
        return result;
    }

    private final Object evaluateBinaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="parameter") OperationArgument parameter, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions = EvaluatePackage-OperationsMapGenerated-11c8cd45.getBinaryOperations().get(new BinaryOperationKey<Object, Object>(receiver.getCtcType(), parameter.getCtcType(), name));
        boolean bl = true;
        if (functions != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions;
        Function2<? super Object, ? super Object, ? extends Object> function = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker = pair.component2();
        Object actualResult = null;
        actualResult = function.invoke(receiver.getValue(), parameter.getValue());
        if (Intrinsics.areEqual(checker, EvaluatePackage-OperationsMapGenerated-11c8cd45.getEmptyBinaryFun())) {
            return actualResult;
        }
        KotlinPackage.assert(EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.isIntegerType(receiver.getValue()) ? EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.isIntegerType(parameter.getValue()) : false, ConstantExpressionEvaluator$evaluateBinaryAndCheck$1.instance$);
        ConstantExpressionEvaluator$evaluateBinaryAndCheck$2 constantExpressionEvaluator$evaluateBinaryAndCheck$2 = ConstantExpressionEvaluator$evaluateBinaryAndCheck$2.instance$;
        BigInteger resultInBigIntegers = checker.invoke((BigInteger)constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(receiver.getValue()), (BigInteger)constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(parameter.getValue()));
        if (Intrinsics.areEqual(constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(actualResult), resultInBigIntegers) ^ true) {
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)callExpression, JetExpression.class);
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            this.trace.report(Errors.INTEGER_OVERFLOW.on((JetExpression)((PsiElement)jetExpression)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(@JetValueParameter(name="name") String name, @JetValueParameter(name="parameter", type="?") Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(JetTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.isIntegerType(parameter)) {
                Object object2 = parameter;
                if (object2 == null) {
                    throw new TypeCastException("jet.Any? cannot be cast to jet.Number");
                }
                return ((Number)object2).longValue() == (long)0;
            }
            if (!(parameter instanceof Float) ? parameter instanceof Double : true) {
                Object object3 = parameter;
                if (object3 == null) {
                    throw new TypeCastException("jet.Any? cannot be cast to jet.Number");
                }
                return ((Number)object3).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitUnaryExpression"));
        }
        JetExpression leftExpression = expression.getBaseExpression();
        boolean bl = true;
        if (leftExpression != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        return this.evaluateCall(expression, expression.getOperationReference(), leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object callableDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitSimpleNameExpression"));
        }
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        boolean bl = true;
        if (enumDescriptor == null) {
            bl = false;
        }
        if (bl ? DescriptorUtils.isEnumEntry(enumDescriptor) : false) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor? cannot be cast to org.jetbrains.jet.lang.descriptors.ClassDescriptor");
            }
            return new EnumValue((ClassDescriptor)declarationDescriptor);
        }
        ResolvedCall resolvedCall = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression);
        boolean bl2 = true;
        if (resolvedCall == null) {
            bl2 = false;
        }
        if (bl2 && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof PropertyDescriptor && AnnotationUtils.isPropertyCompileTimeConstant((PropertyDescriptor)callableDescriptor)) {
            return (CompileTimeConstant)this.trace.getBindingContext().get(BindingContext.COMPILE_TIME_INITIALIZER, callableDescriptor);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitQualifiedExpression(@JetValueParameter(name="expression") @NotNull JetQualifiedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitQualifiedExpression"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression receiverExpression = expression.getReceiverExpression();
            return this.evaluateCall(expression, calleeExpression, receiverExpression, expectedType);
        }
        boolean bl = true;
        if (selectorExpression == null) {
            bl = false;
        }
        if (bl) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        ClassDescriptor classDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitCallExpression"));
        }
        ResolvedCall call = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        boolean bl = true;
        if (call != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object resultingDescriptor = call.getResultingDescriptor();
        boolean bl2 = true;
        if (resultingDescriptor != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        if (AnnotationUtils.isArrayMethodCall(call)) {
            ValueParameterDescriptor valueParameterDescriptor = KotlinPackage.getFirst(resultingDescriptor.getValueParameters());
            JetType jetType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            JetType varargType = jetType;
            List<CompileTimeConstant<?>> arguments2 = KotlinPackage.flatMap((Iterable)call.getValueArguments().values(), (Function1)new ConstantExpressionEvaluator$visitCallExpression$arguments$1(this, varargType));
            JetType jetType2 = resultingDescriptor.getReturnType();
            if (jetType2 == null) {
                Intrinsics.throwNpe();
            }
            return new ArrayValue(arguments2, jetType2);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnnotationClass(classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration())) {
            AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl();
            descriptor.setAnnotationType(classDescriptor.getDefaultType());
            AnnotationResolver.resolveAnnotationArgument(descriptor, call, this.trace);
            return new AnnotationValue(descriptor);
        }
        if (AnnotationUtils.isJavaClassMethodCall(call)) {
            return new JavaClassValue(resultingDescriptor.getReturnType());
        }
        return null;
    }

    private final List<CompileTimeConstant<? extends Object>> resolveArguments(@JetValueParameter(name="valueArguments") List<? extends ValueArgument> valueArguments, @JetValueParameter(name="expectedType") JetType expectedType) {
        ArrayList<CompileTimeConstant> constants = KotlinPackage.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            boolean bl = true;
            if (argumentExpression == null) {
                bl = false;
            }
            if (!bl) continue;
            CompileTimeConstant<? extends Object> constant = this.evaluate(argumentExpression, expectedType);
            boolean bl2 = true;
            if (constant == null) {
                bl2 = false;
            }
            if (!bl2) continue;
            constants.add(constant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitJetElement(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitJetElement"));
        }
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(@JetValueParameter(name="resolvedCall") ResolvedCall<? extends CallableDescriptor> resolvedCall, @JetValueParameter(name="expression") JetExpression expression) {
        JetType receiverExpressionType = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getReceiverExpressionType(resolvedCall);
        boolean bl = true;
        if (receiverExpressionType != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getCompileTimeType(receiverExpressionType);
        boolean bl2 = true;
        if (receiverCompileTimeType != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(@JetValueParameter(name="argument") ResolvedValueArgument argument, @JetValueParameter(name="parameter") ValueParameterDescriptor parameter) {
        CompileTimeType<? extends Object> argumentCompileTimeType = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getCompileTimeType(parameter.getType());
        boolean bl = true;
        if (argumentCompileTimeType != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        if (KotlinPackage.getSize((Collection<? extends Object>)arguments2) != 1) {
            return null;
        }
        JetExpression argumentExpression = KotlinPackage.first(arguments2).getArgumentExpression();
        boolean bl2 = true;
        if (argumentExpression != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return this.createOperationArgument(argumentExpression, parameter.getType(), argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expressionType") JetType expressionType, @JetValueParameter(name="compileTimeType") CompileTimeType<? extends Object> compileTimeType) {
        CompileTimeConstant<? extends Object> compileTimeConstant = this.evaluate(expression, expressionType);
        Object evaluationResult = compileTimeConstant != null ? compileTimeConstant.getValue() : null;
        boolean bl = true;
        if (evaluationResult != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        if (evaluationResult instanceof IntegerValueTypeConstructor) {
            Object evaluationResultWithNewType = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getValueForNumberType((IntegerValueTypeConstructor)evaluationResult, expressionType);
            boolean bl2 = true;
            if (evaluationResultWithNewType == null) {
                bl2 = false;
            }
            if (bl2) {
                return new OperationArgument(evaluationResultWithNewType, compileTimeType, expression);
            }
        }
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    @Nullable
    public final CompileTimeConstant<? extends Object> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType, @JetValueParameter(name="isPure") boolean isPure) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "createCompileTimeConstant"));
        }
        if (isPure) {
            CompileTimeConstant<? extends Object> compileTimeConstant = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createConvertibleCompileTimeConstant(value, expectedType);
            this.trace.record(BindingContext.IS_PURE_CONSTANT_EXPRESSION, expression, true);
            return compileTimeConstant;
        }
        CompileTimeConstant<? extends Object> compileTimeConstant = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createUnconvertibleCompileTimeConstant(value);
        return compileTimeConstant;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ CompileTimeConstant createCompileTimeConstant$default(ConstantExpressionEvaluator constantExpressionEvaluator, Object object2, JetExpression jetExpression, JetType jetType, boolean bl, int n) {
        int n2;
        void var5_6;
        if ((var5_6 & 8) != 0) {
            n2 = 1;
        }
        return constantExpressionEvaluator.createCompileTimeConstant(object2, jetExpression, jetType, n2 != 0);
    }

    @NotNull
    public final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "getTrace"));
        }
        return bindingTrace;
    }

    private ConstantExpressionEvaluator(@JetValueParameter(name="trace") BindingTrace trace) {
        this.trace = trace;
        this.stringExpressionEvaluator = new JetVisitor<StringValue, Void>(this){
            final /* synthetic */ ConstantExpressionEvaluator this$0;

            @Nullable
            public final StringValue evaluate(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "evaluate"));
                }
                return entry.accept(this, null);
            }

            @Nullable
            public StringValue visitStringTemplateEntryWithExpression(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntryWithExpression entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitStringTemplateEntryWithExpression"));
                }
                JetExpression expression = entry.getExpression();
                boolean bl = true;
                if (expression != null) {
                    bl = false;
                }
                if (bl) {
                    return null;
                }
                return EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createStringConstant(ConstantExpressionEvaluator.evaluate$b$1(this.this$0, expression, KotlinBuiltIns.getInstance().getStringType()));
            }

            @NotNull
            public StringValue visitLiteralStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetLiteralStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                StringValue stringValue = new StringValue(entry.getText());
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                return stringValue;
            }

            @NotNull
            public StringValue visitEscapeStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetEscapeStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                StringValue stringValue = new StringValue(entry.getUnescapedValue());
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                return stringValue;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Nullable
    public static final /* synthetic */ CompileTimeConstant evaluate$b$1(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "evaluate$b$1"));
        }
        return $this.evaluate(expression, expectedType);
    }

    @NotNull
    public static final /* synthetic */ List resolveArguments$b$2(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="valueArguments") @NotNull List valueArguments, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        List<CompileTimeConstant<? extends Object>> list2 = $this.resolveArguments(valueArguments, expectedType);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        return list2;
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator $init$b$0(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(trace);
        if (constantExpressionEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        return constantExpressionEvaluator;
    }

    @KotlinClass(abiVersion=13, data={"t\u0004)qCh\u00197bgNlsN\u00196fGRlcm\u001c:.\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:?\u0015m\u0019uN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*AQM^1mk\u0006$XM\u0003\u0003mC:<'b\u00016fi*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0004_J<'bA!os*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0006iJ\f7-\u001a\u0006\r\u0005&tG-\u001b8h)J\f7-\u001a\u0006\be\u0016\u001cx\u000e\u001c<f\u00151)\u0007\u0010]3di\u0016$G+\u001f9f\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNT1cQ8na&dW\rV5nK\u000e{gn\u001d;b]RT\u0011bY8ogR\fg\u000e^:\t\u0004)\u0011\u0001C\u0002\u0006\u0005\u0011\u0001\u0001RA\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\rQA\u0001C\u0002\u0011\u0005)1\u0001\u0002\u0002\t\u00021\u0001Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0005\u0015\u0019Aq\u0001E\u0004\u0019\u0001)!\u0001b\u0001\t\u000b\u0015\u0019A\u0011\u0002E\u0005\u0019\u0001)!\u0001b\u0001\t\u000e\u0015\u0019A1\u0002\u0005\u0007\u0019\u0001)!\u0001b\u0001\t\u0011\u0015\u0019AQ\u0002E\b\u0019\u0001)!\u0001b\u0003\t\u0013\u0015\u0019Aq\u0002E\t\u0019\u0001)!\u0001b\u0004\t\u0012\u0015\u0011A\u0011\u0002E\u0005\u000b\t!Y\u0001\u0003\u0004\u0006\u0005\u00115\u0001r\u0002\u0003D\u00041\u0019\u0011DA\u0003\u0002\u0011\u0011ic\u0006B\u0002\u0019\u0003u5A\u0001\u0001\u0005\u0005\u001b\t)\u0011\u0001C\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0007!\u000e\u0005Qt\u0002\u0003\u0002\u0011\u001di1!B\u0001\t\u000f1\u0005\u0001kA\u0001\"\u0013\u0015\t\u0001\u0002C\u0005\u0006\t\u0003I1!B\u0001\t\t1\u0005A\u0012A)\u0004\u0013\u0011\t\u0011\"\u0001E\t\u001b\u0005A\u0011\"D\u0001\t\u00145\t\u0001BC\u001b\u0001"})
    public static final class object
    implements JetObject {
        @Nullable
        public final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            ConstantExpressionEvaluator evaluator = ConstantExpressionEvaluator.$init$b$0(trace);
            return ConstantExpressionEvaluator.evaluate$b$1(evaluator, expression, expectedType);
        }

        public static /* synthetic */ CompileTimeConstant evaluate$default(object object2, JetExpression jetExpression, BindingTrace bindingTrace, JetType jetType, int n) {
            if ((n & 4) != 0) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            return object2.evaluate(jetExpression, bindingTrace, jetType);
        }

        private object() {
        }

        @NotNull
        public static final /* synthetic */ object $init$b$0() {
            object object2 = new object();
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "$init$b$0"));
            }
            return object2;
        }
    }

    @KotlinClass(abiVersion=13, data={"W\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b7\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015!)g/\u00197vCR,'\u0002\u00027b]\u001eT1A[3u\u0015%QW\r\u001e2sC&t7OC\u0002pe\u001eT1!\u00118z\u0015\u0019a\u0014N\\5u}))a/\u00197vK*91\r^2UsB,'bD\"p[BLG.\u001a+j[\u0016$\u0016\u0010]3\u000b\u0015\u0015D\bO]3tg&|gNC\u0007KKR,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004aNL'\u0002\u00026bm\u0006Taa\u00142kK\u000e$(BC4fi\u000e#8\rV=qK*iq-\u001a;FqB\u0014Xm]:j_:T\u0001bZ3u-\u0006dW/\u001a6\u000b\u0005A1!\u0002\u0002\u0005\u0001!\u0015QA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0004\u0015\u0011A1\u0001\u0005\u0002\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\r!!\u0001c\u0003\r\u0001\u0015\u0011A1\u0001\u0005\b\u000b\r!Q\u0001#\u0004\r\u0001\u0015\t\u0001rB\u0003\u0003\t\u0019A\u0019!\u0002\u0002\u0005\u000e!AQA\u0001\u0003\u0003\u0011\u0017)!\u0001B\u0003\t\u000e\u0011\tAbA\r\u0003\u000b\u0005AA!L\u000b\u0005A\u0012AR!\t\u0005\u0006\u0003!%\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0003\r\u0002U\u001b\u0001\"B\u0002\u0005\u000b%\t\u0001rB\u0007\u0004\t#I\u0011\u0001c\u0004.\u001f\u0011\u0001G\u0001\u0007\u0004\"\u0005\u0015\t\u00012B+\u0004\u0011\u0015\u0019AAB\u0005\u0002\u0011!i1\u0001B\u0005\n\u0003!AQf\u0004\u0003a\ta%\u0011EA\u0003\u0002\u0011\u0011)6\u0001C\u0003\u0004\t\u0013I\u0011\u0001C\u0004\u000e\u0007\u0011M\u0011\"\u0001\u0005\bk7*I\u0006Br\u00011\u0011ij\u0001\u0002\u0001\t\n5\u0011Q!\u0001\u0005\u0005!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011\u0015i\u0001\"B\u0001\t\n%)A\u0011A\u0005\u0004\u000b\u0005AA\u0001$\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t\r5\u0011Q!\u0001E\u0006!\u000e\t\u0011EA\u0003\u0002\u0011\r\t6!\u0003\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\u000f5\t\u0001rB\u0007\u0002\u0011!\u0001"})
    private static final class OperationArgument
    implements JetObject {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<? extends Object> ctcType;
        @NotNull
        private final JetExpression expression;

        @NotNull
        public final Object getValue() {
            Object object2 = this.value;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getValue"));
            }
            return object2;
        }

        @NotNull
        public final CompileTimeType<? extends Object> getCtcType() {
            CompileTimeType<? extends Object> compileTimeType = this.ctcType;
            if (compileTimeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getCtcType"));
            }
            return compileTimeType;
        }

        @NotNull
        public final JetExpression getExpression() {
            JetExpression jetExpression = this.expression;
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getExpression"));
            }
            return jetExpression;
        }

        @NotNull
        public OperationArgument(@JetValueParameter(name="value") @NotNull Object value, @JetValueParameter(name="ctcType") @NotNull CompileTimeType<? extends Object> ctcType, @JetValueParameter(name="expression") @NotNull JetExpression expression) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (ctcType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctcType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

