/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;

public class ScriptNameUtil {
    private ScriptNameUtil() {
    }

    public static String classNameForScript(JetFile file) {
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
        String name = file.getName();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if (name.endsWith(scriptDefinition.getExtension())) {
            name = name.substring(0, name.length() - scriptDefinition.getExtension().length());
        } else {
            index = name.indexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
        }
        name = Character.toUpperCase(name.charAt(0)) + (name.length() == 0 ? "" : name.substring(1));
        JetNamespaceHeader header = file.getNamespaceHeader();
        if (header != null && header.getName().length() > 0) {
            name = header.getName().replace('.', '/') + "/" + name;
        }
        return name;
    }
}

