/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public class JavaVisibilities {
    public static final Visibility PACKAGE_VISIBILITY = new Visibility("package", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$1", "isVisible"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$1", "isVisible"));
            }
            return JavaVisibilities.isInSameNamespace(what, from);
        }

        @Override
        protected Integer compareTo(@NotNull Visibility visibility) {
            if (visibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$1", "compareTo"));
            }
            if (this == visibility) {
                return 0;
            }
            if (visibility == Visibilities.PRIVATE) {
                return 1;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "public/*package*/";
        }

        @Override
        @NotNull
        public Visibility normalize() {
            Visibility visibility = Visibilities.INTERNAL;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$1", "normalize"));
            }
            return visibility;
        }
    };
    public static final Visibility PROTECTED_STATIC_VISIBILITY = new Visibility("protected_static", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            ClassDescriptor whatClass;
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$2", "isVisible"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$2", "isVisible"));
            }
            ClassDescriptor fromClass = DescriptorUtils.getParentOfType(from, ClassDescriptor.class, false);
            if (fromClass == null) {
                return false;
            }
            if (what instanceof ClassDescriptor) {
                DeclarationDescriptor containingDeclaration = what.getContainingDeclaration();
                assert (containingDeclaration instanceof ClassDescriptor) : "Only static nested classes can have protected_static visibility";
                whatClass = (ClassDescriptor)containingDeclaration;
            } else {
                DeclarationDescriptor whatDeclarationDescriptor = what.getContainingDeclaration();
                assert (whatDeclarationDescriptor instanceof NamespaceDescriptor) : "Only static declarations can have protected_static visibility";
                whatClass = JavaVisibilities.getClassForCorrespondingJavaNamespace((NamespaceDescriptor)whatDeclarationDescriptor);
            }
            assert (whatClass != null) : "Couldn't find ClassDescriptor for protected static member " + what;
            if (DescriptorUtils.isSubclass(fromClass, whatClass)) {
                return true;
            }
            return this.isVisible(what, fromClass.getContainingDeclaration());
        }

        @Override
        public String toString() {
            return "protected/*protected static*/";
        }

        @Override
        @NotNull
        public Visibility normalize() {
            Visibility visibility = Visibilities.PROTECTED;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$2", "normalize"));
            }
            return visibility;
        }
    };
    public static final Visibility PROTECTED_AND_PACKAGE = new Visibility("protected_and_package", false){

        @Override
        protected boolean isVisible(@NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$3", "isVisible"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$3", "isVisible"));
            }
            if (JavaVisibilities.isInSameNamespace(what, from)) {
                return true;
            }
            ClassDescriptor whatClass = DescriptorUtils.getParentOfType(what, ClassDescriptor.class, false);
            if (whatClass == null) {
                return false;
            }
            ClassDescriptor fromClass = DescriptorUtils.getParentOfType(from, ClassDescriptor.class, false);
            if (fromClass == null) {
                return false;
            }
            if (DescriptorUtils.isSubclass(fromClass, whatClass)) {
                return true;
            }
            return this.isVisible(what, fromClass.getContainingDeclaration());
        }

        @Override
        protected Integer compareTo(@NotNull Visibility visibility) {
            if (visibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$3", "compareTo"));
            }
            if (this == visibility) {
                return 0;
            }
            if (visibility == Visibilities.INTERNAL) {
                return null;
            }
            if (visibility == Visibilities.PRIVATE) {
                return 1;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "protected/*protected and package*/";
        }

        @Override
        @NotNull
        public Visibility normalize() {
            Visibility visibility = Visibilities.PROTECTED;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities$3", "normalize"));
            }
            return visibility;
        }
    };

    private JavaVisibilities() {
    }

    private static boolean isInSameNamespace(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities", "isInSameNamespace"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities", "isInSameNamespace"));
        }
        NamespaceDescriptor whatPackage = DescriptorUtils.getParentOfType(first, NamespaceDescriptor.class, false);
        NamespaceDescriptor fromPackage = DescriptorUtils.getParentOfType(second, NamespaceDescriptor.class, false);
        return fromPackage != null && whatPackage != null && JavaVisibilities.fqNamesEqual(whatPackage, fromPackage);
    }

    private static boolean fqNamesEqual(@NotNull NamespaceDescriptor a, @NotNull NamespaceDescriptor b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities", "fqNamesEqual"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities", "fqNamesEqual"));
        }
        return DescriptorUtils.getFQName(a).equals(DescriptorUtils.getFQName(b));
    }

    @Nullable
    private static ClassDescriptor getClassForCorrespondingJavaNamespace(@NotNull NamespaceDescriptor correspondingNamespace) {
        if (correspondingNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correspondingNamespace", "org/jetbrains/jet/lang/resolve/java/JavaVisibilities", "getClassForCorrespondingJavaNamespace"));
        }
        NamespaceDescriptorParent containingDeclaration = correspondingNamespace.getContainingDeclaration();
        if (!(containingDeclaration instanceof NamespaceDescriptor)) {
            return null;
        }
        NamespaceDescriptor namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
        ClassifierDescriptor classDescriptor = namespaceDescriptor.getMemberScope().getClassifier(correspondingNamespace.getName());
        if (classDescriptor != null && classDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)classDescriptor;
        }
        ClassDescriptor classDescriptorForOuterClass = JavaVisibilities.getClassForCorrespondingJavaNamespace(namespaceDescriptor);
        if (classDescriptorForOuterClass == null) {
            return null;
        }
        ClassifierDescriptor innerClassDescriptor = classDescriptorForOuterClass.getUnsubstitutedInnerClassesScope().getClassifier(correspondingNamespace.getName());
        if (innerClassDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)innerClassDescriptor;
        }
        return null;
    }
}

