/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.operation.IncrementTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        IElementType operationToken = expression.getOperationReference().getReferencedNameElementType();
        if (operationToken == JetTokens.EXCLEXCL) {
            JsConditional jsConditional = TranslationUtils.sure(Translation.translateAsExpression(PsiUtils.getBaseExpression(expression), context), context);
            if (jsConditional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsConditional;
        }
        if (IncrementTranslator.isIncrement(operationToken)) {
            JsExpression jsExpression = IncrementTranslator.translate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression baseExpression = TranslationUtils.translateBaseExpression(context, expression);
        if (UnaryOperationTranslator.isExclForBinaryEqualLikeExpr(expression, baseExpression)) {
            JsExpression jsExpression = TranslationUtils.translateExclForBinaryEqualLikeExpr((JsBinaryOperation)baseExpression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = CallBuilder.build(context).receiver(TranslationUtils.translateBaseExpression(context, expression)).resolvedCall(BindingUtils.getResolvedCall(context.bindingContext(), expression.getOperationReference())).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        return jsExpression;
    }

    private static boolean isExclForBinaryEqualLikeExpr(@NotNull JetUnaryExpression expression, @NotNull JsExpression baseExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "isExclForBinaryEqualLikeExpr"));
        }
        if (baseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseExpression", "org/jetbrains/k2js/translate/operation/UnaryOperationTranslator", "isExclForBinaryEqualLikeExpr"));
        }
        if (PsiUtils.getOperationToken(expression).equals(JetTokens.EXCL) && baseExpression instanceof JsBinaryOperation) {
            return TranslationUtils.isEqualLikeOperator(((JsBinaryOperation)baseExpression).getOperator());
        }
        return false;
    }
}

