/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsWhile;

class JsPrecedenceVisitor
extends JsVisitor {
    private int answer = -1;

    public static int exec(JsExpression expression) {
        JsPrecedenceVisitor visitor = new JsPrecedenceVisitor();
        visitor.accept(expression);
        if (visitor.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor.answer;
    }

    private JsPrecedenceVisitor() {
    }

    @Override
    public boolean visit(JsArrayAccess x, JsContext ctx) {
        this.answer = 16;
        return false;
    }

    @Override
    public boolean visit(JsArrayLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsBinaryOperation x, JsContext ctx) {
        this.answer = x.getOperator().getPrecedence();
        return false;
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsLiteral.JsBooleanLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsBreak x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsCatch x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsConditional x, JsContext ctx) {
        this.answer = 3;
        return false;
    }

    @Override
    public boolean visit(JsContinue x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsDoWhile x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsEmpty x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsExpressionStatement x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsIf x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        this.answer = 16;
        return false;
    }

    @Override
    public boolean visit(JsNameRef x, JsContext ctx) {
        this.answer = x.isLeaf() ? 17 : 16;
        return false;
    }

    @Override
    public boolean visit(JsNew x, JsContext ctx) {
        this.answer = 15;
        return false;
    }

    @Override
    public boolean visit(JsNullLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsNumberLiteral.JsIntLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsNumberLiteral.JsDoubleLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsObjectLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsParameter x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsPostfixOperation x, JsContext ctx) {
        this.answer = x.getOperator().getPrecedence();
        return false;
    }

    @Override
    public boolean visit(JsPrefixOperation x, JsContext ctx) {
        this.answer = x.getOperator().getPrecedence();
        return false;
    }

    @Override
    public boolean visit(JsProgram x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsPropertyInitializer x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsReturn x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsStringLiteral x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsLiteral.JsThisRef x, JsContext ctx) {
        this.answer = 17;
        return false;
    }

    @Override
    public boolean visit(JsThrow x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsTry x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsVars.JsVar x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsVars x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        throw new RuntimeException("Only expressions have precedence.");
    }
}

