/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.JsConstructExpressionVisitor;
import com.google.dart.compiler.backend.js.JsFirstExpressionVisitor;
import com.google.dart.compiler.backend.js.JsPrecedenceVisitor;
import com.google.dart.compiler.backend.js.JsRequiresSemiVisitor;
import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsDocComment;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsOperator;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsWhile;
import com.google.dart.compiler.util.TextOutput;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsToStringGenerationVisitor
extends JsVisitor {
    private static final char[] CHARS_BREAK = "break".toCharArray();
    private static final char[] CHARS_CASE = "case".toCharArray();
    private static final char[] CHARS_CATCH = "catch".toCharArray();
    private static final char[] CHARS_CONTINUE = "continue".toCharArray();
    private static final char[] CHARS_DEBUGGER = "debugger".toCharArray();
    private static final char[] CHARS_DEFAULT = "default".toCharArray();
    private static final char[] CHARS_DO = "do".toCharArray();
    private static final char[] CHARS_ELSE = "else".toCharArray();
    private static final char[] CHARS_FALSE = "false".toCharArray();
    private static final char[] CHARS_FINALLY = "finally".toCharArray();
    private static final char[] CHARS_FOR = "for".toCharArray();
    private static final char[] CHARS_FUNCTION = "function".toCharArray();
    private static final char[] CHARS_IF = "if".toCharArray();
    private static final char[] CHARS_IN = "in".toCharArray();
    private static final char[] CHARS_NEW = "new".toCharArray();
    private static final char[] CHARS_NULL = "null".toCharArray();
    private static final char[] CHARS_RETURN = "return".toCharArray();
    private static final char[] CHARS_SWITCH = "switch".toCharArray();
    private static final char[] CHARS_THIS = "this".toCharArray();
    private static final char[] CHARS_THROW = "throw".toCharArray();
    private static final char[] CHARS_TRUE = "true".toCharArray();
    private static final char[] CHARS_TRY = "try".toCharArray();
    private static final char[] CHARS_VAR = "var".toCharArray();
    private static final char[] CHARS_WHILE = "while".toCharArray();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected boolean needSemi = true;
    private boolean lineBreakAfterBlock = true;
    private Set<JsBlock> globalBlocks = new THashSet<JsBlock>();
    protected final TextOutput p;

    public static CharSequence javaScriptString(String value) {
        return JsToStringGenerationVisitor.javaScriptString(value, false);
    }

    public static CharSequence javaScriptString(CharSequence chars, boolean forceDoubleQuote) {
        int n = chars.length();
        int quoteCount = 0;
        int aposCount = 0;
        block14: for (int i = 0; i < n; ++i) {
            switch (chars.charAt(i)) {
                case '\"': {
                    ++quoteCount;
                    continue block14;
                }
                case '\'': {
                    ++aposCount;
                }
            }
        }
        StringBuilder result = new StringBuilder(n + 16);
        char quoteChar = quoteCount < aposCount || forceDoubleQuote ? (char)'\"' : '\'';
        result.append(quoteChar);
        for (int i = 0; i < n; ++i) {
            int hexSize;
            char c = chars.charAt(i);
            if (' ' <= c && c <= '~' && c != quoteChar && c != '\\') {
                result.append(c);
                continue;
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case '\'': {
                    escape = 39;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                result.append('\\');
                result.append((char)escape);
                continue;
            }
            if (c < ' ' && (i == n - 1 || chars.charAt(i + 1) < '0' || chars.charAt(i + 1) > '9')) {
                result.append('\\');
                if (c > '\u0007') {
                    result.append((char)(48 + (7 & c >> 3)));
                }
                result.append((char)(48 + (7 & c)));
                continue;
            }
            if (c < '\u0100') {
                result.append("\\x");
                hexSize = 2;
            } else {
                result.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                result.append(HEX_DIGITS[digit]);
            }
        }
        result.append(quoteChar);
        JsToStringGenerationVisitor.escapeClosingTags(result);
        return result;
    }

    private static void escapeClosingTags(StringBuilder str) {
        if (str == null) {
            return;
        }
        int index = 0;
        while ((index = str.indexOf("</", index)) != -1) {
            str.insert(index + 1, '\\');
        }
    }

    public JsToStringGenerationVisitor(TextOutput out) {
        this.p = out;
    }

    @Override
    public boolean visit(JsArrayAccess x, JsContext context) {
        this.printPair(x, x.getArrayExpression());
        this.leftSquare();
        this.accept(x.getIndexExpression());
        this.rightSquare();
        return false;
    }

    @Override
    public boolean visit(JsArrayLiteral x, JsContext ctx) {
        this.leftSquare();
        this.printExpressions(x.getExpressions());
        this.rightSquare();
        return false;
    }

    private void printExpressions(List<JsExpression> expressions) {
        boolean notFirst = false;
        for (JsExpression expression : expressions) {
            notFirst = this.sepCommaOptSpace(notFirst) && !(expression instanceof JsDocComment);
            boolean isEnclosed = this.parenPushIfCommaExpression(expression);
            this.accept(expression);
            if (!isEnclosed) continue;
            this.rightParen();
        }
    }

    @Override
    public boolean visit(JsBinaryOperation binaryOperation, JsContext context) {
        boolean isParenOpened;
        JsBinaryOperator operator = binaryOperation.getOperator();
        JsExpression arg1 = binaryOperation.getArg1();
        boolean isExpressionEnclosed = this.parenPush(binaryOperation, arg1, !operator.isLeftAssociative());
        this.accept(arg1);
        if (operator.isKeyword()) {
            this._parenPopOrSpace(binaryOperation, arg1, !operator.isLeftAssociative());
        } else if (operator != JsBinaryOperator.COMMA) {
            if (isExpressionEnclosed) {
                this.rightParen();
            }
            this.spaceOpt();
        }
        this.p.print(operator.getSymbol());
        JsExpression arg2 = binaryOperation.getArg2();
        if (operator == JsBinaryOperator.COMMA) {
            isParenOpened = false;
            this.spaceOpt();
        } else if (arg2 instanceof JsBinaryOperation && ((JsBinaryOperation)arg2).getOperator() == JsBinaryOperator.AND) {
            this.spaceOpt();
            this.leftParen();
            isParenOpened = true;
        } else if (JsToStringGenerationVisitor.spaceCalc(operator, arg2)) {
            isParenOpened = this._parenPushOrSpace(binaryOperation, arg2, operator.isLeftAssociative());
        } else {
            this.spaceOpt();
            isParenOpened = this.parenPush(binaryOperation, arg2, operator.isLeftAssociative());
        }
        this.accept(arg2);
        if (isParenOpened) {
            this.rightParen();
        }
        return false;
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        this.printJsBlock(x, true, true);
        return false;
    }

    @Override
    public boolean visit(JsLiteral.JsBooleanLiteral x, JsContext ctx) {
        if (x.getValue()) {
            this.p.print(CHARS_TRUE);
        } else {
            this.p.print(CHARS_FALSE);
        }
        return false;
    }

    @Override
    public boolean visit(JsBreak x, JsContext ctx) {
        this.p.print(CHARS_BREAK);
        this.continueOrBreakLabel(x);
        return false;
    }

    @Override
    public boolean visit(JsContinue x, JsContext ctx) {
        this.p.print(CHARS_CONTINUE);
        this.continueOrBreakLabel(x);
        return false;
    }

    private void continueOrBreakLabel(JsContinue x) {
        JsNameRef label = x.getLabel();
        if (label != null) {
            this.space();
            this._nameRef(label);
        }
    }

    @Override
    public boolean visit(JsCatch x, JsContext ctx) {
        this.spaceOpt();
        this.p.print(CHARS_CATCH);
        this.spaceOpt();
        this.leftParen();
        this.nameDef(x.getParameter().getName());
        JsExpression catchCond = x.getCondition();
        if (catchCond != null) {
            this.space();
            this._if();
            this.space();
            this.accept(catchCond);
        }
        this.rightParen();
        this.spaceOpt();
        this.accept(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsConditional x, JsContext ctx) {
        this.printPair(x, x.getTestExpression());
        this.spaceOpt();
        this.questionMark();
        this.spaceOpt();
        this.printPair(x, x.getThenExpression());
        this.spaceOpt();
        this._colon();
        this.spaceOpt();
        this.printPair(x, x.getElseExpression());
        return false;
    }

    private void printPair(JsExpression parent, JsExpression expression) {
        boolean isNeedParen = JsToStringGenerationVisitor.parenCalc(parent, expression, false);
        if (isNeedParen) {
            this.leftParen();
        }
        this.accept(expression);
        if (isNeedParen) {
            this.rightParen();
        }
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        this._while();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getCondition());
        this.rightParen();
        this._nestedPush(x.getBody());
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsDoWhile x, JsContext ctx) {
        this.p.print(CHARS_DO);
        this._nestedPush(x.getBody());
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        if (this.needSemi) {
            this.semi();
            this.newlineOpt();
        } else {
            this.spaceOpt();
            this.needSemi = true;
        }
        this._while();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getCondition());
        this.rightParen();
        return false;
    }

    @Override
    public boolean visit(JsEmpty x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsExpressionStatement x, JsContext ctx) {
        boolean surroundWithParentheses = JsFirstExpressionVisitor.exec(x);
        if (surroundWithParentheses) {
            this.leftParen();
        }
        this.accept(x.getExpression());
        if (surroundWithParentheses) {
            this.rightParen();
        }
        return false;
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        this._for();
        this.spaceOpt();
        this.leftParen();
        if (x.getInitExpr() != null) {
            this.accept(x.getInitExpr());
        } else if (x.getInitVars() != null) {
            this.accept(x.getInitVars());
        }
        this.semi();
        if (x.getCondition() != null) {
            this.spaceOpt();
            this.accept(x.getCondition());
        }
        this.semi();
        if (x.getIncrExpr() != null) {
            this.spaceOpt();
            this.accept(x.getIncrExpr());
        }
        this.rightParen();
        this._nestedPush(x.getBody());
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        this.p.print(CHARS_FUNCTION);
        this.space();
        if (x.getName() != null) {
            this.nameOf(x);
        }
        this.leftParen();
        boolean notFirst = false;
        Iterator<JsParameter> i$ = x.getParameters().iterator();
        while (i$.hasNext()) {
            JsParameter element;
            JsParameter param = element = i$.next();
            notFirst = this.sepCommaOptSpace(notFirst);
            this.accept(param);
        }
        this.rightParen();
        this.space();
        this.lineBreakAfterBlock = false;
        this.accept(x.getBody());
        this.needSemi = true;
        return false;
    }

    @Override
    public boolean visit(JsIf x, JsContext ctx) {
        this._if();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getIfExpression());
        this.rightParen();
        JsStatement thenStmt = x.getThenStatement();
        this._nestedPush(thenStmt);
        this.accept(thenStmt);
        this._nestedPop(thenStmt);
        JsStatement elseStatement = x.getElseStatement();
        if (elseStatement != null) {
            if (this.needSemi) {
                this.semi();
                this.newlineOpt();
            } else {
                this.spaceOpt();
                this.needSemi = true;
            }
            this.p.print(CHARS_ELSE);
            boolean elseIf = elseStatement instanceof JsIf;
            if (!elseIf) {
                this._nestedPush(elseStatement);
            } else {
                this.space();
            }
            this.accept(elseStatement);
            if (!elseIf) {
                this._nestedPop(elseStatement);
            }
        }
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        this.printPair(x, x.getQualifier());
        this.leftParen();
        this.printExpressions(x.getArguments());
        this.rightParen();
        return false;
    }

    @Override
    public boolean visit(JsNameRef x, JsContext ctx) {
        JsExpression q = x.getQualifier();
        if (q != null) {
            this.parenPush(x, q, false);
            if (q instanceof JsNumberLiteral) {
                this.leftParen();
            }
            this.accept(q);
            if (q instanceof JsNumberLiteral) {
                this.rightParen();
            }
            this.parenPop(x, q, false);
            this.p.print('.');
        }
        this._nameRef(x);
        return false;
    }

    @Override
    public boolean visit(JsNew x, JsContext ctx) {
        this.p.print(CHARS_NEW);
        this.space();
        JsExpression ctorExpr = x.getConstructorExpression();
        boolean needsParens = JsConstructExpressionVisitor.exec(ctorExpr);
        if (needsParens) {
            this.leftParen();
        }
        this.accept(ctorExpr);
        if (needsParens) {
            this.rightParen();
        }
        this.leftParen();
        this.printExpressions(x.getArguments());
        this.rightParen();
        return false;
    }

    @Override
    public boolean visit(JsNullLiteral x, JsContext ctx) {
        this.p.print(CHARS_NULL);
        return false;
    }

    @Override
    public boolean visit(JsNumberLiteral.JsIntLiteral x, JsContext ctx) {
        this.p.print(x.value);
        return false;
    }

    @Override
    public boolean visit(JsNumberLiteral.JsDoubleLiteral x, JsContext ctx) {
        this.p.print(x.value);
        return false;
    }

    @Override
    public boolean visit(JsObjectLiteral objectLiteral, JsContext context) {
        this.p.print('{');
        if (objectLiteral.isMultiline()) {
            this.p.indentIn();
        }
        boolean notFirst = false;
        for (JsPropertyInitializer item : objectLiteral.getPropertyInitializers()) {
            if (notFirst) {
                this.p.print(',');
            }
            if (objectLiteral.isMultiline()) {
                this.newlineOpt();
            } else if (notFirst) {
                this.spaceOpt();
            }
            notFirst = true;
            JsExpression labelExpr = item.getLabelExpr();
            if (labelExpr instanceof JsNameRef) {
                this.p.print(((JsNameRef)labelExpr).getIdent());
            } else if (labelExpr instanceof JsStringLiteral) {
                this.p.print(((JsStringLiteral)labelExpr).getValue());
            } else {
                this.accept(labelExpr);
            }
            this._colon();
            this.space();
            JsExpression valueExpr = item.getValueExpr();
            boolean wasEnclosed = this.parenPushIfCommaExpression(valueExpr);
            this.accept(valueExpr);
            if (!wasEnclosed) continue;
            this.rightParen();
        }
        if (objectLiteral.isMultiline()) {
            this.p.indentOut();
            this.newlineOpt();
        }
        this.p.print('}');
        return false;
    }

    @Override
    public boolean visit(JsParameter x, JsContext ctx) {
        this.nameOf(x);
        return false;
    }

    @Override
    public boolean visit(JsPostfixOperation x, JsContext ctx) {
        JsUnaryOperator op = x.getOperator();
        JsExpression arg = x.getArg();
        this.printPair(x, arg);
        this.p.print(op.getSymbol());
        return false;
    }

    @Override
    public boolean visit(JsPrefixOperation x, JsContext ctx) {
        JsUnaryOperator op = x.getOperator();
        this.p.print(op.getSymbol());
        JsExpression arg = x.getArg();
        if (JsToStringGenerationVisitor.spaceCalc(op, arg)) {
            this.space();
        }
        this.printPair(x, arg);
        return false;
    }

    @Override
    public boolean visit(JsProgram x, JsContext ctx) {
        this.p.print("<JsProgram>");
        return false;
    }

    @Override
    public boolean visit(JsProgramFragment x, JsContext ctx) {
        this.p.print("<JsProgramFragment>");
        return false;
    }

    @Override
    public boolean visit(JsPropertyInitializer x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsReturn x, JsContext ctx) {
        this.p.print(CHARS_RETURN);
        JsExpression expr = x.getExpr();
        if (expr != null) {
            this.space();
            this.accept(expr);
        }
        return false;
    }

    @Override
    public boolean visit(JsStringLiteral x, JsContext ctx) {
        this.p.print(JsToStringGenerationVisitor.javaScriptString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(JsLiteral.JsThisRef x, JsContext ctx) {
        this.p.print(CHARS_THIS);
        return false;
    }

    @Override
    public boolean visit(JsThrow x, JsContext ctx) {
        this.p.print(CHARS_THROW);
        this.space();
        this.accept(x.getExpression());
        return false;
    }

    @Override
    public boolean visit(JsTry x, JsContext ctx) {
        this.p.print(CHARS_TRY);
        this.spaceOpt();
        this.accept(x.getTryBlock());
        this.acceptList(x.getCatches());
        JsBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            this.p.print(CHARS_FINALLY);
            this.spaceOpt();
            this.accept(finallyBlock);
        }
        return false;
    }

    @Override
    public boolean visit(JsVars.JsVar var, JsContext ctx) {
        this.nameOf(var);
        JsExpression initExpr = var.getInitExpression();
        if (initExpr != null) {
            this.spaceOpt();
            this.assignment();
            this.spaceOpt();
            boolean isEnclosed = this.parenPushIfCommaExpression(initExpr);
            this.accept(initExpr);
            if (isEnclosed) {
                this.rightParen();
            }
        }
        return false;
    }

    @Override
    public boolean visit(JsVars vars, JsContext context) {
        this.var();
        this.space();
        boolean sep = false;
        for (JsVars.JsVar var : vars) {
            if (sep) {
                if (vars.isMultiline()) {
                    this.newlineOpt();
                }
                this.p.print(',');
                this.spaceOpt();
            } else {
                sep = true;
            }
            this.accept(var);
        }
        return false;
    }

    @Override
    public boolean visit(JsDocComment comment, JsContext context) {
        boolean asSingleLine;
        boolean bl = asSingleLine = comment.getTags().size() == 1;
        if (!asSingleLine) {
            this.newlineOpt();
        }
        this.p.print("/**");
        if (asSingleLine) {
            this.space();
        } else {
            this.p.newline();
        }
        boolean notFirst = false;
        for (Map.Entry<String, Object> entry : comment.getTags().entrySet()) {
            if (notFirst) {
                this.p.newline();
                this.p.print(' ');
                this.p.print('*');
            } else {
                notFirst = true;
            }
            this.p.print('@');
            this.p.print(entry.getKey());
            Object value = entry.getValue();
            if (value != null) {
                this.space();
                if (value instanceof CharSequence) {
                    this.p.print((CharSequence)value);
                } else {
                    this.visit((JsNameRef)value, context);
                }
            }
            if (asSingleLine) continue;
            this.p.newline();
        }
        if (asSingleLine) {
            this.space();
        } else {
            this.newlineOpt();
        }
        this.p.print('*');
        this.p.print('/');
        if (asSingleLine) {
            this.spaceOpt();
        }
        return false;
    }

    protected final void newlineOpt() {
        if (!this.p.isCompact()) {
            this.p.newline();
        }
    }

    protected void printJsBlock(JsBlock x, boolean truncate, boolean finalNewline) {
        boolean needBraces;
        if (!this.lineBreakAfterBlock) {
            finalNewline = false;
            this.lineBreakAfterBlock = true;
        }
        boolean bl = needBraces = !x.isGlobalBlock();
        if (needBraces) {
            this._blockOpen();
        }
        int count = 0;
        Iterator<JsStatement> iterator = x.getStatements().iterator();
        while (iterator.hasNext()) {
            boolean isGlobal;
            boolean bl2 = isGlobal = x.isGlobalBlock() || this.globalBlocks.contains(x);
            if (truncate && count > 3) {
                this.p.print("[...]");
                this.newlineOpt();
                break;
            }
            JsStatement statement = iterator.next();
            if (statement instanceof JsEmpty) continue;
            this.needSemi = true;
            boolean stmtIsGlobalBlock = false;
            if (isGlobal && statement instanceof JsBlock) {
                stmtIsGlobalBlock = true;
                this.globalBlocks.add((JsBlock)statement);
            }
            this.accept(statement);
            if (stmtIsGlobalBlock) {
                this.globalBlocks.remove(statement);
            }
            if (this.needSemi) {
                boolean lastStatement;
                boolean functionStmt = statement instanceof JsExpressionStatement && ((JsExpressionStatement)statement).getExpression() instanceof JsFunction;
                boolean bl3 = lastStatement = !iterator.hasNext() && needBraces && !JsRequiresSemiVisitor.exec(statement);
                if (functionStmt) {
                    if (lastStatement) {
                        this.newlineOpt();
                    } else {
                        this.p.newline();
                    }
                } else {
                    if (lastStatement) {
                        this.p.printOpt(';');
                    } else {
                        this.semi();
                    }
                    this.newlineOpt();
                }
            }
            ++count;
        }
        if (needBraces) {
            this.p.indentOut();
            this.p.print('}');
            if (finalNewline) {
                this.newlineOpt();
            }
        }
        this.needSemi = false;
    }

    private void assignment() {
        this.p.print('=');
    }

    private void _blockOpen() {
        this.p.print('{');
        this.p.indentIn();
        this.newlineOpt();
    }

    private void _colon() {
        this.p.print(':');
    }

    private void _for() {
        this.p.print(CHARS_FOR);
    }

    private void _if() {
        this.p.print(CHARS_IF);
    }

    private void leftParen() {
        this.p.print('(');
    }

    private void leftSquare() {
        this.p.print('[');
    }

    private void nameDef(JsName name) {
        this.p.print(name.getIdent());
    }

    private void nameOf(HasName hasName) {
        this.nameDef(hasName.getName());
    }

    private void _nameRef(JsNameRef nameRef) {
        this.p.print(nameRef.getIdent());
    }

    private boolean _nestedPop(JsStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JsBlock);
        if (pop) {
            this.p.indentOut();
        }
        return pop;
    }

    private boolean _nestedPush(JsStatement statement) {
        boolean push;
        boolean bl = push = !(statement instanceof JsBlock);
        if (push) {
            this.newlineOpt();
            this.p.indentIn();
        } else {
            this.spaceOpt();
        }
        return push;
    }

    private static boolean parenCalc(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        int childPrec;
        int parentPrec = JsPrecedenceVisitor.exec(parent);
        return parentPrec > (childPrec = JsPrecedenceVisitor.exec(child)) || parentPrec == childPrec && wrongAssoc;
    }

    private boolean parenPop(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this.rightParen();
        }
        return doPop;
    }

    private boolean _parenPopOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this.rightParen();
        } else {
            this.space();
        }
        return doPop;
    }

    private boolean parenPush(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean parenPushIfCommaExpression(JsExpression x) {
        boolean doPush;
        boolean bl = doPush = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean _parenPushOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        } else {
            this.space();
        }
        return doPush;
    }

    private void questionMark() {
        this.p.print('?');
    }

    private void rightParen() {
        this.p.print(')');
    }

    private void rightSquare() {
        this.p.print(']');
    }

    private void semi() {
        this.p.print(';');
    }

    private boolean sepCommaOptSpace(boolean sep) {
        if (sep) {
            this.p.print(',');
            this.spaceOpt();
        }
        return true;
    }

    private void space() {
        this.p.print(' ');
    }

    private static boolean spaceCalc(JsOperator op, JsExpression arg) {
        if (op.isKeyword()) {
            return true;
        }
        if (arg instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)arg;
            return binary.getOperator().getPrecedence() > op.getPrecedence() && JsToStringGenerationVisitor.spaceCalc(op, binary.getArg1());
        }
        if (arg instanceof JsPrefixOperation) {
            JsUnaryOperator op2 = ((JsPrefixOperation)arg).getOperator();
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && (op2 == JsUnaryOperator.DEC || op2 == JsUnaryOperator.NEG) || op == JsBinaryOperator.ADD && op2 == JsUnaryOperator.INC;
        }
        if (arg instanceof JsNumberLiteral && (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG)) {
            if (arg instanceof JsNumberLiteral.JsIntLiteral) {
                return ((JsNumberLiteral.JsIntLiteral)arg).value < 0;
            }
            assert (arg instanceof JsNumberLiteral.JsDoubleLiteral);
            return ((JsNumberLiteral.JsDoubleLiteral)arg).value < 0.0;
        }
        return false;
    }

    private void spaceOpt() {
        this.p.printOpt(' ');
    }

    private void var() {
        this.p.print(CHARS_VAR);
    }

    private void _while() {
        this.p.print(CHARS_WHILE);
    }
}

