/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsNodeImpl;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JsTry
extends JsNodeImpl
implements JsStatement {
    private final List<JsCatch> catches;
    private JsBlock finallyBlock;
    private JsBlock tryBlock;

    public JsTry() {
        this.catches = new SmartList<JsCatch>();
    }

    public JsTry(JsBlock tryBlock, List<JsCatch> catches, @Nullable JsBlock finallyBlock) {
        this.tryBlock = tryBlock;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
    }

    public List<JsCatch> getCatches() {
        return this.catches;
    }

    public JsBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public JsBlock getTryBlock() {
        return this.tryBlock;
    }

    @Override
    public void traverse(JsVisitor v, JsContext context) {
        if (v.visit(this, context)) {
            this.tryBlock = v.accept(this.tryBlock);
            v.acceptWithInsertRemove(this.catches);
            if (this.finallyBlock != null) {
                this.finallyBlock = v.accept(this.finallyBlock);
            }
        }
        v.endVisit(this, context);
    }
}

