/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.annotations.NotNull;

public class PersistentRangeMarkerUtil {
    public static boolean shouldTranslateViaDiff(@NotNull DocumentEventImpl e, @NotNull RangeMarker rangeMarker) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil", "shouldTranslateViaDiff"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil", "shouldTranslateViaDiff"));
        }
        if (e.isWholeTextReplaced()) {
            return true;
        }
        if (!rangeMarker.isValid()) {
            return false;
        }
        if (e.getOffset() >= rangeMarker.getEndOffset() || e.getOffset() + e.getOldLength() <= rangeMarker.getStartOffset()) {
            return false;
        }
        return (double)Math.max(e.getNewLength(), e.getOldLength()) * 1.0 / (double)e.getDocument().getTextLength() >= 0.8;
    }
}

