/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.ReplaceChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TreeChangeImpl
implements TreeChange {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.events.impl.TreeChangeImpl");
    private final Map<ASTNode, ChangeInfo> myChanges = new THashMap<ASTNode, ChangeInfo>();
    private final List<Pair<ASTNode, Integer>> mySortedChanges = new ArrayList<Pair<ASTNode, Integer>>();
    private final ASTNode myParent;
    private static boolean ourDoChecks = true;
    private static boolean ourEnableAddChangeAtOffsetOptimization = true;
    private static boolean ourEnableOptimizedNodeOldOffset = true;
    private static boolean ourEnableGetNewOffset = true;

    public TreeChangeImpl(ASTNode parent) {
        this.myParent = parent;
    }

    @Override
    public void addChange(ASTNode child, @NotNull ChangeInfo changeInfo) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "addChange"));
        }
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        ChangeInfo current = this.myChanges.get(child);
        if (current != null && changeInfo.getChangeType() == 3) {
            return;
        }
        if (changeInfo.getChangeType() == 2) {
            ReplaceChangeInfoImpl replaceChangeInfo = (ReplaceChangeInfoImpl)changeInfo;
            ASTNode replaced = replaceChangeInfo.getReplaced();
            ChangeInfo replacedInfo = this.myChanges.get(replaced);
            if (replacedInfo == null) {
                this.addChangeInternal(child, changeInfo);
            } else {
                switch (replacedInfo.getChangeType()) {
                    case 2: {
                        replaceChangeInfo.setOldLength(replacedInfo.getOldLength());
                        replaceChangeInfo.setReplaced(((ReplaceChangeInfo)((Object)replacedInfo)).getReplaced());
                        break;
                    }
                    case 0: {
                        changeInfo = ChangeInfoImpl.create((short)0, replaced);
                        this.removeChangeInternal(replaced);
                    }
                }
                this.addChangeInternal(child, changeInfo);
            }
            return;
        }
        if (current != null && current.getChangeType() == 1) {
            if (changeInfo.getChangeType() == 0) {
                if (!(child instanceof LeafElement)) {
                    changeInfo = ChangeInfoImpl.create((short)3, child);
                    ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
                    this.myChanges.put(child, changeInfo);
                } else {
                    this.removeChangeInternal(child);
                }
            }
            return;
        }
        if (current != null && current.getChangeType() == 0) {
            if (changeInfo.getChangeType() == 1) {
                this.removeChangeInternal(child);
            }
            return;
        }
        if (changeInfo.getChangeType() == 1) {
            if (child instanceof LeafElement) {
                CharSequence charTabIndex = child.getChars();
                if (this.checkLeaf(child.getTreeNext(), charTabIndex) || this.checkLeaf(child.getTreePrev(), charTabIndex)) {
                    return;
                }
            }
            this.addChangeInternal(child, changeInfo);
            if (current != null) {
                ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
            }
            return;
        }
        if (current == null) {
            this.addChangeInternal(child, changeInfo);
        }
    }

    private void addChangeInternal(ASTNode child, ChangeInfo info) {
        if (!this.myChanges.containsKey(child)) {
            int nodeOffset = this.getNodeOldOffset(child, info);
            this.addChangeAtOffset(child, nodeOffset);
        }
        this.myChanges.put(child, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addChangeAtOffset(ASTNode child, int nodeOffset) {
        block10: {
            block8: {
                block9: {
                    optimizedIndex = -1;
                    if (TreeChangeImpl.ourEnableAddChangeAtOffsetOptimization && this.mySortedChanges.size() > 0 && (pair = this.mySortedChanges.get(this.mySortedChanges.size() - 1)).getFirst() == child.getTreePrev() && pair.getSecond() <= nodeOffset) {
                        optimizedIndex = this.mySortedChanges.size();
                        if (!TreeChangeImpl.ourDoChecks) {
                            this.mySortedChanges.add(new Pair<ASTNode, Integer>(child, nodeOffset));
                            return;
                        }
                    }
                    index = 0;
                    try lbl-1000:
                    // 2 sources

                    {
                        for (Pair<ASTNode, Integer> pair : this.mySortedChanges) {
                            if (child == pair.getFirst()) {
                                if (optimizedIndex == -1) return;
                                if (index == optimizedIndex) return;
                                prev = child.getTreePrev();
                                pair = this.mySortedChanges.get(index);
                                prevChange = this.myChanges.get(prev);
                                prevChange2 = this.myChanges.get(pair.getFirst());
                                v0 = new StringBuilder().append("Failed to calculate optimized index for add change at offset: prev node:").append(prev).append(", prev change:").append(prevChange).append(",prev change length:");
                                if (prevChange == null) break block8;
                                break block9;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl55
                    }
                    catch (Throwable var11_18) {
                        if (optimizedIndex == -1) throw var11_18;
                        if (index == optimizedIndex) throw var11_18;
                        prev = child.getTreePrev();
                        pair = this.mySortedChanges.get(index);
                        prevChange = this.myChanges.get(prev);
                        prevChange2 = this.myChanges.get(pair.getFirst());
                        TreeChangeImpl.LOG.error("Failed to calculate optimized index for add change at offset: prev node:" + prev + ", prev change:" + prevChange + ",prev change length:" + (prevChange != null ? Integer.valueOf(prevChange.getOldLength()) : null) + ", prev text length:" + prev.getTextLength() + ",prev offset:" + this.mySortedChanges.get(this.mySortedChanges.size() - 1).getSecond() + ", node:" + child + ", nodeOffset:" + nodeOffset + ", optimizedIndex:" + optimizedIndex + ", real index:" + index + ", same node:" + (pair.getFirst() == child) + ", at place:" + pair.getSecond() + ", node:" + pair.getFirst() + ", change:" + prevChange2 + ", prevChange oldLength:" + (prevChange2 != null ? Integer.valueOf(prevChange2.getOldLength()) : null) + ", prevchange length2:" + pair.getFirst().getTextLength() + "," + this.toString());
                        TreeChangeImpl.ourEnableAddChangeAtOffsetOptimization = false;
                        throw var11_18;
                    }
                }
                v1 = prevChange.getOldLength();
                break block10;
            }
            v1 = null;
        }
        TreeChangeImpl.LOG.error(v0.append(v1).append(", prev text length:").append(prev.getTextLength()).append(",prev offset:").append(this.mySortedChanges.get(this.mySortedChanges.size() - 1).getSecond()).append(", node:").append(child).append(", nodeOffset:").append(nodeOffset).append(", optimizedIndex:").append(optimizedIndex).append(", real index:").append(index).append(", same node:").append(pair.getFirst() == child).append(", at place:").append(pair.getSecond()).append(", node:").append(pair.getFirst()).append(", change:").append(prevChange2).append(", prevChange oldLength:").append(prevChange2 != null ? Integer.valueOf(prevChange2.getOldLength()) : null).append(", prevchange length2:").append(pair.getFirst().getTextLength()).append(",").append(this.toString()).toString());
        TreeChangeImpl.ourEnableAddChangeAtOffsetOptimization = false;
        return;
lbl-1000:
        // 1 sources

        {
            if (nodeOffset >= pair.getSecond() && (nodeOffset != pair.getSecond() || !TreeChangeImpl.isAfter(pair.getFirst(), child))) ** GOTO lbl-1000
            this.mySortedChanges.add(index, new Pair<ASTNode, Integer>(child, nodeOffset));
            if (optimizedIndex == -1) return;
            if (index == optimizedIndex) return;
            prev = child.getTreePrev();
            pair = this.mySortedChanges.get(index);
            prevChange = this.myChanges.get(prev);
            prevChange2 = this.myChanges.get(pair.getFirst());
            TreeChangeImpl.LOG.error("Failed to calculate optimized index for add change at offset: prev node:" + prev + ", prev change:" + prevChange + ",prev change length:" + (prevChange != null ? Integer.valueOf(prevChange.getOldLength()) : null) + ", prev text length:" + prev.getTextLength() + ",prev offset:" + this.mySortedChanges.get(this.mySortedChanges.size() - 1).getSecond() + ", node:" + child + ", nodeOffset:" + nodeOffset + ", optimizedIndex:" + optimizedIndex + ", real index:" + index + ", same node:" + (pair.getFirst() == child) + ", at place:" + pair.getSecond() + ", node:" + pair.getFirst() + ", change:" + prevChange2 + ", prevChange oldLength:" + (prevChange2 != null ? Integer.valueOf(prevChange2.getOldLength()) : null) + ", prevchange length2:" + pair.getFirst().getTextLength() + "," + this.toString());
        }
        TreeChangeImpl.ourEnableAddChangeAtOffsetOptimization = false;
        return;
lbl-1000:
        // 1 sources

        {
            ++index;
            ** GOTO lbl-1000
lbl55:
            // 1 sources

            this.mySortedChanges.add(new Pair<ASTNode, Integer>(child, nodeOffset));
            if (optimizedIndex == -1) return;
            if (index == optimizedIndex) return;
            prev = child.getTreePrev();
            pair = this.mySortedChanges.get(index);
            prevChange = this.myChanges.get(prev);
            prevChange2 = this.myChanges.get(pair.getFirst());
            TreeChangeImpl.LOG.error("Failed to calculate optimized index for add change at offset: prev node:" + prev + ", prev change:" + prevChange + ",prev change length:" + (prevChange != null ? Integer.valueOf(prevChange.getOldLength()) : null) + ", prev text length:" + prev.getTextLength() + ",prev offset:" + this.mySortedChanges.get(this.mySortedChanges.size() - 1).getSecond() + ", node:" + child + ", nodeOffset:" + nodeOffset + ", optimizedIndex:" + optimizedIndex + ", real index:" + index + ", same node:" + (pair.getFirst() == child) + ", at place:" + pair.getSecond() + ", node:" + pair.getFirst() + ", change:" + prevChange2 + ", prevChange oldLength:" + (prevChange2 != null ? Integer.valueOf(prevChange2.getOldLength()) : null) + ", prevchange length2:" + pair.getFirst().getTextLength() + "," + this.toString());
        }
        TreeChangeImpl.ourEnableAddChangeAtOffsetOptimization = false;
    }

    private static boolean isAfter(ASTNode what, ASTNode afterWhat) {
        ASTNode current = afterWhat.getTreeNext();
        while (current != null) {
            if (current == what) {
                return true;
            }
            if ((current = current.getTreeNext()) == null || current.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private void removeChangeInternal(ASTNode child) {
        this.myChanges.remove(child);
        int n = this.mySortedChanges.size();
        for (int i = 0; i < n; ++i) {
            if (child != this.mySortedChanges.get(i).getFirst()) continue;
            this.mySortedChanges.remove(i);
            break;
        }
    }

    private boolean checkLeaf(ASTNode treeNext, CharSequence charTabIndex) {
        if (!(treeNext instanceof LeafElement)) {
            return false;
        }
        ChangeInfo right = this.myChanges.get(treeNext);
        if (right != null && right.getChangeType() == 0 && charTabIndex == treeNext.getChars()) {
            this.removeChangeInternal(treeNext);
            return true;
        }
        return false;
    }

    @NotNull
    public TreeElement[] getAffectedChildren() {
        TreeElement[] treeElements = new TreeElement[this.myChanges.size()];
        int index = 0;
        for (Pair<ASTNode, Integer> pair : this.mySortedChanges) {
            treeElements[index++] = (TreeElement)pair.getFirst();
        }
        if (treeElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "getAffectedChildren"));
        }
        return treeElements;
    }

    @Override
    public ChangeInfo getChangeByChild(ASTNode child) {
        return this.myChanges.get(child);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void add(@NotNull TreeChange value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "add"));
        }
        TreeChangeImpl impl = (TreeChangeImpl)value;
        LOG.assertTrue(impl.myParent == this.myParent);
        for (Pair<ASTNode, Integer> pair : impl.mySortedChanges) {
            ASTNode replaced;
            ASTNode child = pair.getFirst();
            ChangeInfo change = impl.myChanges.get(child);
            if (change.getChangeType() == 1) {
                ChangeInfo oldChange = this.myChanges.get(child);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            this.removeChangeInternal(child);
                            break;
                        }
                        case 2: {
                            replaced = ((ReplaceChangeInfo)((Object)oldChange)).getReplaced();
                            this.removeChangeInternal(child);
                            this.myChanges.put(replaced, ChangeInfoImpl.create((short)1, replaced));
                            this.addChangeAtOffset(replaced, this.getOldOffset(pair.getSecond()));
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            this.myChanges.put(child, change);
                        }
                    }
                    continue;
                }
                this.myChanges.put(child, change);
                this.addChangeAtOffset(child, this.getOldOffset(pair.getSecond()));
                continue;
            }
            if (change.getChangeType() == 2) {
                ReplaceChangeInfo replaceChangeInfo = (ReplaceChangeInfo)((Object)change);
                replaced = replaceChangeInfo.getReplaced();
                ChangeInfo oldChange = this.myChanges.get(replaced);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            change = ChangeInfoImpl.create((short)0, child);
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            break;
                        }
                        case 2: {
                            ASTNode oldReplaced = ((ReplaceChangeInfo)((Object)oldChange)).getReplaced();
                            ReplaceChangeInfoImpl rep = new ReplaceChangeInfoImpl(child);
                            rep.setReplaced(oldReplaced);
                            change = rep;
                        }
                    }
                    this.removeChangeInternal(replaced);
                }
                this.addChange(child, change);
                continue;
            }
            this.addChange(child, change);
        }
    }

    @Override
    public int getOldLength() {
        int oldLength = ((TreeElement)this.myParent).getNotCachedLength();
        for (Map.Entry<ASTNode, ChangeInfo> entry : this.myChanges.entrySet()) {
            ASTNode key = entry.getKey();
            ChangeInfo change = entry.getValue();
            int length = ((TreeElement)key).getNotCachedLength();
            switch (change.getChangeType()) {
                case 0: {
                    oldLength -= length;
                    break;
                }
                case 1: {
                    oldLength += length;
                    break;
                }
                case 2: 
                case 3: {
                    oldLength += change.getOldLength() - length;
                }
            }
        }
        return oldLength;
    }

    private static int getNewLength(ChangeInfo change, ASTNode node) {
        if (change.getChangeType() == 1) {
            return 0;
        }
        return node.getTextLength();
    }

    private int getOptimizedNodeOldOffset(ASTNode child, ChangeInfo changeInfo) {
        ChangeInfo prevSiblingChange;
        Pair<ASTNode, Integer> pair;
        if (!ourEnableOptimizedNodeOldOffset) {
            return -1;
        }
        ASTNode prevSibling = child.getTreePrev();
        if (prevSibling != null && this.mySortedChanges.size() > 0 && (pair = this.mySortedChanges.get(this.mySortedChanges.size() - 1)).getFirst() == prevSibling && ((prevSiblingChange = this.myChanges.get(prevSibling)).getChangeType() == 1 && changeInfo.getChangeType() == 1 || prevSiblingChange.getChangeType() == 0 && changeInfo.getChangeType() == 0)) {
            int oldOffset;
            int optimizedResult = pair.getSecond() + prevSiblingChange.getOldLength();
            if (ourDoChecks && optimizedResult != (oldOffset = this.calculateOldOffsetLinearly(child))) {
                LOG.error("Failed optimized node old offset check:" + changeInfo + ", previous:" + prevSibling + "," + prevSiblingChange);
                ourEnableOptimizedNodeOldOffset = false;
                optimizedResult = oldOffset;
            }
            return optimizedResult;
        }
        return -1;
    }

    private int getNodeOldOffset(ASTNode child, ChangeInfo changeInfo) {
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        int oldOffsetInParent = this.getOptimizedNodeOldOffset(child, changeInfo);
        if (oldOffsetInParent == -1) {
            oldOffsetInParent = this.calculateOldOffsetLinearly(child);
        }
        return oldOffsetInParent;
    }

    private int calculateOldOffsetLinearly(ASTNode child) {
        int oldOffsetInParent = 0;
        for (ASTNode current = this.myParent.getFirstChildNode(); current != child; current = current.getTreeNext()) {
            if (this.myChanges.containsKey(current)) continue;
            oldOffsetInParent += current.getTextLength();
        }
        for (Pair<ASTNode, Integer> offset : this.mySortedChanges) {
            if (offset.getSecond() > oldOffsetInParent) break;
            ChangeInfo change = this.myChanges.get(offset.getFirst());
            oldOffsetInParent += change.getOldLength();
        }
        return oldOffsetInParent;
    }

    private int getOldOffset(int offset) {
        for (Pair<ASTNode, Integer> pair : this.mySortedChanges) {
            if (pair.getSecond() > offset) break;
            ChangeInfo change = this.myChanges.get(pair.getFirst());
            offset += change.getOldLength() - TreeChangeImpl.getNewLength(change, pair.getFirst());
        }
        return offset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<Pair<ASTNode, Integer>> iterator = this.mySortedChanges.iterator();
        while (iterator.hasNext()) {
            Pair<ASTNode, Integer> pair = iterator.next();
            ASTNode node = pair.getFirst();
            buffer.append("(");
            buffer.append(node.getElementType().toString());
            buffer.append(" at ").append(pair.getSecond()).append(", ");
            ChangeInfo child = this.getChangeByChild(node);
            buffer.append(child != null ? child.toString() : "null");
            buffer.append(")");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

