/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.SourceStubPsiFactory;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;

public class PsiJavaFileStubImpl
extends PsiFileStubImpl<PsiJavaFile>
implements PsiJavaFileStub {
    private StringRef myPackageName;
    private final boolean myCompiled;
    private StubPsiFactory myFactory;

    public PsiJavaFileStubImpl(PsiJavaFile file, StringRef packageName, boolean compiled) {
        super(file);
        this.myPackageName = packageName;
        this.myCompiled = compiled;
        this.myFactory = compiled ? new ClsStubPsiFactory() : new SourceStubPsiFactory();
    }

    public PsiJavaFileStubImpl(String packageName, boolean compiled) {
        this(null, StringRef.fromString(packageName), compiled);
    }

    @Override
    public String getPackageName() {
        return StringRef.toString(this.myPackageName);
    }

    @Override
    public boolean isCompiled() {
        return this.myCompiled;
    }

    @Override
    public StubPsiFactory getPsiFactory() {
        return this.myFactory;
    }

    @Override
    public void setPsiFactory(StubPsiFactory factory) {
        this.myFactory = factory;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = StringRef.fromString(packageName);
    }

    @Override
    public IStubFileElementType getType() {
        return JavaStubElementTypes.JAVA_FILE;
    }

    @Override
    public String toString() {
        return "PsiJavaFileStub [" + this.myPackageName + "]";
    }

    @Override
    public PsiClass[] getClasses() {
        return (PsiClass[])this.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
    }
}

