/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.jet.codegen.MemberMap;

public abstract class ClassBuilder {
    private String thisName;
    private final MemberMap members = new MemberMap();

    public FieldVisitor newField(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
        return this.getVisitor().visitField(access, name, desc, signature, value);
    }

    public MethodVisitor newMethod(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        return this.getVisitor().visitMethod(access, name, desc, signature, exceptions);
    }

    @NotNull
    public MemberMap getMemberMap() {
        return this.members;
    }

    @NotNull
    public AnnotationVisitor newAnnotation(@NotNull String desc, boolean visible) {
        return this.getVisitor().visitAnnotation(desc, visible);
    }

    public void done() {
        this.getVisitor().visitEnd();
    }

    @NotNull
    public abstract ClassVisitor getVisitor();

    public void defineClass(@Nullable PsiElement origin, int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        this.thisName = name;
        this.getVisitor().visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(@NotNull String name, @Nullable String debug) {
        this.getVisitor().visitSource(name, debug);
    }

    public void visitOuterClass(@NotNull String owner, @Nullable String name, @Nullable String desc) {
        this.getVisitor().visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.getVisitor().visitInnerClass(name, outerName, innerName, access);
    }

    @NotNull
    public String getThisName() {
        assert (this.thisName != null) : "This name isn't set";
        return this.thisName;
    }

    public static class Concrete
    extends ClassBuilder {
        private final ClassVisitor v;

        public Concrete(@NotNull ClassVisitor v) {
            this.v = v;
        }

        @Override
        @NotNull
        public ClassVisitor getVisitor() {
            return this.v;
        }
    }
}

