/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.ClassWriter;
import org.jetbrains.asm4.util.TraceClassVisitor;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderMode;

public class ClassBuilderFactories {
    public static ClassBuilderFactory TEST = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            return ClassBuilderMode.FULL;
        }

        @Override
        public ClassBuilder newClassBuilder() {
            return new TraceBuilder(new BinaryClassWriter());
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor.p.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            return ((TraceBuilder)builder).binary.toByteArray();
        }
    };
    public static ClassBuilderFactory TEXT = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            return ClassBuilderMode.FULL;
        }

        @Override
        public ClassBuilder newClassBuilder() {
            return new ClassBuilder.Concrete(new TraceClassVisitor(new PrintWriter(new StringWriter())));
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor.p.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            throw new UnsupportedOperationException("TEXT generator asked for bytes");
        }
    };

    private ClassBuilderFactories() {
    }

    public static ClassBuilderFactory binaries(final boolean stubs) {
        return new ClassBuilderFactory(){

            @Override
            @NotNull
            public ClassBuilderMode getClassBuilderMode() {
                return stubs ? ClassBuilderMode.STUBS : ClassBuilderMode.FULL;
            }

            @Override
            public ClassBuilder newClassBuilder() {
                return new ClassBuilder.Concrete(new BinaryClassWriter());
            }

            @Override
            public String asText(ClassBuilder builder) {
                throw new UnsupportedOperationException("BINARIES generator asked for text");
            }

            @Override
            public byte[] asBytes(ClassBuilder builder) {
                ClassWriter visitor = (ClassWriter)builder.getVisitor();
                return visitor.toByteArray();
            }
        };
    }

    private static class TraceBuilder
    extends ClassBuilder.Concrete {
        public final BinaryClassWriter binary;

        public TraceBuilder(BinaryClassWriter binary) {
            super(new TraceClassVisitor(binary, new PrintWriter(new StringWriter())));
            this.binary = binary;
        }
    }

    private static class BinaryClassWriter
    extends ClassWriter {
        public BinaryClassWriter() {
            super(3);
        }

        @Override
        protected String getCommonSuperClass(String type1, String type2) {
            try {
                return super.getCommonSuperClass(type1, type2);
            }
            catch (Throwable t) {
                return "java/lang/Object";
            }
        }
    }
}

