/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.NamespaceContext;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CodegenUtil {
    private static final Random RANDOM = new Random(55L);

    private CodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind == ClassKind.TRAIT || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isInterface(JetType type) {
        return CodegenUtil.isInterface(type.getConstructor().getDeclarationDescriptor());
    }

    public static SimpleFunctionDescriptor createInvoke(FunctionDescriptor fd) {
        int arity = fd.getValueParameters().size();
        SimpleFunctionDescriptorImpl invokeDescriptor = new SimpleFunctionDescriptorImpl(fd.getExpectedThisObject() != null ? KotlinBuiltIns.getInstance().getExtensionFunction(arity) : KotlinBuiltIns.getInstance().getFunction(arity), Collections.<AnnotationDescriptor>emptyList(), Name.identifier("invoke"), CallableMemberDescriptor.Kind.DECLARATION);
        invokeDescriptor.initialize(DescriptorUtils.getReceiverParameterType(fd.getReceiverParameter()), fd.getExpectedThisObject(), Collections.emptyList(), fd.getValueParameters(), fd.getReturnType(), Modality.FINAL, Visibilities.PUBLIC, false);
        return invokeDescriptor;
    }

    public static boolean isNonLiteralObject(JetClassOrObject myClass) {
        return myClass instanceof JetObjectDeclaration && !((JetObjectDeclaration)myClass).isObjectLiteral();
    }

    public static String createTmpVariableName(Collection<String> existingNames) {
        String prefix = "tmp";
        int i = RANDOM.nextInt(Integer.MAX_VALUE);
        String name = prefix + i;
        while (existingNames.contains(name)) {
            name = prefix + ++i;
        }
        return name;
    }

    public static JvmMethodSignature erasedInvokeSignature(FunctionDescriptor fd) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        boolean isExtensionFunction = fd.getReceiverParameter() != null;
        int paramCount = fd.getValueParameters().size();
        if (isExtensionFunction) {
            ++paramCount;
        }
        signatureWriter.writeParametersStart();
        for (int i = 0; i < paramCount; ++i) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            signatureWriter.writeAsmType(AsmTypeConstants.OBJECT_TYPE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeReturnType();
        signatureWriter.writeAsmType(AsmTypeConstants.OBJECT_TYPE);
        signatureWriter.writeReturnTypeEnd();
        return signatureWriter.makeJvmMethodSignature("invoke");
    }

    public static boolean isConst(CalculatedClosure closure) {
        return closure.getCaptureThis() == null && closure.getCaptureReceiver() == null && closure.getCaptureVariables().isEmpty();
    }

    public static <T> T peekFromStack(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    public static JetType getSuperClass(ClassDescriptor classDescriptor) {
        List<ClassDescriptor> superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor);
        for (ClassDescriptor descriptor : superclassDescriptors) {
            if (descriptor.getKind() == ClassKind.TRAIT) continue;
            return descriptor.getDefaultType();
        }
        return KotlinBuiltIns.getInstance().getAnyType();
    }

    @NotNull
    public static <T extends CallableMemberDescriptor> T unwrapFakeOverride(T member) {
        while (member.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            member = member.getOverriddenDescriptors().iterator().next();
        }
        return member;
    }

    @Nullable
    public static FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassDescriptor returnedClass, ClassDescriptor ... valueParameterClasses) {
        Collection<FunctionDescriptor> functions = owner.getDefaultType().getMemberScope().getFunctions(name);
        for (FunctionDescriptor function : functions) {
            if (function.getKind() != CallableMemberDescriptor.Kind.DECLARATION || !function.getTypeParameters().isEmpty() || !CodegenUtil.valueParameterClassesMatch(function.getValueParameters(), Arrays.asList(valueParameterClasses)) || !CodegenUtil.rawTypeMatches(function.getReturnType(), returnedClass)) continue;
            return function;
        }
        return null;
    }

    private static boolean valueParameterClassesMatch(@NotNull List<ValueParameterDescriptor> parameters, @NotNull List<ClassDescriptor> classes) {
        if (parameters.size() != classes.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ValueParameterDescriptor parameterDescriptor = parameters.get(i);
            ClassDescriptor classDescriptor = classes.get(i);
            if (CodegenUtil.rawTypeMatches(parameterDescriptor.getType(), classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean rawTypeMatches(JetType type, ClassDescriptor classDescriptor) {
        return type.getConstructor().getDeclarationDescriptor().getOriginal() == classDescriptor.getOriginal();
    }

    public static boolean isCallInsideSameClassAsDeclared(CallableMemberDescriptor declarationDescriptor, CodegenContext context) {
        boolean isFakeOverride = declarationDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = declarationDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = declarationDescriptor.getContainingDeclaration();
        containingDeclaration = containingDeclaration.getOriginal();
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof NamespaceContext && context.getParentContext().getContextDescriptor() == containingDeclaration) && context.getContextKind() != OwnerKind.TRAIT_IMPL;
    }

    public static boolean isCallInsideSameModuleAsDeclared(CallableMemberDescriptor declarationDescriptor, CodegenContext context) {
        if (context == CodegenContext.STATIC) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        return DescriptorUtils.isInSameModule(declarationDescriptor, contextDescriptor);
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        return ContainerUtil.exists(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors(), new Condition<DeclarationDescriptor>(){

            @Override
            public boolean value(DeclarationDescriptor declaration) {
                if (!(declaration instanceof MemberDescriptor)) {
                    return false;
                }
                return ((MemberDescriptor)declaration).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean isNullableType(@NotNull JetType type) {
        if (type.isNullable()) {
            return true;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return TypeUtils.hasNullableSuperType(type);
        }
        return false;
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forGetter, boolean isInsideClass, boolean isDelegated) {
        PropertyAccessorDescriptor accessorDescriptor = forGetter ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        boolean isExtensionProperty = propertyDescriptor.getReceiverParameter() != null;
        boolean specialTypeProperty = isDelegated || isExtensionProperty || DescriptorUtils.isClassObject(propertyDescriptor.getContainingDeclaration()) || JetTypeMapper.isAccessor(propertyDescriptor);
        return isInsideClass && !specialTypeProperty && (accessorDescriptor == null || accessorDescriptor.isDefault() && (!DescriptorUtils.isExternallyAccessible(propertyDescriptor) || accessorDescriptor.getModality() == Modality.FINAL));
    }

    @NotNull
    public static ImplementationBodyCodegen getParentBodyCodegen(@Nullable MemberCodegen classBodyCodegen) {
        assert (classBodyCodegen != null && classBodyCodegen.getParentCodegen() instanceof ImplementationBodyCodegen) : "Class object should have appropriate parent BodyCodegen";
        return (ImplementationBodyCodegen)classBodyCodegen.getParentCodegen();
    }

    static int getPathHashCode(@NotNull PsiFile file) {
        return FileUtil.toSystemDependentName(file.getVirtualFile().getPath()).hashCode();
    }

    @Nullable
    public static ClassDescriptor getExpectedThisObjectForConstructorCall(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        return expectedThisObject != null ? (ClassDescriptor)expectedThisObject.getContainingDeclaration() : null;
    }
}

