/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;

public class JvmMethodSignature {
    @NotNull
    private final Method asmMethod;
    private final String genericsSignature;
    @NotNull
    private final List<JvmMethodParameterSignature> kotlinParameterTypes;

    protected JvmMethodSignature(@NotNull Method asmMethod, @Nullable String genericsSignature, @NotNull List<JvmMethodParameterSignature> kotlinParameterTypes) {
        this.asmMethod = asmMethod;
        this.genericsSignature = genericsSignature;
        this.kotlinParameterTypes = kotlinParameterTypes;
    }

    @NotNull
    public Method getAsmMethod() {
        return this.asmMethod;
    }

    public String getGenericsSignature() {
        return this.genericsSignature;
    }

    @NotNull
    public List<JvmMethodParameterSignature> getKotlinParameterTypes() {
        return this.kotlinParameterTypes;
    }

    public List<Type> getValueParameterTypes() {
        ArrayList<Type> r = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature p : this.kotlinParameterTypes) {
            if (p.getKind() != JvmMethodParameterKind.VALUE) continue;
            r.add(p.getAsmType());
        }
        return r;
    }

    @NotNull
    public String getName() {
        return this.asmMethod.getName();
    }

    public String toString() {
        return this.asmMethod.toString();
    }
}

