/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqNameUnsafe relativeClassName;

    @NotNull
    public static ClassId fromFqNameAndContainingDeclaration(@NotNull FqName fqName, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        return ClassId.fromFqNameAndContainingDeclaration(fqName.toUnsafe(), containingDeclaration);
    }

    @NotNull
    public static ClassId fromFqNameAndContainingDeclaration(@NotNull FqNameUnsafe fqName, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        NamespaceDescriptor containingNamespace = DescriptorUtils.getParentOfType(containingDeclaration, NamespaceDescriptor.class, false);
        assert (containingNamespace != null);
        List<Name> fullNameSegments = fqName.pathSegments();
        FqName namespaceFqName = DescriptorUtils.getFQName(containingNamespace).toSafe();
        List<Name> namespaceNameSegments = namespaceFqName.pathSegments();
        assert (((Object)fullNameSegments.subList(0, namespaceNameSegments.size())).equals(namespaceNameSegments));
        List<Name> relativeNameSegments = fullNameSegments.subList(namespaceNameSegments.size(), fullNameSegments.size());
        return new ClassId(namespaceFqName, FqNameUnsafe.fromSegments(relativeNameSegments));
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull FqNameUnsafe relativeClassName) {
        this.packageFqName = packageFqName;
        assert (!relativeClassName.isRoot()) : "Class name must not be root. " + packageFqName;
        this.relativeClassName = relativeClassName;
    }

    @NotNull
    public FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public FqNameUnsafe getRelativeClassName() {
        return this.relativeClassName;
    }

    @NotNull
    public ClassId createNestedClassId(@NotNull Name name) {
        return new ClassId(this.getPackageFqName(), this.relativeClassName.child(name));
    }

    @NotNull
    public ClassId getOuterClassId() {
        return new ClassId(this.getPackageFqName(), this.relativeClassName.parent());
    }

    public boolean isTopLevelClass() {
        return this.relativeClassName.parent().isRoot();
    }

    public FqNameUnsafe asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            return this.relativeClassName;
        }
        return new FqNameUnsafe(this.packageFqName.asString() + "." + this.relativeClassName.asString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId id = (ClassId)o;
        if (!this.packageFqName.equals(id.packageFqName)) {
            return false;
        }
        return this.relativeClassName.equals(id.relativeClassName);
    }

    public int hashCode() {
        int result = this.packageFqName.hashCode();
        result = 31 * result + this.relativeClassName.hashCode();
        return result;
    }

    public String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.relativeClassName;
        }
        return this.packageFqName.toString().replace('.', '/') + "/" + this.relativeClassName;
    }
}

